/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.testFramework.builders.ModuleFixtureBuilder;
import com.intellij.testFramework.fixtures.HeavyIdeaTestFixture;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.TestFixtureBuilder;
import com.intellij.testFramework.fixtures.impl.HeavyIdeaTestFixtureImpl;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.pico.IdeaPicoContainer;
import java.lang.reflect.Field;
import java.util.Map;
import org.picocontainer.MutablePicoContainer;

class HeavyTestFixtureBuilderImpl
implements TestFixtureBuilder<IdeaProjectTestFixture> {
    private final FactoryMap<Class<? extends ModuleFixtureBuilder>, ModuleFixtureBuilder> myModuleFixtureBuilderFactory;
    private final HeavyIdeaTestFixtureImpl myFixture;

    public HeavyTestFixtureBuilderImpl(HeavyIdeaTestFixtureImpl fixture, final Map<Class<? extends ModuleFixtureBuilder>, Class<? extends ModuleFixtureBuilder>> providers) {
        this.myFixture = fixture;
        IdeaPicoContainer container = new IdeaPicoContainer();
        container.registerComponentInstance((Object)this);
        this.myModuleFixtureBuilderFactory = new FactoryMap<Class<? extends ModuleFixtureBuilder>, ModuleFixtureBuilder>((MutablePicoContainer)container){
            final /* synthetic */ MutablePicoContainer val$container;
            {
                this.val$container = mutablePicoContainer;
            }

            protected ModuleFixtureBuilder create(Class<? extends ModuleFixtureBuilder> key) {
                Class implClass = (Class)providers.get(key);
                assert (implClass != null) : key;
                this.val$container.registerComponentImplementation(implClass);
                return (ModuleFixtureBuilder)this.val$container.getComponentInstanceOfType(implClass);
            }
        };
    }

    @Override
    public HeavyIdeaTestFixture getFixture() {
        return this.myFixture;
    }

    @Override
    public <M extends ModuleFixtureBuilder> M addModule(Class<M> builderClass) {
        HeavyTestFixtureBuilderImpl.loadClassConstants(builderClass);
        ModuleFixtureBuilder builder = (ModuleFixtureBuilder)this.myModuleFixtureBuilderFactory.get(builderClass);
        this.myFixture.addModuleFixtureBuilder(builder);
        return (M)builder;
    }

    private static void loadClassConstants(Class builderClass) {
        try {
            for (Field field : builderClass.getFields()) {
                field.get(null);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

