/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import com.intellij.testIntegration.TestFinder;
import java.util.ArrayList;
import java.util.List;

public class TestFinderHelper {
    public static PsiElement findSourceElement(PsiElement from) {
        for (TestFinder each : TestFinderHelper.getFinders()) {
            PsiElement result = each.findSourceElement(from);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static List<PsiElement> findTestsForClass(PsiElement element) {
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (TestFinder each : TestFinderHelper.getFinders()) {
            result.addAll(each.findTestsForClass(element));
        }
        return result;
    }

    public static List<PsiElement> findClassesForTest(PsiElement element) {
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (TestFinder each : TestFinderHelper.getFinders()) {
            result.addAll(each.findClassesForTest(element));
        }
        return result;
    }

    public static boolean isTest(PsiElement element) {
        if (element == null) {
            return false;
        }
        for (TestFinder each : TestFinderHelper.getFinders()) {
            if (!each.isTest(element)) continue;
            return true;
        }
        return false;
    }

    private static TestFinder[] getFinders() {
        return (TestFinder[])Extensions.getExtensions((ExtensionPointName)TestFinder.EP_NAME);
    }
}

