/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.CommonBundle;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolEditorDialog;
import com.intellij.tools.ToolManager;
import com.intellij.tools.ToolsBundle;
import com.intellij.tools.ToolsGroup;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;

class ToolsPanel
extends JPanel {
    private final CheckboxTree myTree;
    private final JButton myAddButton = new JButton(ToolsBundle.message("tools.add.button", new Object[0]));
    private final JButton myCopyButton = new JButton(ToolsBundle.message("tools.copy.button", new Object[0]));
    private final JButton myEditButton = new JButton(ToolsBundle.message("tools.edit.button", new Object[0]));
    private final JButton myMoveUpButton = new JButton(ToolsBundle.message("tools.move.up.button", new Object[0]));
    private final JButton myMoveDownButton = new JButton(ToolsBundle.message("tools.move.down.button", new Object[0]));
    private final JButton myRemoveButton = new JButton(ToolsBundle.message("tools.remove.button", new Object[0]));
    private boolean myIsModified = false;

    ToolsPanel() {
        this.myTree = new CheckboxTree(new CheckboxTree.CheckboxTreeCellRenderer(){

            public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Object object = ((CheckedTreeNode)value).getUserObject();
                if (object instanceof ToolsGroup) {
                    String groupName = ((ToolsGroup)((Object)object)).getName();
                    if (groupName != null) {
                        this.getTextRenderer().append(groupName, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    } else {
                        this.getTextRenderer().append("[unnamed group]", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    }
                } else if (object instanceof Tool) {
                    this.getTextRenderer().append(((Tool)object).getName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                }
            }
        }, new CheckedTreeNode(null)){

            protected void onDoubleClick(CheckedTreeNode node) {
                ToolsPanel.this.editSelected();
            }
        };
        this.myTree.setRootVisible(false);
        JScrollPane tableScrollPane = ScrollPaneFactory.createScrollPane((JComponent)((Object)this.myTree));
        this.setLayout(new GridBagLayout());
        GridBagConstraints constr = new GridBagConstraints();
        constr.gridx = 0;
        constr.gridy = 0;
        constr.weightx = 1.0;
        constr.weighty = 1.0;
        constr.insets = new Insets(0, 2, 0, 0);
        constr.fill = 1;
        constr.anchor = 17;
        this.add((Component)tableScrollPane, constr);
        this.myTree.setSelectionModel(new DefaultTreeSelectionModel());
        this.myTree.getSelectionModel().setSelectionMode(4);
        constr = new GridBagConstraints();
        constr.gridx = 1;
        constr.gridy = 0;
        constr.anchor = 11;
        this.add((Component)this.createRightButtonPane(), constr);
        this.addListeners();
    }

    private JPanel createRightButtonPane() {
        JPanel pane = new JPanel(new GridBagLayout());
        GridBagConstraints constr = new GridBagConstraints();
        constr.insets = new Insets(0, 5, 5, 5);
        constr.fill = 2;
        constr.weightx = 1.0;
        constr.gridy = 0;
        pane.add((Component)this.myAddButton, constr);
        constr.gridy = 1;
        pane.add((Component)this.myCopyButton, constr);
        constr.gridy = 2;
        pane.add((Component)this.myEditButton, constr);
        constr.gridy = 3;
        pane.add((Component)this.myRemoveButton, constr);
        constr.gridy = 4;
        pane.add((Component)this.myMoveUpButton, constr);
        constr.gridy = 5;
        pane.add((Component)this.myMoveDownButton, constr);
        return pane;
    }

    void reset() {
        ToolsGroup[] groups;
        for (ToolsGroup group : groups = ToolManager.getInstance().getGroups()) {
            this.insertNewGroup((ToolsGroup)group.copy());
        }
        if (this.getTreeRoot().getChildCount() > 0) {
            this.myTree.setSelectionInterval(0, 0);
        } else {
            this.myTree.getSelectionModel().clearSelection();
        }
        this.getModel().nodeStructureChanged(null);
        TreeUtil.expand((JTree)((Object)this.myTree), (int)5);
        this.myIsModified = false;
        this.update();
    }

    private CheckedTreeNode insertNewGroup(ToolsGroup groupCopy) {
        CheckedTreeNode root = this.getTreeRoot();
        CheckedTreeNode groupNode = new CheckedTreeNode((Object)groupCopy);
        root.add((MutableTreeNode)groupNode);
        for (Tool tool : groupCopy.getElements()) {
            this.insertNewTool(groupNode, tool);
        }
        return groupNode;
    }

    private CheckedTreeNode insertNewTool(CheckedTreeNode groupNode, Tool toolCopy) {
        CheckedTreeNode toolNode = new CheckedTreeNode((Object)toolCopy);
        ((ToolsGroup)((Object)groupNode.getUserObject())).addElement(toolCopy);
        groupNode.add((MutableTreeNode)toolNode);
        this.nodeWasInserted(toolNode);
        return toolNode;
    }

    private CheckedTreeNode getTreeRoot() {
        return (CheckedTreeNode)this.myTree.getModel().getRoot();
    }

    void apply() throws IOException {
        ToolManager toolManager = ToolManager.getInstance();
        toolManager.setTools(this.getGroupList());
        this.myIsModified = false;
    }

    private ToolsGroup[] getGroupList() {
        ArrayList<ToolsGroup> result = new ArrayList<ToolsGroup>();
        MutableTreeNode root = (MutableTreeNode)this.myTree.getModel().getRoot();
        for (int i = 0; i < root.getChildCount(); ++i) {
            result.add((ToolsGroup)((Object)((CheckedTreeNode)root.getChildAt(i)).getUserObject()));
        }
        return result.toArray(new ToolsGroup[result.size()]);
    }

    boolean isModified() {
        return this.myIsModified;
    }

    private void addListeners() {
        this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ToolsPanel.this.update();
            }
        });
        this.myAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolEditorDialog dlg = new ToolEditorDialog(ToolsPanel.this);
                Tool tool = new Tool();
                tool.setUseConsole(true);
                tool.setFilesSynchronizedAfterRun(true);
                tool.setShownInMainMenu(true);
                tool.setShownInEditor(true);
                tool.setShownInProjectViews(true);
                tool.setShownInSearchResultsPopup(true);
                tool.setEnabled(true);
                dlg.setData(tool, ToolsPanel.this.getGroups());
                dlg.show();
                if (dlg.isOK()) {
                    ToolsPanel.this.insertNewTool(dlg.getData(), true);
                }
                ToolsPanel.this.myTree.requestFocus();
            }
        });
        this.myCopyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Tool originalTool = ToolsPanel.this.getSelectedTool();
                if (originalTool != null) {
                    ToolEditorDialog dlg = new ToolEditorDialog(ToolsPanel.this);
                    Tool toolCopy = new Tool();
                    toolCopy.copyFrom(originalTool);
                    dlg.setData(toolCopy, ToolsPanel.this.getGroups());
                    dlg.show();
                    if (dlg.isOK()) {
                        ToolsPanel.this.insertNewTool(dlg.getData(), true);
                    }
                    ToolsPanel.this.myTree.requestFocus();
                }
            }
        });
        this.myEditButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolsPanel.this.editSelected();
                ToolsPanel.this.myTree.requestFocus();
            }
        });
        this.myRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolsPanel.this.removeSelected();
            }
        });
        this.myMoveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolsPanel.this.moveNode(Direction.UP);
                ToolsPanel.this.myIsModified = true;
            }
        });
        this.myMoveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolsPanel.this.moveNode(Direction.DOWN);
                ToolsPanel.this.myIsModified = true;
            }
        });
    }

    private void moveNode(Direction direction) {
        CheckedTreeNode node = this.getSelectedNode();
        if (node != null && this.isMovingAvailable(node, direction)) {
            this.moveNode(node, direction);
            if (node.getUserObject() instanceof Tool) {
                ToolsGroup group = (ToolsGroup)((Object)((CheckedTreeNode)node.getParent()).getUserObject());
                Tool tool = (Tool)node.getUserObject();
                this.moveElementInsideGroup(tool, group, direction);
            }
            TreePath path = new TreePath(node.getPath());
            this.myTree.getSelectionModel().setSelectionPath(path);
            this.myTree.expandPath(path);
            this.myTree.requestFocus();
        }
    }

    private void moveElementInsideGroup(Tool tool, ToolsGroup group, Direction dir) {
        if (dir == Direction.UP) {
            group.moveElementUp(tool);
        } else {
            group.moveElementDown(tool);
        }
    }

    private void moveNode(CheckedTreeNode toolNode, Direction dir) {
        CheckedTreeNode parentNode = (CheckedTreeNode)toolNode.getParent();
        int index = parentNode.getIndex((TreeNode)toolNode);
        this.removeNodeFromParent((DefaultMutableTreeNode)toolNode);
        int newIndex = dir.newIndex(index);
        parentNode.insert((MutableTreeNode)toolNode, newIndex);
        this.getModel().nodesWereInserted((TreeNode)parentNode, new int[]{newIndex});
    }

    private boolean isMovingAvailable(CheckedTreeNode toolNode, Direction dir) {
        TreeNode parent = toolNode.getParent();
        int index = parent.getIndex((TreeNode)toolNode);
        return dir.isAvailable(index, parent.getChildCount());
    }

    private void insertNewTool(Tool newTool, boolean setSelection) {
        CheckedTreeNode groupNode = this.findGroupNode(newTool.getGroup());
        if (groupNode == null) {
            groupNode = this.insertNewGroup(new ToolsGroup(newTool.getGroup()));
            this.nodeWasInserted(groupNode);
        }
        CheckedTreeNode tool = this.insertNewTool(groupNode, newTool);
        if (setSelection) {
            TreePath treePath = new TreePath(tool.getPath());
            this.myTree.expandPath(treePath);
            this.myTree.getSelectionModel().setSelectionPath(treePath);
        }
        this.myIsModified = true;
    }

    private void nodeWasInserted(CheckedTreeNode groupNode) {
        this.getModel().nodesWereInserted(groupNode.getParent(), new int[]{groupNode.getParent().getChildCount() - 1});
    }

    private DefaultTreeModel getModel() {
        return (DefaultTreeModel)this.myTree.getModel();
    }

    private CheckedTreeNode findGroupNode(String group) {
        for (int i = 0; i < this.getTreeRoot().getChildCount(); ++i) {
            CheckedTreeNode node = (CheckedTreeNode)this.getTreeRoot().getChildAt(i);
            ToolsGroup g = (ToolsGroup)((Object)node.getUserObject());
            if (!Comparing.equal((String)group, (String)g.getName())) continue;
            return node;
        }
        return null;
    }

    @Nullable
    private Tool getSelectedTool() {
        CheckedTreeNode node = this.getSelectedToolNode();
        if (node == null) {
            return null;
        }
        return node.getUserObject() instanceof Tool ? (Tool)node.getUserObject() : null;
    }

    @Nullable
    private ToolsGroup getSelectedToolGroup() {
        CheckedTreeNode node = this.getSelectedToolNode();
        if (node == null) {
            return null;
        }
        return node.getUserObject() instanceof ToolsGroup ? (ToolsGroup)((Object)node.getUserObject()) : null;
    }

    private void update() {
        CheckedTreeNode node = this.getSelectedToolNode();
        Tool selectedTool = this.getSelectedTool();
        ToolsGroup selectedGroup = this.getSelectedToolGroup();
        if (selectedTool != null) {
            this.myAddButton.setEnabled(true);
            this.myCopyButton.setEnabled(true);
            this.myEditButton.setEnabled(true);
            this.myMoveDownButton.setEnabled(this.isMovingAvailable(node, Direction.DOWN));
            this.myMoveUpButton.setEnabled(this.isMovingAvailable(node, Direction.UP));
            this.myRemoveButton.setEnabled(true);
        } else if (selectedGroup != null) {
            this.myAddButton.setEnabled(true);
            this.myCopyButton.setEnabled(false);
            this.myEditButton.setEnabled(false);
            this.myMoveDownButton.setEnabled(this.isMovingAvailable(node, Direction.DOWN));
            this.myMoveUpButton.setEnabled(this.isMovingAvailable(node, Direction.UP));
            this.myRemoveButton.setEnabled(true);
        } else {
            this.myAddButton.setEnabled(true);
            this.myCopyButton.setEnabled(false);
            this.myEditButton.setEnabled(false);
            this.myMoveDownButton.setEnabled(false);
            this.myMoveUpButton.setEnabled(false);
            this.myRemoveButton.setEnabled(false);
        }
        this.getModel().nodeStructureChanged(null);
        this.myTree.repaint();
    }

    private void removeSelected() {
        CheckedTreeNode node = this.getSelectedToolNode();
        if (node != null) {
            int result = Messages.showYesNoDialog((Component)this, (String)ToolsBundle.message("tools.delete.confirmation", new Object[0]), (String)CommonBundle.getWarningTitle(), (Icon)Messages.getWarningIcon());
            if (result != 0) {
                return;
            }
            this.myIsModified = true;
            if (node.getUserObject() instanceof Tool) {
                Tool tool = (Tool)node.getUserObject();
                CheckedTreeNode parentNode = (CheckedTreeNode)node.getParent();
                ((ToolsGroup)((Object)parentNode.getUserObject())).removeElement(tool);
                this.removeNodeFromParent((DefaultMutableTreeNode)node);
                if (parentNode.getChildCount() == 0) {
                    this.removeNodeFromParent((DefaultMutableTreeNode)parentNode);
                }
            } else if (node.getUserObject() instanceof ToolsGroup) {
                this.removeNodeFromParent((DefaultMutableTreeNode)node);
            }
            this.update();
            this.myTree.requestFocus();
        }
    }

    private void removeNodeFromParent(DefaultMutableTreeNode node) {
        TreeNode parent = node.getParent();
        int idx = parent.getIndex(node);
        node.removeFromParent();
        this.getModel().nodesWereRemoved(parent, new int[]{idx}, new TreeNode[]{node});
    }

    private void editSelected() {
        Tool selected;
        CheckedTreeNode node = this.getSelectedToolNode();
        if (node != null && node.getUserObject() instanceof Tool && (selected = (Tool)node.getUserObject()) != null) {
            String oldGroupName = selected.getGroup();
            ToolEditorDialog dlg = new ToolEditorDialog(this);
            dlg.setData(selected, this.getGroups());
            dlg.show();
            if (dlg.isOK()) {
                selected.copyFrom(dlg.getData());
                String newGroupName = selected.getGroup();
                if (!Comparing.equal((String)oldGroupName, (String)newGroupName)) {
                    CheckedTreeNode oldGroupNode = (CheckedTreeNode)node.getParent();
                    this.removeNodeFromParent((DefaultMutableTreeNode)node);
                    ((ToolsGroup)((Object)oldGroupNode.getUserObject())).removeElement(selected);
                    if (oldGroupNode.getChildCount() == 0) {
                        this.removeNodeFromParent((DefaultMutableTreeNode)oldGroupNode);
                    }
                    this.insertNewTool(selected, true);
                } else {
                    this.getModel().nodeChanged((TreeNode)node);
                }
                this.myIsModified = true;
                this.update();
            }
        }
    }

    private CheckedTreeNode getSelectedToolNode() {
        TreePath selectionPath = this.myTree.getSelectionPath();
        if (selectionPath != null) {
            return (CheckedTreeNode)selectionPath.getLastPathComponent();
        }
        return null;
    }

    private CheckedTreeNode getSelectedNode() {
        TreePath selectionPath = this.myTree.getSelectionPath();
        if (selectionPath != null) {
            return (CheckedTreeNode)selectionPath.getLastPathComponent();
        }
        return null;
    }

    private String[] getGroups() {
        ToolsGroup[] groups;
        ArrayList<String> result = new ArrayList<String>();
        for (ToolsGroup group : groups = this.getGroupList()) {
            result.add(group.getName());
        }
        return ArrayUtil.toStringArray(result);
    }

    static enum Direction {
        UP{

            @Override
            public boolean isAvailable(int index, int childCount) {
                return index != 0;
            }

            @Override
            public int newIndex(int index) {
                return index - 1;
            }
        }
        ,
        DOWN{

            @Override
            public boolean isAvailable(int index, int childCount) {
                return index < childCount - 1;
            }

            @Override
            public int newIndex(int index) {
                return index + 1;
            }
        };


        public abstract boolean isAvailable(int var1, int var2);

        public abstract int newIndex(int var1);
    }
}

