/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tools.FilterInfo;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolManager;
import com.intellij.tools.ToolsGroup;
import java.io.File;
import java.io.IOException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;

class ToolsProcessor
implements SchemeProcessor<ToolsGroup> {
    @NonNls
    private static final String TOOL_SET = "toolSet";
    @NonNls
    private static final String TOOL = "tool";
    @NonNls
    private static final String ATTRIBUTE_NAME = "name";
    @NonNls
    private static final String NAME = "name";
    @NonNls
    private static final String DESCRIPTION = "description";
    @NonNls
    private static final String SHOW_IN_MAIN_MENU = "showInMainMenu";
    @NonNls
    private static final String SHOW_IN_EDITOR = "showInEditor";
    @NonNls
    private static final String SHOW_IN_PROJECT = "showInProject";
    @NonNls
    private static final String SHOW_IN_SEARCH_POPUP = "showInSearchPopup";
    @NonNls
    private static final String DISABLED = "disabled";
    @NonNls
    private static final String USE_CONSOLE = "useConsole";
    @NonNls
    private static final String SYNCHRONIZE_AFTER_EXECUTION = "synchronizeAfterRun";
    @NonNls
    private static final String EXEC = "exec";
    @NonNls
    private static final String WORKING_DIRECTORY = "WORKING_DIRECTORY";
    @NonNls
    private static final String COMMAND = "COMMAND";
    @NonNls
    private static final String PARAMETERS = "PARAMETERS";
    @NonNls
    private static final String FILTER = "filter";
    @NonNls
    private static final String ELEMENT_OPTION = "option";
    @NonNls
    private static final String ATTRIBUTE_VALUE = "value";
    @NonNls
    private static final String APPLICATION_HOME_MACRO = "$APPLICATION_HOME_DIR$";

    ToolsProcessor() {
    }

    public ToolsGroup readScheme(Document document) throws InvalidDataException, IOException, JDOMException {
        Element root = document.getRootElement();
        if (root == null || !TOOL_SET.equals(root.getName())) {
            throw new InvalidDataException();
        }
        String groupName = root.getAttributeValue("name");
        ToolsGroup result = new ToolsGroup(groupName);
        for (Object o : root.getChildren(TOOL)) {
            Element element = (Element)o;
            Tool tool = new Tool();
            tool.setName(ToolManager.convertString(element.getAttributeValue("name")));
            tool.setDescription(ToolManager.convertString(element.getAttributeValue(DESCRIPTION)));
            tool.setShownInMainMenu(Boolean.valueOf(element.getAttributeValue(SHOW_IN_MAIN_MENU)));
            tool.setShownInEditor(Boolean.valueOf(element.getAttributeValue(SHOW_IN_EDITOR)));
            tool.setShownInProjectViews(Boolean.valueOf(element.getAttributeValue(SHOW_IN_PROJECT)));
            tool.setShownInSearchResultsPopup(Boolean.valueOf(element.getAttributeValue(SHOW_IN_SEARCH_POPUP)));
            tool.setEnabled(Boolean.valueOf(element.getAttributeValue(DISABLED)) == false);
            tool.setUseConsole(Boolean.valueOf(element.getAttributeValue(USE_CONSOLE)));
            tool.setFilesSynchronizedAfterRun(Boolean.valueOf(element.getAttributeValue(SYNCHRONIZE_AFTER_EXECUTION)));
            Element exec = element.getChild(EXEC);
            if (exec != null) {
                for (Object o1 : exec.getChildren(ELEMENT_OPTION)) {
                    Element optionElement = (Element)o1;
                    String name = optionElement.getAttributeValue("name");
                    String value = optionElement.getAttributeValue(ATTRIBUTE_VALUE);
                    if (WORKING_DIRECTORY.equals(name) && value != null) {
                        String appHome = PathManager.getHomePath().replace(File.separatorChar, '/');
                        tool.setWorkingDirectory(StringUtil.replace((String)value, (String)APPLICATION_HOME_MACRO, (String)appHome));
                    }
                    if (COMMAND.equals(name)) {
                        tool.setProgram(ToolManager.convertString(value));
                    }
                    if (!PARAMETERS.equals(name)) continue;
                    tool.setParameters(ToolManager.convertString(value));
                }
            }
            for (Object o2 : element.getChildren(FILTER)) {
                Element childNode = (Element)o2;
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.readExternal(childNode);
                tool.addOutputFilter(filterInfo);
            }
            tool.setGroup(groupName);
            result.addElement(tool);
        }
        return result;
    }

    public Document writeScheme(ToolsGroup scheme) throws WriteExternalException {
        Element groupElement = new Element(TOOL_SET);
        if (scheme.getName() != null) {
            groupElement.setAttribute("name", scheme.getName());
        }
        for (Tool tool : scheme.getElements()) {
            this.saveTool(tool, groupElement);
        }
        return new Document(groupElement);
    }

    public boolean shouldBeSaved(ToolsGroup scheme) {
        return true;
    }

    public void initScheme(ToolsGroup scheme) {
    }

    public void onSchemeAdded(ToolsGroup scheme) {
    }

    public void onSchemeDeleted(ToolsGroup scheme) {
    }

    public void onCurrentSchemeChanged(Scheme oldCurrentScheme) {
    }

    private void saveTool(Tool tool, Element groupElement) {
        FilterInfo[] filters;
        Element element = new Element(TOOL);
        if (tool.getName() != null) {
            element.setAttribute("name", tool.getName());
        }
        if (tool.getDescription() != null) {
            element.setAttribute(DESCRIPTION, tool.getDescription());
        }
        element.setAttribute(SHOW_IN_MAIN_MENU, Boolean.toString(tool.isShownInMainMenu()));
        element.setAttribute(SHOW_IN_EDITOR, Boolean.toString(tool.isShownInEditor()));
        element.setAttribute(SHOW_IN_PROJECT, Boolean.toString(tool.isShownInProjectViews()));
        element.setAttribute(SHOW_IN_SEARCH_POPUP, Boolean.toString(tool.isShownInSearchResultsPopup()));
        element.setAttribute(DISABLED, Boolean.toString(!tool.isEnabled()));
        element.setAttribute(USE_CONSOLE, Boolean.toString(tool.isUseConsole()));
        element.setAttribute(SYNCHRONIZE_AFTER_EXECUTION, Boolean.toString(tool.synchronizeAfterExecution()));
        Element taskElement = new Element(EXEC);
        Element option = new Element(ELEMENT_OPTION);
        taskElement.addContent(option);
        option.setAttribute("name", COMMAND);
        if (tool.getProgram() != null) {
            option.setAttribute(ATTRIBUTE_VALUE, tool.getProgram());
        }
        option = new Element(ELEMENT_OPTION);
        taskElement.addContent(option);
        option.setAttribute("name", PARAMETERS);
        if (tool.getParameters() != null) {
            option.setAttribute(ATTRIBUTE_VALUE, tool.getParameters());
        }
        option = new Element(ELEMENT_OPTION);
        taskElement.addContent(option);
        option.setAttribute("name", WORKING_DIRECTORY);
        if (tool.getWorkingDirectory() != null) {
            String appHome = PathManager.getHomePath().replace(File.separatorChar, '/');
            option.setAttribute(ATTRIBUTE_VALUE, StringUtil.replace((String)tool.getWorkingDirectory(), (String)appHome, (String)APPLICATION_HOME_MACRO));
        }
        element.addContent(taskElement);
        for (FilterInfo filter : filters = tool.getOutputFilters()) {
            Element filterElement = new Element(FILTER);
            filter.writeExternal(filterElement);
            element.addContent(filterElement);
        }
        groupElement.addContent(element);
    }
}

