/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.util.ui.UIUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import javax.swing.border.LineBorder;

public class OneSideRoundedLineBorder
extends LineBorder {
    private final int myArcSize;
    private final int myRadius;
    private boolean myIsTopRounded;
    private boolean myIsBottomRounded;
    private boolean myDrawDottedAngledSide;
    private static final float[] DASH = new float[]{0.0f, 2.0f, 0.0f, 2.0f};

    public OneSideRoundedLineBorder(Color color, int arcSize) {
        this(color, arcSize, 1, true, false, false);
    }

    public OneSideRoundedLineBorder(Color color, int arcSize, int thickness, boolean isTopRounded, boolean isBottomRounded, boolean drawDottedAngledSide) {
        super(color, thickness);
        this.myArcSize = arcSize;
        this.myIsTopRounded = isTopRounded;
        this.myIsBottomRounded = isBottomRounded;
        this.myRadius = this.myArcSize / 2;
        this.myDrawDottedAngledSide = drawDottedAngledSide;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2 = (Graphics2D)g;
        Object oldAntialiasing = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color oldColor = g2.getColor();
        g2.setColor(this.lineColor);
        for (int idx = 0; idx < this.thickness; ++idx) {
            int correctedHeight = height - idx - idx - 1;
            int correctedWidth = width - idx - idx - 1;
            int startX = x + idx;
            int startY = y + idx;
            if (this.myIsTopRounded && this.myIsBottomRounded) {
                g2.drawRoundRect(startX, startY, correctedWidth, correctedHeight, this.myArcSize, this.myArcSize);
                continue;
            }
            if (this.myIsTopRounded) {
                UIUtil.drawLine((Graphics)g2, (int)(startX + this.myRadius), (int)startY, (int)(startX + correctedWidth - this.myRadius), (int)startY);
                if (this.myDrawDottedAngledSide) {
                    this.drawDottedLine(g2, startX, startY + correctedHeight, startX + correctedWidth, startY + correctedHeight);
                } else {
                    UIUtil.drawLine((Graphics)g2, (int)startX, (int)(startY + correctedHeight), (int)(startX + correctedWidth), (int)(startY + correctedHeight));
                }
                g2.drawArc(startX, startY, this.myArcSize, this.myArcSize, 90, 90);
                g2.drawArc(startX + correctedWidth - this.myArcSize, startY, this.myArcSize, this.myArcSize, 0, 90);
                UIUtil.drawLine((Graphics)g2, (int)startX, (int)(startY + this.myRadius + 1), (int)startX, (int)(startY + correctedHeight));
                UIUtil.drawLine((Graphics)g2, (int)(startX + correctedWidth), (int)(startY + this.myRadius + 1), (int)(startX + correctedWidth), (int)(startY + correctedHeight));
                continue;
            }
            if (this.myIsBottomRounded) continue;
            g2.drawRect(startX, startY, correctedWidth, correctedHeight);
        }
        g2.setColor(oldColor);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAntialiasing);
    }

    private void drawDottedLine(Graphics2D g, int x1, int y1, int x2, int y2) {
        Stroke saved = g.getStroke();
        g.setStroke(new BasicStroke(1.0f, 1, 1, 0.0f, DASH, y1 % 2));
        UIUtil.drawLine((Graphics)g, (int)x1, (int)y1, (int)x2, (int)y2);
        g.setStroke(saved);
    }
}

