/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerAdapter;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.UIBundle;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public abstract class SpeedSearchBase<Comp extends JComponent> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.SpeedSearchBase");
    private SearchPopup mySearchPopup;
    private JLayeredPane myPopupLayeredPane;
    protected final Comp myComponent;
    private final ToolWindowManagerListener myWindowManagerListener = new MyToolWindowManagerListener();
    private final PropertyChangeSupport myChangeSupport = new PropertyChangeSupport(this);
    private String myRecentEnteredPrefix;
    private SpeedSearchComparator myComparator = new SpeedSearchComparator();
    private static final Key SPEED_SEARCH_COMPONENT_MARKER = new Key("SPEED_SEARCH_COMPONENT_MARKER");
    @NonNls
    protected static final String ENTERED_PREFIX_PROPERTY_NAME = "enteredPrefix";

    public SpeedSearchBase(Comp component) {
        this.myComponent = component;
        ((Component)this.myComponent).addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                SpeedSearchBase.this.manageSearchPopup(null);
            }
        });
        ((Component)this.myComponent).addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                SpeedSearchBase.this.processKeyEvent(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                SpeedSearchBase.this.processKeyEvent(e);
            }
        });
        ((JComponent)component).putClientProperty(SPEED_SEARCH_COMPONENT_MARKER, this);
    }

    public static boolean hasActiveSpeedSearch(JComponent component) {
        SpeedSearchBase speedSearch = (SpeedSearchBase)component.getClientProperty(SPEED_SEARCH_COMPONENT_MARKER);
        return speedSearch != null && speedSearch.mySearchPopup != null && speedSearch.mySearchPopup.isVisible();
    }

    protected abstract int getSelectedIndex();

    protected abstract Object[] getAllElements();

    protected abstract String getElementText(Object var1);

    protected abstract void selectElement(Object var1, String var2);

    protected ListIterator<Object> getElementIterator(int startingIndex) {
        Object[] allElements = this.getAllElements();
        return Arrays.asList(allElements).listIterator(startingIndex < 0 ? allElements.length : startingIndex);
    }

    public void addChangeListener(PropertyChangeListener listener) {
        this.myChangeSupport.addPropertyChangeListener(listener);
    }

    public void removeChangeListener(PropertyChangeListener listener) {
        this.myChangeSupport.removePropertyChangeListener(listener);
    }

    private void fireStateChanged() {
        String enteredPrefix = this.getEnteredPrefix();
        this.myChangeSupport.firePropertyChange(ENTERED_PREFIX_PROPERTY_NAME, this.myRecentEnteredPrefix, enteredPrefix);
        this.myRecentEnteredPrefix = enteredPrefix;
    }

    protected boolean isMatchingElement(Object element, String pattern) {
        String str = this.getElementText(element);
        return str != null && this.compare(str, pattern);
    }

    protected boolean compare(String text, String pattern) {
        return this.myComparator.doCompare(pattern, text);
    }

    public SpeedSearchComparator getComparator() {
        return this.myComparator;
    }

    public void setComparator(SpeedSearchComparator comparator) {
        this.myComparator = comparator;
    }

    @Nullable
    private Object findNextElement(String s) {
        Object current;
        String _s = s.trim();
        int selectedIndex = this.getSelectedIndex();
        ListIterator<Object> it = this.getElementIterator(selectedIndex + 1);
        if (it.hasPrevious()) {
            current = it.previous();
            it.next();
        } else {
            current = null;
        }
        while (it.hasNext()) {
            Object element = it.next();
            if (!this.isMatchingElement(element, _s)) continue;
            return element;
        }
        return current;
    }

    @Nullable
    private Object findPreviousElement(String s) {
        Object current;
        String _s = s.trim();
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex < 0) {
            return null;
        }
        ListIterator<Object> it = this.getElementIterator(selectedIndex);
        if (it.hasNext()) {
            current = it.next();
            it.previous();
        } else {
            current = null;
        }
        while (it.hasPrevious()) {
            Object element = it.previous();
            if (!this.isMatchingElement(element, _s)) continue;
            return element;
        }
        return selectedIndex != -1 ? current : null;
    }

    @Nullable
    private Object findElement(String s) {
        Object element;
        String _s = s.trim();
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex < 0) {
            selectedIndex = 0;
        }
        ListIterator<Object> it = this.getElementIterator(selectedIndex);
        while (it.hasNext()) {
            element = it.next();
            if (!this.isMatchingElement(element, _s)) continue;
            return element;
        }
        if (selectedIndex > 0) {
            while (it.hasPrevious()) {
                it.previous();
            }
            while (it.hasNext() && it.nextIndex() != selectedIndex) {
                element = it.next();
                if (!this.isMatchingElement(element, _s)) continue;
                return element;
            }
        }
        return null;
    }

    @Nullable
    private Object findFirstElement(String s) {
        String _s = s.trim();
        ListIterator<Object> it = this.getElementIterator(0);
        while (it.hasNext()) {
            Object element = it.next();
            if (!this.isMatchingElement(element, _s)) continue;
            return element;
        }
        return null;
    }

    @Nullable
    private Object findLastElement(String s) {
        String _s = s.trim();
        ListIterator<Object> it = this.getElementIterator(-1);
        while (it.hasPrevious()) {
            Object element = it.previous();
            if (!this.isMatchingElement(element, _s)) continue;
            return element;
        }
        return null;
    }

    private void processKeyEvent(KeyEvent e) {
        if (e.isAltDown()) {
            return;
        }
        if (this.mySearchPopup != null) {
            this.mySearchPopup.processKeyEvent(e);
            return;
        }
        if (!this.isSpeedSearchEnabled()) {
            return;
        }
        if (e.getID() == 400) {
            if (!UIUtil.isReallyTypedEvent((KeyEvent)e)) {
                return;
            }
            char c = e.getKeyChar();
            if (Character.isLetterOrDigit(c) || c == '_' || c == '*' || c == '/' || c == ':') {
                this.manageSearchPopup(new SearchPopup(String.valueOf(c)));
                e.consume();
            }
        }
    }

    public Comp getComponent() {
        return this.myComponent;
    }

    protected boolean isSpeedSearchEnabled() {
        return true;
    }

    @Nullable
    public String getEnteredPrefix() {
        return this.mySearchPopup != null ? this.mySearchPopup.mySearchField.getText() : null;
    }

    public void refreshSelection() {
        if (this.mySearchPopup != null) {
            this.mySearchPopup.refreshSelection();
        }
    }

    private void manageSearchPopup(SearchPopup searchPopup) {
        JRootPane rootPane;
        Project project = ApplicationManager.getApplication() != null && !ApplicationManager.getApplication().isDisposed() ? (Project)PlatformDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(this.myComponent)) : null;
        if (this.mySearchPopup != null) {
            this.myPopupLayeredPane.remove(this.mySearchPopup);
            this.myPopupLayeredPane.validate();
            this.myPopupLayeredPane.repaint();
            this.myPopupLayeredPane = null;
            if (project != null) {
                ((ToolWindowManagerEx)ToolWindowManager.getInstance((Project)project)).removeToolWindowManagerListener(this.myWindowManagerListener);
            }
        } else if (searchPopup != null) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("ui.tree.speedsearch");
        }
        this.mySearchPopup = !((Component)this.myComponent).isShowing() ? null : searchPopup;
        this.fireStateChanged();
        if (this.mySearchPopup == null || !((Component)this.myComponent).isDisplayable()) {
            return;
        }
        if (project != null) {
            ((ToolWindowManagerEx)ToolWindowManager.getInstance((Project)project)).addToolWindowManagerListener(this.myWindowManagerListener);
        }
        this.myPopupLayeredPane = (rootPane = ((JComponent)this.myComponent).getRootPane()) != null ? rootPane.getLayeredPane() : null;
        if (this.myPopupLayeredPane == null) {
            LOG.error(this.toString() + " in " + String.valueOf(this.myComponent));
            return;
        }
        this.myPopupLayeredPane.add((Component)this.mySearchPopup, JLayeredPane.POPUP_LAYER);
        if (this.myPopupLayeredPane == null) {
            return;
        }
        Point lPaneP = this.myPopupLayeredPane.getLocationOnScreen();
        Point componentP = ((Component)this.myComponent).getLocationOnScreen();
        Rectangle r = ((JComponent)this.myComponent).getVisibleRect();
        Dimension prefSize = this.mySearchPopup.getPreferredSize();
        Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this.myComponent);
        Point windowP = window instanceof JDialog ? ((JDialog)window).getContentPane().getLocationOnScreen() : (window instanceof JFrame ? ((JFrame)window).getContentPane().getLocationOnScreen() : window.getLocationOnScreen());
        int y = r.y + componentP.y - lPaneP.y - prefSize.height;
        y = Math.max(y, windowP.y - lPaneP.y);
        this.mySearchPopup.setLocation(componentP.x - lPaneP.x + r.x, y);
        this.mySearchPopup.setSize(prefSize);
        this.mySearchPopup.setVisible(true);
        this.mySearchPopup.validate();
    }

    private class MyToolWindowManagerListener
    extends ToolWindowManagerAdapter {
        private MyToolWindowManagerListener() {
        }

        @Override
        public void stateChanged() {
            SpeedSearchBase.this.manageSearchPopup(null);
        }
    }

    private class SearchField
    extends JTextField {
        SearchField() {
            this.setFocusable(false);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            dim.width = this.getFontMetrics(this.getFont()).stringWidth(this.getText()) + 10;
            return dim;
        }

        @Override
        public void processKeyEvent(KeyEvent e) {
            int i = e.getKeyCode();
            if (i == 8 && this.getDocument().getLength() == 0) {
                e.consume();
                return;
            }
            if (i == 10 || i == 27 || i == 33 || i == 34 || i == 37 || i == 39) {
                SpeedSearchBase.this.manageSearchPopup(null);
                if (i == 27) {
                    e.consume();
                }
                return;
            }
            super.processKeyEvent(e);
            if (i == 8 || i == 36 || i == 35 || i == 38 || i == 40) {
                e.consume();
            }
        }
    }

    private class SearchPopup
    extends JPanel {
        private final SearchField mySearchField;

        public SearchPopup(String initialString) {
            final Color foregroundColor = UIUtil.getToolTipForeground();
            Color color1 = UIUtil.getToolTipBackground();
            this.mySearchField = new SearchField();
            JLabel searchLabel = new JLabel(" " + UIBundle.message((String)"search.popup.search.for.label", (Object[])new Object[0]) + " ");
            searchLabel.setFont(searchLabel.getFont().deriveFont(1));
            searchLabel.setForeground(foregroundColor);
            this.mySearchField.setBorder(null);
            this.mySearchField.setBackground(color1.brighter());
            this.mySearchField.setForeground(foregroundColor);
            this.mySearchField.setDocument(new PlainDocument(){

                @Override
                public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                    String oldText;
                    try {
                        oldText = this.getText(0, this.getLength());
                    }
                    catch (BadLocationException e1) {
                        oldText = "";
                    }
                    String newText = oldText.substring(0, offs) + str + oldText.substring(offs);
                    super.insertString(offs, str, a);
                    if (SpeedSearchBase.this.findElement(newText) == null) {
                        SearchPopup.this.mySearchField.setForeground(Color.RED);
                    } else {
                        SearchPopup.this.mySearchField.setForeground(foregroundColor);
                    }
                }
            });
            this.mySearchField.setText(initialString);
            this.setBorder(BorderFactory.createLineBorder(Color.gray, 1));
            this.setBackground(color1.brighter());
            this.setLayout(new BorderLayout());
            this.add((Component)searchLabel, "West");
            this.add((Component)this.mySearchField, "East");
            Object element = SpeedSearchBase.this.findElement(this.mySearchField.getText());
            this.updateSelection(element);
        }

        @Override
        public void processKeyEvent(KeyEvent e) {
            this.mySearchField.processKeyEvent(e);
            if (e.isConsumed()) {
                int keyCode = e.getKeyCode();
                String s = this.mySearchField.getText();
                Object element = keyCode == 38 ? SpeedSearchBase.this.findPreviousElement(s) : (keyCode == 40 ? SpeedSearchBase.this.findNextElement(s) : (keyCode == 36 ? SpeedSearchBase.this.findFirstElement(s) : (keyCode == 35 ? SpeedSearchBase.this.findLastElement(s) : SpeedSearchBase.this.findElement(s))));
                this.updateSelection(element);
            }
        }

        public void refreshSelection() {
            this.updateSelection(SpeedSearchBase.this.findElement(this.mySearchField.getText()));
        }

        private void updateSelection(Object element) {
            if (element != null) {
                SpeedSearchBase.this.selectElement(element, this.mySearchField.getText());
                this.mySearchField.setForeground(Color.black);
            } else {
                this.mySearchField.setForeground(Color.red);
            }
            if (SpeedSearchBase.this.mySearchPopup != null) {
                SpeedSearchBase.this.mySearchPopup.setSize(SpeedSearchBase.this.mySearchPopup.getPreferredSize());
                SpeedSearchBase.this.mySearchPopup.validate();
            }
            SpeedSearchBase.this.fireStateChanged();
        }
    }

    public static class SpeedSearchComparator {
        private Matcher myRecentSearchMatcher;
        private String myRecentSearchText;
        private boolean myShouldMatchFromTheBeginning;

        public SpeedSearchComparator() {
            this(true);
        }

        public SpeedSearchComparator(boolean shouldMatchFromTheBeginning) {
            this.myShouldMatchFromTheBeginning = shouldMatchFromTheBeginning;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean doCompare(String pattern, String text) {
            if (this.myRecentSearchText != null && this.myRecentSearchText.equals(pattern)) {
                this.myRecentSearchMatcher.reset(text);
                return this.myRecentSearchMatcher.find();
            }
            this.myRecentSearchText = pattern;
            StringBuilder buf = StringBuilderSpinAllocator.alloc();
            try {
                this.translatePattern(buf, pattern);
                try {
                    boolean allLowercase = pattern.equals(pattern.toLowerCase());
                    Pattern recentSearchPattern = Pattern.compile(buf.toString(), allLowercase ? 2 : 0);
                    this.myRecentSearchMatcher = recentSearchPattern.matcher(text);
                    boolean bl = this.myRecentSearchMatcher.find();
                    return bl;
                }
                catch (PatternSyntaxException ex) {
                    this.myRecentSearchText = null;
                    StringBuilderSpinAllocator.dispose((StringBuilder)buf);
                }
            }
            finally {
                StringBuilderSpinAllocator.dispose((StringBuilder)buf);
            }
            return false;
        }

        public void translatePattern(StringBuilder buf, String pattern) {
            if (this.myShouldMatchFromTheBeginning) {
                buf.append('^');
            }
            int len = pattern.length();
            for (int i = 0; i < len; ++i) {
                this.translateCharacter(buf, pattern.charAt(i));
            }
        }

        public void translateCharacter(StringBuilder buf, char ch) {
            if (ch == '*') {
                buf.append("(\\w|:)");
            } else if ("{}[].+^$()?".indexOf(ch) != -1) {
                buf.append('\\');
            }
            if (Character.isUpperCase(ch)) {
                buf.append("[A-Za-z_]*");
            }
            buf.append(ch);
        }
    }
}

