/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup.list;

import com.intellij.openapi.ui.popup.ListItemDescriptor;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.ui.popup.PopupIcons;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.ui.popup.list.ListPopupImpl;
import javax.swing.Icon;
import javax.swing.JList;

public class PopupListElementRenderer
extends GroupedItemsListRenderer {
    private final ListPopupImpl myPopup;

    public PopupListElementRenderer(final ListPopupImpl aPopup) {
        super(new ListItemDescriptor(){

            public String getTextFor(Object value) {
                return aPopup.getListStep().getTextFor(value);
            }

            public String getTooltipFor(Object value) {
                return null;
            }

            public Icon getIconFor(Object value) {
                return aPopup.getListStep().getIconFor(value);
            }

            public boolean hasSeparatorAboveOf(Object value) {
                return aPopup.getListModel().isSeparatorAboveOf(value);
            }

            public String getCaptionAboveOf(Object value) {
                return aPopup.getListModel().getCaptionAboveOf(value);
            }
        });
        this.myPopup = aPopup;
    }

    @Override
    protected void customizeComponent(JList list, Object value, boolean isSelected) {
        ListPopupStep<Object> step = this.myPopup.getListStep();
        boolean isSelectable = step.isSelectable(value);
        this.myTextLabel.setEnabled(isSelectable);
        if (step.isMnemonicsNavigationEnabled()) {
            int pos = step.getMnemonicNavigationFilter().getMnemonicPos(value);
            if (pos != -1) {
                String text = this.myTextLabel.getText();
                text = text.substring(0, pos) + text.substring(pos + 1);
                this.myTextLabel.setText(text);
                this.myTextLabel.setDisplayedMnemonicIndex(pos);
            }
        } else {
            this.myTextLabel.setDisplayedMnemonicIndex(-1);
        }
        if (this.myPopup.getStep().hasSubstep(value) && isSelectable) {
            this.myNextStepLabel.setVisible(true);
            this.myNextStepLabel.setIcon(isSelected ? PopupIcons.HAS_NEXT_ICON : PopupIcons.HAS_NEXT_ICON_GRAYED);
        } else {
            this.myNextStepLabel.setVisible(false);
        }
        if (isSelected) {
            this.setSelected(this.myNextStepLabel);
        } else {
            this.setDeselected(this.myNextStepLabel);
        }
    }
}

