/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.unscramble;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.unscramble.AnalyzeStacktraceUtil;
import com.intellij.unscramble.UnscrambleDialog;
import com.intellij.unscramble.UnscrambleSupport;

public final class UnscrambleFromClipboardAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)PlatformDataKeys.PROJECT.getData(e.getDataContext());
        String text = AnalyzeStacktraceUtil.getTextInClipboard();
        if (text != null) {
            boolean success;
            UnscrambleSupport savedUnscrambler;
            String file = UnscrambleDialog.getLastUsedLogUrl();
            if (file != null && file.trim().length() == 0) {
                file = null;
            }
            if (((savedUnscrambler = UnscrambleDialog.getSavedUnscrambler()) == null || file != null) && (success = UnscrambleDialog.showUnscrambledText(savedUnscrambler, file, project, text))) {
                return;
            }
        }
        UnscrambleDialog dialog = new UnscrambleDialog(project);
        dialog.show();
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(event.getDataContext());
        presentation.setEnabled(project != null);
    }
}

