/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.descriptors.impl;

import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.descriptors.ConfigFileMetaDataRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigFileMetaDataRegistryImpl
implements ConfigFileMetaDataRegistry {
    private final List<ConfigFileMetaData> myMetaData = new ArrayList<ConfigFileMetaData>();
    private final Map<String, ConfigFileMetaData> myId2MetaData = new HashMap<String, ConfigFileMetaData>();
    private ConfigFileMetaData[] myCachedMetaData;

    public ConfigFileMetaDataRegistryImpl() {
    }

    public ConfigFileMetaDataRegistryImpl(ConfigFileMetaData[] metaDatas) {
        for (ConfigFileMetaData metaData : metaDatas) {
            this.registerMetaData(metaData);
        }
    }

    @NotNull
    public ConfigFileMetaData[] getMetaData() {
        if (this.myCachedMetaData == null) {
            this.myCachedMetaData = this.myMetaData.toArray(new ConfigFileMetaData[this.myMetaData.size()]);
        }
        if (this.myCachedMetaData == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/descriptors/impl/ConfigFileMetaDataRegistryImpl.getMetaData must not return null");
        }
        return this.myCachedMetaData;
    }

    @Nullable
    public ConfigFileMetaData findMetaData(@NonNls @NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/descriptors/impl/ConfigFileMetaDataRegistryImpl.findMetaData must not be null");
        }
        return this.myId2MetaData.get(id);
    }

    public void registerMetaData(ConfigFileMetaData ... metaData) {
        if (metaData == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/descriptors/impl/ConfigFileMetaDataRegistryImpl.registerMetaData must not be null");
        }
        for (ConfigFileMetaData data : metaData) {
            this.myMetaData.add(data);
            this.myId2MetaData.put(data.getId(), data);
        }
        this.myCachedMetaData = null;
    }
}

