/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.CellEditorComponentWithBrowseButton;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

public class LocalPathCellEditor
extends AbstractTableCellEditor {
    private final String myTitle;
    private CellEditorComponentWithBrowseButton<JTextField> myComponent;

    public LocalPathCellEditor(String title) {
        this.myTitle = title;
    }

    public Object getCellEditorValue() {
        return this.myComponent.getChildComponent().getText();
    }

    public Component getTableCellEditorComponent(final JTable table, Object value, boolean isSelected, int row, int column) {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserDescriptor d = new FileChooserDescriptor(false, true, false, true, false, false);
                if (LocalPathCellEditor.this.myTitle != null) {
                    d.setTitle(LocalPathCellEditor.this.myTitle);
                }
                d.setShowFileSystemRoots(true);
                VirtualFile initialFile = LocalFileSystem.getInstance().findFileByPath((String)LocalPathCellEditor.this.getCellEditorValue());
                VirtualFile[] files = FileChooser.chooseFiles((Component)table, (FileChooserDescriptor)d, (VirtualFile)initialFile);
                if (files.length == 1 && files[0] != null) {
                    String path = files[0].getPresentableUrl();
                    if (SystemInfo.isWindows && path.length() == 2 && Character.isLetter(path.charAt(0)) && path.charAt(1) == ':') {
                        path = path + "\\";
                    }
                    ((JTextField)LocalPathCellEditor.this.myComponent.getChildComponent()).setText(path);
                }
            }
        };
        this.myComponent = new CellEditorComponentWithBrowseButton(new TextFieldWithBrowseButton(listener), (TableCellEditor)((Object)this));
        this.myComponent.getChildComponent().setText((String)value);
        return this.myComponent;
    }
}

