/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.classpath;

import com.intellij.openapi.roots.libraries.Library;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SingleRootClasspathElement
implements SimpleClasspathElement {
    @NonNls
    public static final String URL_ELEMENT = "url";
    private final String myUrl;

    public SingleRootClasspathElement(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ui/classpath/SingleRootClasspathElement.<init> must not be null");
        }
        this.myUrl = url;
    }

    @Override
    public String getPresentableName() {
        String url = this.myUrl.endsWith("!/") ? this.myUrl.substring(0, this.myUrl.length() - "!/".length()) : this.myUrl;
        int startIndex = Math.min(url.lastIndexOf(47) + 1, url.length() - 1);
        return url.substring(startIndex);
    }

    @Override
    public Library getLibrary() {
        return null;
    }

    @Override
    public String getLibraryName() {
        return null;
    }

    @Override
    public void serialize(Element element) throws IOException {
        element.addContent(new Element(URL_ELEMENT).setText(this.myUrl));
    }

    @Override
    public List<String> getClassesRootUrls() {
        return Collections.singletonList(this.myUrl);
    }
}

