/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.xml.ClassTemplate;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomJavaUtil;
import com.intellij.util.xml.ExtendClass;
import com.intellij.util.xml.GenericDomValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiClassConverter
extends Converter<PsiClass>
implements CustomReferenceConverter<PsiClass> {
    public PsiClass fromString(String s, ConvertContext context) {
        DomElement element = context.getInvocationElement();
        GlobalSearchScope scope = element instanceof GenericDomValue ? this.getScope((GenericDomValue)element) : null;
        return DomJavaUtil.findClass((String)s, (PsiFile)context.getFile(), (Module)context.getModule(), (GlobalSearchScope)scope);
    }

    @Nullable
    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        return null;
    }

    public String toString(PsiClass t, ConvertContext context) {
        return t == null ? null : t.getQualifiedName();
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<PsiClass> genericDomValue, PsiElement element, ConvertContext context) {
        ExtendClass extendClass = (ExtendClass)genericDomValue.getAnnotation(ExtendClass.class);
        JavaClassReferenceProvider provider = this.createClassReferenceProvider(genericDomValue, context, extendClass);
        PsiReference[] psiReferenceArray = provider.getReferencesByElement(element);
        if (psiReferenceArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/PsiClassConverter.createReferences must not return null");
        }
        return psiReferenceArray;
    }

    protected JavaClassReferenceProvider createClassReferenceProvider(GenericDomValue<PsiClass> genericDomValue, ConvertContext context, ExtendClass extendClass) {
        ClassTemplate template;
        JavaClassReferenceProvider provider = new JavaClassReferenceProvider(this.getScope(genericDomValue), context.getPsiManager().getProject());
        if (extendClass != null) {
            if (StringUtil.isNotEmpty((String)extendClass.value())) {
                provider.setOption(JavaClassReferenceProvider.EXTEND_CLASS_NAMES, new String[]{extendClass.value()});
            }
            if (extendClass.instantiatable()) {
                provider.setOption(JavaClassReferenceProvider.INSTANTIATABLE, Boolean.TRUE);
            }
            if (!extendClass.allowAbstract()) {
                provider.setOption(JavaClassReferenceProvider.CONCRETE, Boolean.TRUE);
            }
            if (!extendClass.allowInterface()) {
                provider.setOption(JavaClassReferenceProvider.NOT_INTERFACE, Boolean.TRUE);
            }
            if (!extendClass.allowEnum()) {
                provider.setOption(JavaClassReferenceProvider.NOT_ENUM, Boolean.TRUE);
            }
            if (extendClass.jvmFormat()) {
                provider.setOption(JavaClassReferenceProvider.JVM_FORMAT, Boolean.TRUE);
            }
            provider.setAllowEmpty(extendClass.allowEmpty());
        }
        if ((template = (ClassTemplate)genericDomValue.getAnnotation(ClassTemplate.class)) != null) {
            if (StringUtil.isNotEmpty((String)template.value())) {
                provider.setOption(JavaClassReferenceProvider.CLASS_TEMPLATE, template.value());
            }
            provider.setOption(JavaClassReferenceProvider.CLASS_KIND, template.kind());
        }
        provider.setSoft(true);
        return provider;
    }

    @Nullable
    protected GlobalSearchScope getScope(GenericDomValue domValue) {
        Module module = domValue.getModule();
        return module == null ? null : GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
    }
}

