/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptorImpl;
import com.intellij.util.xml.highlighting.DomElementResolveProblemDescriptor;
import org.jetbrains.annotations.Nullable;

public class DomElementsHighlightingUtil {
    private static final AnnotationHolderImpl EMPTY_ANNOTATION_HOLDER = new AnnotationHolderImpl(){

        public boolean add(Annotation annotation) {
            return false;
        }
    };

    private DomElementsHighlightingUtil() {
    }

    @Nullable
    public static ProblemDescriptor createProblemDescriptors(final InspectionManager manager, final DomElementProblemDescriptor problemDescriptor) {
        final ProblemHighlightType type = DomElementsHighlightingUtil.getProblemHighlightType(problemDescriptor);
        return DomElementsHighlightingUtil.createProblemDescriptors(problemDescriptor, new Function<Pair<TextRange, PsiElement>, ProblemDescriptor>(){

            public ProblemDescriptor fun(Pair<TextRange, PsiElement> s) {
                return manager.createProblemDescriptor((PsiElement)s.second, (TextRange)s.first, problemDescriptor.getDescriptionTemplate(), type, true, problemDescriptor.getFixes());
            }
        });
    }

    private static ProblemHighlightType getProblemHighlightType(DomElementProblemDescriptor problemDescriptor) {
        TextRange range;
        if (problemDescriptor.getHighlightType() != null) {
            return problemDescriptor.getHighlightType();
        }
        if (problemDescriptor instanceof DomElementResolveProblemDescriptor && (range = ((DomElementResolveProblemDescriptor)problemDescriptor).getPsiReference().getRangeInElement()).getStartOffset() != range.getEndOffset()) {
            return ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
        }
        return ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
    }

    @Nullable
    public static Annotation createAnnotation(final DomElementProblemDescriptor problemDescriptor) {
        return DomElementsHighlightingUtil.createProblemDescriptors(problemDescriptor, new Function<Pair<TextRange, PsiElement>, Annotation>(){

            public Annotation fun(Pair<TextRange, PsiElement> s) {
                String text = problemDescriptor.getDescriptionTemplate();
                if (StringUtil.isEmpty((String)text)) {
                    text = null;
                }
                HighlightSeverity severity = problemDescriptor.getHighlightSeverity();
                AnnotationHolderImpl holder = EMPTY_ANNOTATION_HOLDER;
                TextRange range = (TextRange)s.first;
                if (text == null) {
                    range = TextRange.from((int)range.getStartOffset(), (int)0);
                }
                range = range.shiftRight(((PsiElement)s.second).getTextRange().getStartOffset());
                Annotation annotation = DomElementsHighlightingUtil.createAnnotation(severity, holder, range, text, ((PsiElement)s.second).getProject());
                if (problemDescriptor instanceof DomElementResolveProblemDescriptor) {
                    annotation.setTextAttributes(CodeInsightColors.WRONG_REFERENCES_ATTRIBUTES);
                }
                for (LocalQuickFix fix : problemDescriptor.getFixes()) {
                    if (!(fix instanceof IntentionAction)) continue;
                    annotation.registerFix((IntentionAction)fix);
                }
                return annotation;
            }
        });
    }

    private static Annotation createAnnotation(HighlightSeverity severity, AnnotationHolderImpl holder, TextRange range, String text, Project project) {
        if (SeverityRegistrar.getInstance(project).compare(severity, HighlightSeverity.ERROR) >= 0) {
            return holder.createErrorAnnotation(range, text);
        }
        if (SeverityRegistrar.getInstance(project).compare(severity, HighlightSeverity.WARNING) >= 0) {
            return holder.createWarningAnnotation(range, text);
        }
        if (SeverityRegistrar.getInstance(project).compare(severity, HighlightSeverity.INFO) >= 0) {
            return holder.createInformationAnnotation(range, text);
        }
        return holder.createInfoAnnotation(range, text);
    }

    @Nullable
    private static <T> T createProblemDescriptors(DomElementProblemDescriptor problemDescriptor, Function<Pair<TextRange, PsiElement>, T> creator) {
        Pair<TextRange, PsiElement> range = ((DomElementProblemDescriptorImpl)problemDescriptor).getProblemRange();
        return (T)(range == DomElementProblemDescriptorImpl.NO_PROBLEM ? null : creator.fun(range));
    }
}

