/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ReflectionCache;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.Convert;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomNameStrategy;
import com.intellij.util.xml.DomReflectionUtil;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.HyphenNameStrategy;
import com.intellij.util.xml.JavaMethod;
import com.intellij.util.xml.JavaMethodSignature;
import com.intellij.util.xml.JavaNameStrategy;
import com.intellij.util.xml.NameStrategy;
import com.intellij.util.xml.NameStrategyForAttributes;
import com.intellij.util.xml.Namespace;
import com.intellij.util.xml.NanoXmlUtil;
import com.intellij.util.xml.Resolve;
import com.intellij.util.xml.SubTag;
import com.intellij.util.xml.SubTagList;
import com.intellij.util.xml.TagValue;
import com.intellij.util.xml.XmlFileHeader;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.impl.DomGenericInfoEx;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import gnu.trove.THashSet;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomImplUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.xml.impl.DomImplUtil");

    private DomImplUtil() {
    }

    public static boolean isTagValueGetter(JavaMethod method) {
        if (!DomImplUtil.isGetter(method)) {
            return false;
        }
        if (DomImplUtil.hasTagValueAnnotation(method)) {
            return true;
        }
        if ("getValue".equals(method.getName())) {
            Class declaringClass;
            JavaMethodSignature signature = method.getSignature();
            if (signature.findAnnotation(SubTag.class, declaringClass = method.getDeclaringClass()) != null) {
                return false;
            }
            if (signature.findAnnotation(SubTagList.class, declaringClass) != null) {
                return false;
            }
            if (signature.findAnnotation(Convert.class, declaringClass) != null || signature.findAnnotation(Resolve.class, declaringClass) != null) {
                return !ReflectionCache.isAssignable(GenericDomValue.class, (Class)method.getReturnType());
            }
            return !ReflectionCache.isAssignable(DomElement.class, (Class)method.getReturnType());
        }
        return false;
    }

    private static boolean hasTagValueAnnotation(JavaMethod method) {
        return method.getAnnotation(TagValue.class) != null;
    }

    public static boolean isGetter(JavaMethod method) {
        boolean isIs;
        String name = method.getName();
        boolean isGet = name.startsWith("get");
        boolean bl = isIs = !isGet && name.startsWith("is");
        if (!isGet && !isIs) {
            return false;
        }
        if (method.getGenericParameterTypes().length != 0) {
            return false;
        }
        Type returnType = method.getGenericReturnType();
        if (isGet) {
            return returnType != Void.TYPE;
        }
        return DomReflectionUtil.canHaveIsPropertyGetterPrefix((Type)returnType);
    }

    public static boolean isTagValueSetter(JavaMethod method) {
        boolean setter = method.getName().startsWith("set") && method.getGenericParameterTypes().length == 1 && method.getReturnType() == Void.TYPE;
        return setter && (DomImplUtil.hasTagValueAnnotation(method) || "setValue".equals(method.getName()));
    }

    @Nullable
    public static DomNameStrategy getDomNameStrategy(Class<?> rawType, boolean isAttribute) {
        NameStrategyForAttributes annotation;
        Class aClass = null;
        if (isAttribute && (annotation = (NameStrategyForAttributes)DomReflectionUtil.findAnnotationDFS(rawType, NameStrategyForAttributes.class)) != null) {
            aClass = annotation.value();
        }
        if (aClass == null && (annotation = (NameStrategy)DomReflectionUtil.findAnnotationDFS(rawType, NameStrategy.class)) != null) {
            aClass = annotation.value();
        }
        if (aClass != null) {
            if (HyphenNameStrategy.class.equals(aClass)) {
                return DomNameStrategy.HYPHEN_STRATEGY;
            }
            if (JavaNameStrategy.class.equals((Object)aClass)) {
                return DomNameStrategy.JAVA_STRATEGY;
            }
            try {
                return (DomNameStrategy)aClass.newInstance();
            }
            catch (InstantiationException e) {
                LOG.error((Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.error((Throwable)e);
            }
        }
        return null;
    }

    public static List<XmlTag> findSubTags(@NotNull XmlTag tag, EvaluatedXmlName name, XmlFile file) {
        if (tag == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/impl/DomImplUtil.findSubTags must not be null");
        }
        return DomImplUtil.findSubTags(tag.getSubTags(), name, file);
    }

    public static List<XmlTag> findSubTags(XmlTag[] tags, final EvaluatedXmlName name, final XmlFile file) {
        return ContainerUtil.findAll((Object[])tags, (Condition)new Condition<XmlTag>(){

            public boolean value(XmlTag childTag) {
                return DomImplUtil.isNameSuitable(name, childTag, file);
            }
        });
    }

    public static boolean isNameSuitable(XmlName name, XmlTag tag, @NotNull DomInvocationHandler handler, XmlFile file) {
        if (handler == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/xml/impl/DomImplUtil.isNameSuitable must not be null");
        }
        return DomImplUtil.isNameSuitable(handler.createEvaluatedXmlName(name), tag, file);
    }

    private static boolean isNameSuitable(EvaluatedXmlName evaluatedXmlName, XmlTag tag, XmlFile file) {
        LOG.assertTrue(tag.isValid());
        return DomImplUtil.isNameSuitable(evaluatedXmlName, tag.getLocalName(), tag.getName(), tag.getNamespace(), file);
    }

    public static boolean isNameSuitable(EvaluatedXmlName evaluatedXmlName, String localName, String qName, String namespace, XmlFile file) {
        String localName1 = evaluatedXmlName.getXmlName().getLocalName();
        return (localName1.equals(localName) || localName1.equals(qName)) && evaluatedXmlName.isNamespaceAllowed(namespace, file);
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    @NotNull
    public static XmlFileHeader getXmlFileHeader(PsiFile file) {
        XmlFileHeader xmlFileHeader;
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile instanceof LightVirtualFile && file instanceof XmlFile && FileDocumentManager.getInstance().getCachedDocument(virtualFile) == null) {
            XmlDocument document = ((XmlFile)file).getDocument();
            if (document != null) {
                XmlTag tag;
                XmlDoctype doctype;
                String publicId = null;
                String systemId = null;
                XmlProlog prolog = document.getProlog();
                if (prolog != null && (doctype = prolog.getDoctype()) != null) {
                    publicId = doctype.getPublicId();
                    systemId = doctype.getSystemId();
                }
                if ((tag = document.getRootTag()) != null) {
                    XmlFileHeader xmlFileHeader2 = new XmlFileHeader(tag.getLocalName(), tag.getNamespace(), publicId, systemId);
                    xmlFileHeader = xmlFileHeader2;
                    if (xmlFileHeader2 != null) return xmlFileHeader;
                    throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DomImplUtil.getXmlFileHeader must not return null");
                }
            }
            XmlFileHeader xmlFileHeader3 = XmlFileHeader.EMPTY;
            xmlFileHeader = xmlFileHeader3;
            if (xmlFileHeader3 == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DomImplUtil.getXmlFileHeader must not return null");
            return xmlFileHeader;
        }
        if (!file.isValid()) {
            XmlFileHeader xmlFileHeader4 = XmlFileHeader.EMPTY;
            xmlFileHeader = xmlFileHeader4;
            if (xmlFileHeader4 == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DomImplUtil.getXmlFileHeader must not return null");
            return xmlFileHeader;
        }
        XmlFileHeader xmlFileHeader5 = NanoXmlUtil.parseHeader((PsiFile)file);
        xmlFileHeader = xmlFileHeader5;
        if (xmlFileHeader5 == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DomImplUtil.getXmlFileHeader must not return null");
        return xmlFileHeader;
    }

    @Nullable
    public static XmlName createXmlName(@NotNull String name, Type type, @Nullable JavaMethod javaMethod) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/impl/DomImplUtil.createXmlName must not be null");
        }
        Class<?> aClass = DomImplUtil.getErasure(type);
        if (aClass == null) {
            return null;
        }
        String key = DomImplUtil.getNamespaceKey(aClass);
        if (key == null && javaMethod != null) {
            for (Method method : javaMethod.getSignature().getAllMethods(javaMethod.getDeclaringClass())) {
                String key1 = DomImplUtil.getNamespaceKey(method.getDeclaringClass());
                if (key1 == null) continue;
                key = key1;
            }
        }
        return new XmlName(name, key);
    }

    @Nullable
    private static Class<?> getErasure(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return DomImplUtil.getErasure(((ParameterizedType)type).getRawType());
        }
        if (type instanceof TypeVariable) {
            for (Type bound : ((TypeVariable)type).getBounds()) {
                Class<?> aClass = DomImplUtil.getErasure(bound);
                if (aClass == null) continue;
                return aClass;
            }
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            for (Type bound : wildcardType.getUpperBounds()) {
                Class<?> aClass = DomImplUtil.getErasure(bound);
                if (aClass == null) continue;
                return aClass;
            }
        }
        return null;
    }

    @Nullable
    private static String getNamespaceKey(@NotNull Class<?> type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/impl/DomImplUtil.getNamespaceKey must not be null");
        }
        Namespace namespace = (Namespace)DomReflectionUtil.findAnnotationDFS(type, Namespace.class);
        return namespace != null ? namespace.value() : null;
    }

    @Nullable
    public static XmlName createXmlName(@NotNull String name, JavaMethod method) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/impl/DomImplUtil.createXmlName must not be null");
        }
        return DomImplUtil.createXmlName(name, method.getGenericReturnType(), method);
    }

    public static List<XmlTag> getCustomSubTags(DomInvocationHandler handler, XmlTag[] subTags, XmlFile file) {
        DomGenericInfoEx info = handler.getGenericInfo();
        THashSet usedNames = new THashSet();
        for (DomCollectionChildDescription description : info.getCollectionChildrenDescriptions()) {
            usedNames.add(description.getXmlName());
        }
        for (DomCollectionChildDescription description : info.getFixedChildrenDescriptions()) {
            usedNames.add(description.getXmlName());
        }
        return ContainerUtil.findAll((Object[])subTags, (Condition)new Condition<XmlTag>((Set)usedNames, handler, file){
            final /* synthetic */ Set val$usedNames;
            final /* synthetic */ DomInvocationHandler val$handler;
            final /* synthetic */ XmlFile val$file;
            {
                this.val$usedNames = set;
                this.val$handler = domInvocationHandler;
                this.val$file = xmlFile;
            }

            public boolean value(XmlTag tag) {
                if (StringUtil.isEmpty((String)tag.getName())) {
                    return false;
                }
                for (XmlName name : this.val$usedNames) {
                    if (!DomImplUtil.isNameSuitable(name, tag, this.val$handler, this.val$file)) continue;
                    return false;
                }
                return true;
            }
        });
    }
}

