/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.TreeElementPattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.semantic.SemContributor;
import com.intellij.semantic.SemRegistrar;
import com.intellij.semantic.SemService;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.impl.AbstractCollectionChildDescription;
import com.intellij.util.xml.impl.AttributeChildDescriptionImpl;
import com.intellij.util.xml.impl.AttributeChildInvocationHandler;
import com.intellij.util.xml.impl.CollectionElementInvocationHandler;
import com.intellij.util.xml.impl.DomFileElementImpl;
import com.intellij.util.xml.impl.DomImplUtil;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.DomRootInvocationHandler;
import com.intellij.util.xml.impl.FileDescriptionCachedValueProvider;
import com.intellij.util.xml.impl.FixedChildDescriptionImpl;
import com.intellij.util.xml.impl.IndexedElementInvocationHandler;
import com.intellij.util.xml.impl.PhysicalDomParentStrategy;
import com.intellij.util.xml.reflect.CustomDomChildrenDescription;
import com.intellij.util.xml.reflect.DomChildrenDescription;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class DomSemContributor
extends SemContributor {
    private final SemService mySemService;
    private final DomManagerImpl myDomManager;

    public DomSemContributor(SemService semService, DomManager domManager) {
        this.mySemService = semService;
        this.myDomManager = (DomManagerImpl)domManager;
    }

    public void registerSemProviders(SemRegistrar registrar) {
        registrar.registerSemElementProvider(DomManagerImpl.FILE_DESCRIPTION_KEY, (ElementPattern)XmlPatterns.xmlFile(), (NullableFunction)new NullableFunction<XmlFile, FileDescriptionCachedValueProvider>(){

            public FileDescriptionCachedValueProvider fun(XmlFile xmlFile) {
                ApplicationManager.getApplication().assertReadAccessAllowed();
                return new FileDescriptionCachedValueProvider(DomSemContributor.this.myDomManager, xmlFile);
            }
        });
        registrar.registerSemElementProvider(DomManagerImpl.DOM_HANDLER_KEY, (ElementPattern)XmlPatterns.xmlTag().withParent((ElementPattern)XmlPatterns.psiElement(XmlDocument.class).withParent((ElementPattern)XmlPatterns.xmlFile())), (NullableFunction)new NullableFunction<XmlTag, DomInvocationHandler>(){

            public DomInvocationHandler fun(XmlTag xmlTag) {
                DomRootInvocationHandler handler;
                FileDescriptionCachedValueProvider provider = (FileDescriptionCachedValueProvider)DomSemContributor.this.mySemService.getSemElement(DomManagerImpl.FILE_DESCRIPTION_KEY, (PsiElement)xmlTag.getContainingFile());
                assert (provider != null);
                DomFileElementImpl element = provider.getFileElement();
                if (element != null && (handler = element.getRootHandler()).getXmlTag() == xmlTag) {
                    xmlTag.putUserData(DomManagerImpl.CACHED_DOM_HANDLER, (Object)handler);
                    return handler;
                }
                return null;
            }
        });
        TreeElementPattern nonRootTag = XmlPatterns.xmlTag().withParent(XmlPatterns.or((ElementPattern[])new ElementPattern[]{XmlPatterns.xmlTag(), XmlPatterns.xmlEntityRef().withParent((ElementPattern)XmlPatterns.xmlTag())}));
        registrar.registerSemElementProvider(DomManagerImpl.DOM_INDEXED_HANDLER_KEY, (ElementPattern)nonRootTag, (NullableFunction)new NullableFunction<XmlTag, IndexedElementInvocationHandler>(){

            public IndexedElementInvocationHandler fun(XmlTag tag) {
                XmlTag parentTag = PhysicalDomParentStrategy.getParentTag((XmlElement)tag);
                assert (parentTag != null);
                DomInvocationHandler parent = (DomInvocationHandler)DomSemContributor.this.mySemService.getSemElement(DomManagerImpl.DOM_HANDLER_KEY, (PsiElement)parentTag);
                if (parent == null) {
                    return null;
                }
                String localName = tag.getLocalName();
                String namespace = tag.getNamespace();
                DomFixedChildDescription description = (DomFixedChildDescription)DomSemContributor.findChildrenDescription(parent.getGenericInfo().getFixedChildrenDescriptions(), tag, parent);
                if (description != null) {
                    int totalCount = description.getCount();
                    int index = 0;
                    XmlTag current = tag;
                    while ((current = current.getPrevSibling()) != null) {
                        XmlTag xmlTag;
                        if (!(current instanceof XmlTag) || !localName.equals((xmlTag = current).getName()) || !namespace.equals(xmlTag.getNamespace()) || ++index < totalCount) continue;
                        return null;
                    }
                    IndexedElementInvocationHandler handler = new IndexedElementInvocationHandler(parent.createEvaluatedXmlName(description.getXmlName()), (FixedChildDescriptionImpl)description, index, new PhysicalDomParentStrategy((XmlElement)tag, DomSemContributor.this.myDomManager), DomSemContributor.this.myDomManager, namespace);
                    tag.putUserData(DomManagerImpl.CACHED_DOM_HANDLER, (Object)handler);
                    return handler;
                }
                return null;
            }
        });
        registrar.registerSemElementProvider(DomManagerImpl.DOM_COLLECTION_HANDLER_KEY, (ElementPattern)nonRootTag, (NullableFunction)new NullableFunction<XmlTag, CollectionElementInvocationHandler>(){

            public CollectionElementInvocationHandler fun(XmlTag tag) {
                XmlTag parentTag = PhysicalDomParentStrategy.getParentTag((XmlElement)tag);
                assert (parentTag != null);
                DomInvocationHandler parent = (DomInvocationHandler)DomSemContributor.this.mySemService.getSemElement(DomManagerImpl.DOM_HANDLER_KEY, (PsiElement)parentTag);
                if (parent == null) {
                    return null;
                }
                DomCollectionChildDescription description = (DomCollectionChildDescription)DomSemContributor.findChildrenDescription(parent.getGenericInfo().getCollectionChildrenDescriptions(), tag, parent);
                if (description != null) {
                    CollectionElementInvocationHandler handler = new CollectionElementInvocationHandler(description.getType(), tag, (AbstractCollectionChildDescription)description, parent);
                    tag.putUserData(DomManagerImpl.CACHED_DOM_HANDLER, (Object)handler);
                    return handler;
                }
                return null;
            }
        });
        registrar.registerSemElementProvider(DomManagerImpl.DOM_CUSTOM_HANDLER_KEY, (ElementPattern)nonRootTag, (NullableFunction)new NullableFunction<XmlTag, CollectionElementInvocationHandler>(){
            private ThreadLocal<Set<XmlTag>> myCalculating = new ThreadLocal<Set<XmlTag>>(){

                @Override
                protected Set<XmlTag> initialValue() {
                    return new THashSet();
                }
            };

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public CollectionElementInvocationHandler fun(XmlTag tag) {
                DomInvocationHandler parent;
                if (StringUtil.isEmpty((String)tag.getName())) {
                    return null;
                }
                XmlTag parentTag = PhysicalDomParentStrategy.getParentTag((XmlElement)tag);
                assert (parentTag != null);
                if (!this.myCalculating.get().add(tag)) {
                    return null;
                }
                try {
                    parent = (DomInvocationHandler)DomSemContributor.this.mySemService.getSemElement(DomManagerImpl.DOM_HANDLER_KEY, (PsiElement)parentTag);
                }
                finally {
                    this.myCalculating.get().remove(tag);
                }
                if (parent == null) {
                    return null;
                }
                CustomDomChildrenDescription customDescription = parent.getGenericInfo().getCustomNameChildrenDescription();
                if (customDescription == null) {
                    return null;
                }
                if (DomSemContributor.this.mySemService.getSemElement(DomManagerImpl.DOM_INDEXED_HANDLER_KEY, (PsiElement)tag) == null && DomSemContributor.this.mySemService.getSemElement(DomManagerImpl.DOM_COLLECTION_HANDLER_KEY, (PsiElement)tag) == null) {
                    CollectionElementInvocationHandler handler = new CollectionElementInvocationHandler(customDescription.getType(), tag, (AbstractCollectionChildDescription)customDescription, parent);
                    tag.putUserData(DomManagerImpl.CACHED_DOM_HANDLER, (Object)handler);
                    return handler;
                }
                return null;
            }
        });
        registrar.registerSemElementProvider(DomManagerImpl.DOM_ATTRIBUTE_HANDLER_KEY, (ElementPattern)XmlPatterns.xmlAttribute(), (NullableFunction)new NullableFunction<XmlAttribute, AttributeChildInvocationHandler>(){

            public AttributeChildInvocationHandler fun(final XmlAttribute attribute) {
                final XmlTag tag = PhysicalDomParentStrategy.getParentTag((XmlElement)attribute);
                final DomInvocationHandler handler = (DomInvocationHandler)DomSemContributor.this.mySemService.getSemElement(DomManagerImpl.DOM_HANDLER_KEY, (PsiElement)tag);
                if (handler == null) {
                    return null;
                }
                final String localName = attribute.getLocalName();
                final Ref result = Ref.create(null);
                handler.getGenericInfo().processAttributeChildrenDescriptions(new Processor<AttributeChildDescriptionImpl>(){

                    public boolean process(AttributeChildDescriptionImpl description) {
                        EvaluatedXmlName evaluatedXmlName;
                        String ns;
                        if (description.getXmlName().getLocalName().equals(localName) && ((ns = (evaluatedXmlName = handler.createEvaluatedXmlName(description.getXmlName())).getNamespace((XmlElement)tag, handler.getFile())).equals(tag.getNamespace()) && localName.equals(attribute.getName()) || ns.equals(attribute.getNamespace()))) {
                            AttributeChildInvocationHandler attributeHandler = new AttributeChildInvocationHandler(evaluatedXmlName, description, DomSemContributor.this.myDomManager, new PhysicalDomParentStrategy((XmlElement)attribute, DomSemContributor.this.myDomManager));
                            attribute.putUserData(DomManagerImpl.CACHED_DOM_HANDLER, (Object)attributeHandler);
                            result.set((Object)attributeHandler);
                            return false;
                        }
                        return true;
                    }
                });
                return (AttributeChildInvocationHandler)((Object)result.get());
            }
        });
    }

    @Nullable
    private static <T extends DomChildrenDescription> T findChildrenDescription(Collection<T> descriptions, XmlTag tag, DomInvocationHandler parent) {
        String localName = tag.getLocalName();
        String namespace = tag.getNamespace();
        String qName = tag.getName();
        XmlFile file = parent.getFile();
        for (DomChildrenDescription description : descriptions) {
            EvaluatedXmlName evaluatedXmlName;
            XmlName xmlName = description.getXmlName();
            if (!localName.equals(xmlName.getLocalName()) && !qName.equals(xmlName.getLocalName()) || !DomImplUtil.isNameSuitable(evaluatedXmlName = parent.createEvaluatedXmlName(xmlName), localName, qName, namespace, file)) continue;
            return (T)description;
        }
        return null;
    }
}

