/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.structure;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.util.Function;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementNavigationProvider;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ElementPresentation;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomStructureTreeElement
implements StructureViewTreeElement,
ItemPresentation {
    private final DomElement myElement;
    private final Function<DomElement, DomService.StructureViewMode> myDescriptor;
    private final DomElementNavigationProvider myNavigationProvider;

    public DomStructureTreeElement(@NotNull DomElement element, @NotNull Function<DomElement, DomService.StructureViewMode> descriptor, @Nullable DomElementNavigationProvider navigationProvider) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/structure/DomStructureTreeElement.<init> must not be null");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/xml/structure/DomStructureTreeElement.<init> must not be null");
        }
        this.myElement = element;
        this.myDescriptor = descriptor;
        this.myNavigationProvider = navigationProvider;
    }

    public DomElement getElement() {
        return this.myElement;
    }

    public DomElementNavigationProvider getNavigationProvider() {
        return this.myNavigationProvider;
    }

    public Object getValue() {
        return !this.myElement.isValid() ? null : this.myElement.getXmlElement();
    }

    public ItemPresentation getPresentation() {
        return this;
    }

    public TreeElement[] getChildren() {
        if (!this.myElement.isValid()) {
            return EMPTY_ARRAY;
        }
        final ArrayList result = new ArrayList();
        DomElementVisitor elementVisitor = new DomElementVisitor(){

            public void visitDomElement(DomElement element) {
                DomService.StructureViewMode viewMode = (DomService.StructureViewMode)DomStructureTreeElement.this.myDescriptor.fun((Object)element);
                switch (viewMode) {
                    case SHOW: {
                        result.add(new DomStructureTreeElement(element, (Function<DomElement, DomService.StructureViewMode>)DomStructureTreeElement.this.myDescriptor, DomStructureTreeElement.this.myNavigationProvider));
                        break;
                    }
                    case SHOW_CHILDREN: {
                        DomUtil.acceptAvailableChildren((DomElement)element, (DomElementVisitor)this);
                        break;
                    }
                }
            }
        };
        DomUtil.acceptAvailableChildren((DomElement)this.myElement, (DomElementVisitor)elementVisitor);
        return result.toArray(new TreeElement[result.size()]);
    }

    public void navigate(boolean requestFocus) {
        if (this.myNavigationProvider != null) {
            this.myNavigationProvider.navigate(this.myElement, true);
        }
    }

    public boolean canNavigate() {
        return this.myNavigationProvider != null && this.myNavigationProvider.canNavigate(this.myElement);
    }

    public boolean canNavigateToSource() {
        return this.myNavigationProvider != null && this.myNavigationProvider.canNavigate(this.myElement);
    }

    public String getPresentableText() {
        if (!this.myElement.isValid()) {
            return "<unknown>";
        }
        ElementPresentation presentation = this.myElement.getPresentation();
        String name = presentation.getElementName();
        return name != null ? name : presentation.getTypeName();
    }

    @Nullable
    public String getLocationString() {
        return null;
    }

    @Nullable
    public Icon getIcon(boolean open) {
        if (!this.myElement.isValid()) {
            return null;
        }
        return this.myElement.getPresentation().getIcon();
    }

    @Nullable
    public TextAttributesKey getTextAttributesKey() {
        return null;
    }
}

