/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointsConfigurationDialogFactory;
import org.jetbrains.annotations.Nullable;

public class ViewBreakpointsAction
extends AnAction {
    private Object myInitialBreakpoint;

    public ViewBreakpointsAction() {
        this(ActionsBundle.actionText((String)"ViewBreakpoints"), null);
    }

    public ViewBreakpointsAction(String name, Object initialBreakpoint) {
        super(name);
        this.myInitialBreakpoint = initialBreakpoint;
    }

    public void actionPerformed(AnActionEvent e) {
        Editor editor;
        DataContext dataContext = e.getDataContext();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        if (this.myInitialBreakpoint == null && (editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext)) != null) {
            this.myInitialBreakpoint = ViewBreakpointsAction.findSelectedBreakpoint(project, editor);
        }
        BreakpointsConfigurationDialogFactory.BreakpointsConfigurationDialog dialog = BreakpointsConfigurationDialogFactory.getInstance(project).createDialog(this.myInitialBreakpoint);
        dialog.show();
        this.myInitialBreakpoint = null;
    }

    @Nullable
    private static Object findSelectedBreakpoint(Project project, Editor editor) {
        DebuggerSupport[] debuggerSupports;
        int offset = editor.getCaretModel().getOffset();
        Document editorDocument = editor.getDocument();
        for (DebuggerSupport debuggerSupport : debuggerSupports = DebuggerSupport.getDebuggerSupports()) {
            Object breakpoint = debuggerSupport.getBreakpointPanelProvider().findBreakpoint(project, editorDocument, offset);
            if (breakpoint == null) continue;
            return breakpoint;
        }
        return null;
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(event.getDataContext());
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        presentation.setEnabled(true);
    }
}

