/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate.quick.common;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.project.Project;
import com.intellij.util.Alarm;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.evaluate.quick.common.AbstractValueHint;
import com.intellij.xdebugger.impl.evaluate.quick.common.QuickEvaluateHandler;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueHintType;
import java.awt.Point;
import org.jetbrains.annotations.NotNull;

public class ValueLookupManager
implements EditorMouseMotionListener,
ProjectComponent {
    private final Project myProject;
    private final Alarm myAlarm = new Alarm();
    private AbstractValueHint myRequest = null;
    private DebuggerSupport[] mySupports;

    public ValueLookupManager(Project project) {
        this.myProject = project;
    }

    public void disposeComponent() {
    }

    public void initComponent() {
        this.mySupports = DebuggerSupport.getDebuggerSupports();
    }

    public void projectOpened() {
        EditorFactory.getInstance().getEventMulticaster().addEditorMouseMotionListener((EditorMouseMotionListener)this, (Disposable)this.myProject);
    }

    public void projectClosed() {
        this.myAlarm.cancelAllRequests();
    }

    public void mouseDragged(EditorMouseEvent e) {
    }

    public void mouseMoved(EditorMouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
        Editor editor = e.getEditor();
        if (editor.getProject() != null && editor.getProject() != this.myProject) {
            return;
        }
        Point point = e.getMouseEvent().getPoint();
        if (this.myRequest != null) {
            if (this.myRequest.isKeepHint(editor, point)) {
                return;
            }
            this.hideHint();
        }
        for (DebuggerSupport support : this.mySupports) {
            QuickEvaluateHandler handler = support.getQuickEvaluateHandler();
            if (!handler.isEnabled(this.myProject)) continue;
            this.requestHint(handler, editor, point, AbstractValueHint.getType(e));
            break;
        }
    }

    private void requestHint(final QuickEvaluateHandler handler, final Editor editor, final Point point, final ValueHintType type) {
        this.myAlarm.cancelAllRequests();
        if (type == ValueHintType.MOUSE_OVER_HINT) {
            this.myAlarm.addRequest(new Runnable(){

                @Override
                public void run() {
                    ValueLookupManager.this.showHint(handler, editor, point, type);
                }
            }, handler.getValueLookupDelay(this.myProject));
        } else {
            this.showHint(handler, editor, point, type);
        }
    }

    public void hideHint() {
        if (this.myRequest != null) {
            this.myRequest.hideHint();
            this.myRequest = null;
        }
    }

    public void showHint(QuickEvaluateHandler handler, Editor editor, Point point, ValueHintType type) {
        this.myAlarm.cancelAllRequests();
        this.hideHint();
        if (editor.isDisposed() || !handler.canShowHint(this.myProject)) {
            return;
        }
        this.myRequest = handler.createValueHint(this.myProject, editor, point, type);
        if (this.myRequest != null) {
            this.myRequest.invokeHint();
        }
    }

    public static ValueLookupManager getInstance(Project project) {
        return (ValueLookupManager)project.getComponent(ValueLookupManager.class);
    }

    @NotNull
    public String getComponentName() {
        if ("ValueLookupManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xdebugger/impl/evaluate/quick/common/ValueLookupManager.getComponentName must not return null");
        }
        return "ValueLookupManager";
    }
}

