/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XJumpToSourceAction
extends XDebuggerTreeActionBase {
    @Override
    protected void perform(final XValueNodeImpl node, @NotNull String nodeName, AnActionEvent e) {
        if (nodeName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xdebugger/impl/ui/tree/actions/XJumpToSourceAction.perform must not be null");
        }
        XValue value = (XValue)node.getValueContainer();
        value.computeSourcePosition(new XNavigatable(){

            public void setSourcePosition(final @Nullable XSourcePosition sourcePosition) {
                if (sourcePosition != null) {
                    DebuggerUIUtil.invokeOnEventDispatch(new Runnable(){

                        @Override
                        public void run() {
                            Project project = node.getTree().getProject();
                            if (project.isDisposed()) {
                                return;
                            }
                            sourcePosition.createNavigatable(project).navigate(true);
                        }
                    });
                }
            }
        });
    }
}

