/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.daemon.Validator;
import com.intellij.javaee.ExternalResourceManager;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.javaee.UriUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.StringPattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.patterns.XmlTagPattern;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLock;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.XmlTagFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.psi.impl.source.html.HtmlDocumentImpl;
import com.intellij.psi.impl.source.xml.XmlEntityRefImpl;
import com.intellij.psi.scope.processor.FilterElementProcessor;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.xml.XmlAttlistDecl;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeDecl;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlConditionalSection;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementDecl;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlEntityRef;
import com.intellij.psi.xml.XmlEnumeratedType;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlFileNSInfoProvider;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.JDOMXIncluder;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.XmlSchemaProvider;
import com.intellij.xml.impl.schema.ComplexTypeDescriptor;
import com.intellij.xml.impl.schema.TypeDescriptor;
import com.intellij.xml.impl.schema.XmlElementDescriptorImpl;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.index.IndexedRelevantResource;
import com.intellij.xml.index.XmlNamespaceIndex;
import com.intellij.xml.util.XmlIncludeHandler;
import com.intellij.xml.util.XmlTagUtil;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.xml.util.XmlUtil");
    @NonNls
    public static final String TAGLIB_1_2_URI = "http://java.sun.com/dtd/web-jsptaglibrary_1_2.dtd";
    @NonNls
    public static final String XML_SCHEMA_URI = "http://www.w3.org/2001/XMLSchema";
    @NonNls
    public static final String XML_SCHEMA_URI2 = "http://www.w3.org/1999/XMLSchema";
    @NonNls
    public static final String XML_SCHEMA_URI3 = "http://www.w3.org/2000/10/XMLSchema";
    public static final String[] SCHEMA_URIS = new String[]{"http://www.w3.org/2001/XMLSchema", "http://www.w3.org/1999/XMLSchema", "http://www.w3.org/2000/10/XMLSchema"};
    @NonNls
    public static final String XML_SCHEMA_INSTANCE_URI = "http://www.w3.org/2001/XMLSchema-instance";
    @NonNls
    public static final String XSLT_URI = "http://www.w3.org/1999/XSL/Transform";
    @NonNls
    public static final String XINCLUDE_URI = "http://www.w3.org/2001/XInclude";
    @NonNls
    public static final String ANT_URI = "http://ant.apache.org/schema.xsd";
    @NonNls
    public static final String XHTML_URI = "http://www.w3.org/1999/xhtml";
    @NonNls
    public static final String HTML_URI = "http://www.w3.org/1999/html";
    @NonNls
    public static final String EMPTY_URI = "";
    @NonNls
    public static final Key<String> TEST_PATH = Key.create((String)"TEST PATH");
    @NonNls
    public static final String JSP_URI = "http://java.sun.com/JSP/Page";
    @NonNls
    public static final String ANY_URI = "http://www.intellij.net/ns/any";
    @NonNls
    public static final String JSTL_CORE_URI = "http://java.sun.com/jsp/jstl/core";
    @NonNls
    public static final String JSTL_CORE_URI2 = "http://java.sun.com/jstl/core";
    @NonNls
    public static final String JSTL_CORE_URI3 = "http://java.sun.com/jstl/core_rt";
    @NonNls
    public static final String[] JSTL_CORE_URIS = new String[]{"http://java.sun.com/jsp/jstl/core", "http://java.sun.com/jstl/core", "http://java.sun.com/jstl/core_rt"};
    @NonNls
    public static final String JSF_HTML_URI = "http://java.sun.com/jsf/html";
    @NonNls
    public static final String JSF_CORE_URI = "http://java.sun.com/jsf/core";
    @NonNls
    private static final String JSTL_FORMAT_URI = "http://java.sun.com/jsp/jstl/fmt";
    @NonNls
    private static final String JSTL_FORMAT_URI2 = "http://java.sun.com/jstl/fmt";
    @NonNls
    private static final String JSTL_FORMAT_URI3 = "http://java.sun.com/jstl/fmt_rt";
    @NonNls
    public static final String[] JSTL_FORMAT_URIS = new String[]{"http://java.sun.com/jsp/jstl/fmt", "http://java.sun.com/jstl/fmt", "http://java.sun.com/jstl/fmt_rt"};
    @NonNls
    public static final String SPRING_URI = "http://www.springframework.org/tags";
    @NonNls
    public static final String SPRING_FORMS_URI = "http://www.springframework.org/tags/form";
    @NonNls
    public static final String STRUTS_BEAN_URI = "http://struts.apache.org/tags-bean";
    @NonNls
    public static final String STRUTS_BEAN_URI2 = "http://jakarta.apache.org/struts/tags-bean";
    @NonNls
    public static final String APACHE_I18N_URI = "http://jakarta.apache.org/taglibs/i18n-1.0";
    @NonNls
    public static final String STRUTS_LOGIC_URI = "http://struts.apache.org/tags-logic";
    @NonNls
    public static final String STRUTS_HTML_URI = "http://struts.apache.org/tags-html";
    @NonNls
    public static final String STRUTS_HTML_URI2 = "http://jakarta.apache.org/struts/tags-html";
    @NonNls
    public static final String APACHE_TRINIDAD_URI = "http://myfaces.apache.org/trinidad";
    @NonNls
    public static final String APACHE_TRINIDAD_HTML_URI = "http://myfaces.apache.org/trinidad/html";
    @NonNls
    public static final String[] HIBERNATE_URIS = new String[]{"http://hibernate.sourceforge.net/hibernate-mapping-3.0.dtd", "http://hibernate.sourceforge.net/hibernate-mapping-2.0.dtd"};
    @NonNls
    public static final String XSD_SIMPLE_CONTENT_TAG = "simpleContent";
    @NonNls
    public static final String NO_NAMESPACE_SCHEMA_LOCATION_ATT = "noNamespaceSchemaLocation";
    @NonNls
    public static final String SCHEMA_LOCATION_ATT = "schemaLocation";
    @NonNls
    public static final String[] WEB_XML_URIS = new String[]{"http://java.sun.com/xml/ns/j2ee", "http://java.sun.com/xml/ns/javaee", "http://java.sun.com/dtd/web-app_2_3.dtd", "http://java.sun.com/j2ee/dtds/web-app_2_2.dtd"};
    @NonNls
    public static final String FACELETS_URI = "http://java.sun.com/jsf/facelets";
    @NonNls
    public static final String JSTL_FUNCTIONS_URI = "http://java.sun.com/jsp/jstl/functions";
    @NonNls
    public static final String JSTL_FUNCTIONS_URI2 = "http://java.sun.com/jstl/functions";
    @NonNls
    public static final String JSTL_FN_FACELET_URI = "com.sun.facelets.tag.jstl.fn.JstlFnLibrary";
    @NonNls
    public static final String JSTL_CORE_FACELET_URI = "com.sun.facelets.tag.jstl.core.JstlCoreLibrary";
    @NonNls
    public static final String TARGET_NAMESPACE_ATTR_NAME = "targetNamespace";
    @NonNls
    public static final String XML_NAMESPACE_URI = "http://www.w3.org/XML/1998/namespace";
    public static final List<String> ourSchemaUrisList = Arrays.asList(SCHEMA_URIS);
    private static final ThreadLocal<String> XML_FILE_IN_PROGRESS = new ThreadLocal();
    public static final Key<Boolean> ANT_FILE_SIGN = new Key("FORCED ANT FILE");
    @NonNls
    public static final String TAG_DIR_NS_PREFIX = "urn:jsptagdir:";
    @NonNls
    public static final String VALUE_ATTR_NAME = "value";
    @NonNls
    public static final String ENUMERATION_TAG_NAME = "enumeration";
    public static final String HTML4_LOOSE_URI = "http://www.w3.org/TR/html4/loose.dtd";
    private static final Key<CachedValue<PsiElement>> PARSED_DECL_KEY = Key.create((String)"PARSED_DECL_KEY");
    private static final String HTML5_SCHEMA_LOCATION;
    @NonNls
    private static final byte[] XML_PROLOG_START_BYTES;
    @NonNls
    private static final byte[] ENCODING_BYTES;
    @NonNls
    private static final byte[] XML_PROLOG_END_BYTES;

    private XmlUtil() {
    }

    @Nullable
    public static String getSchemaLocation(XmlTag tag, String namespace) {
        String uri = ExternalResourceManagerEx.getInstanceEx().getResourceLocation(namespace, tag.getProject());
        if (uri != null && !uri.equals(namespace)) {
            return uri;
        }
        while (true) {
            if (EMPTY_URI.equals(namespace)) {
                String attributeValue = tag.getAttributeValue(NO_NAMESPACE_SCHEMA_LOCATION_ATT, XML_SCHEMA_INSTANCE_URI);
                if (attributeValue != null) {
                    return attributeValue;
                }
            } else {
                int start;
                String schemaLocation = tag.getAttributeValue(SCHEMA_LOCATION_ATT, XML_SCHEMA_INSTANCE_URI);
                if (schemaLocation != null && (start = schemaLocation.indexOf(namespace)) >= 0) {
                    StringTokenizer tokenizer = new StringTokenizer(schemaLocation.substring((start += namespace.length()) + 1));
                    if (tokenizer.hasMoreTokens()) {
                        return tokenizer.nextToken();
                    }
                    return null;
                }
            }
            if (!(tag.getParent() instanceof XmlTag)) break;
            tag = (XmlTag)tag.getParent();
        }
        return null;
    }

    @Nullable
    public static String findNamespacePrefixByURI(XmlFile file, @NonNls String uri) {
        if (file == null) {
            return null;
        }
        XmlDocument document = file.getDocument();
        if (document == null) {
            return null;
        }
        XmlTag tag = document.getRootTag();
        if (tag == null) {
            return null;
        }
        for (XmlAttribute attribute : tag.getAttributes()) {
            if (attribute.getName().startsWith("xmlns:") && attribute.getValue().equals(uri)) {
                return attribute.getName().substring("xmlns:".length());
            }
            if (!"xmlns".equals(attribute.getName()) || !attribute.getValue().equals(uri)) continue;
            return EMPTY_URI;
        }
        return null;
    }

    public static String[] findNamespacesByURI(XmlFile file, String uri) {
        if (file == null) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        XmlDocument document = file.getDocument();
        if (document == null) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        XmlTag tag = document.getRootTag();
        if (tag == null) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        XmlAttribute[] attributes = tag.getAttributes();
        ArrayList<String> result = new ArrayList<String>();
        for (XmlAttribute attribute : attributes) {
            if (attribute.getName().startsWith("xmlns:") && attribute.getValue().equals(uri)) {
                result.add(attribute.getName().substring("xmlns:".length()));
            }
            if (!"xmlns".equals(attribute.getName()) || !attribute.getValue().equals(uri)) continue;
            result.add(EMPTY_URI);
        }
        return ArrayUtil.toStringArray(result);
    }

    @Nullable
    public static String getXsiNamespace(XmlFile file) {
        return XmlUtil.findNamespacePrefixByURI(file, XML_SCHEMA_INSTANCE_URI);
    }

    @Nullable
    public static XmlFile findNamespace(PsiFile base, @NotNull String nsLocation) {
        if (nsLocation == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xml/util/XmlUtil.findNamespace must not be null");
        }
        String location = ExternalResourceManager.getInstance().getResourceLocation(nsLocation, base.getProject());
        if (!location.equals(nsLocation)) {
            return XmlUtil.findXmlFile(base, location);
        }
        XmlFile xmlFile = XmlSchemaProvider.findSchema((String)location, (PsiFile)base);
        return xmlFile == null ? XmlUtil.findXmlFile(base, location) : xmlFile;
    }

    @Nullable
    public static XmlFile findNamespaceByLocation(PsiFile base, @NotNull String nsLocation) {
        if (nsLocation == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xml/util/XmlUtil.findNamespaceByLocation must not be null");
        }
        String location = ExternalResourceManager.getInstance().getResourceLocation(nsLocation, base.getProject());
        return XmlUtil.findXmlFile(base, location);
    }

    public static Collection<XmlFile> findNSFilesByURI(String namespace, Project project, Module module) {
        List<IndexedRelevantResource<String, String>> resources = XmlNamespaceIndex.getResourcesByNamespace(namespace, project, module);
        final PsiManager psiManager = PsiManager.getInstance((Project)project);
        return ContainerUtil.mapNotNull(resources, (Function)new NullableFunction<IndexedRelevantResource<String, String>, XmlFile>(){

            public XmlFile fun(IndexedRelevantResource<String, String> stringStringIndexedRelevantResource) {
                PsiFile file = psiManager.findFile(stringStringIndexedRelevantResource.getFile());
                return file instanceof XmlFile ? (XmlFile)file : null;
            }
        });
    }

    @Nullable
    public static XmlFile findXmlFile(PsiFile base, @NotNull String uri) {
        String data;
        if (uri == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xml/util/XmlUtil.findXmlFile must not be null");
        }
        PsiFile result = null;
        if (ApplicationManager.getApplication().isUnitTestMode() && (data = (String)base.getOriginalFile().getUserData(TEST_PATH)) != null) {
            String filePath = data + "/" + uri;
            VirtualFile path = LocalFileSystem.getInstance().findFileByPath(filePath.replace(File.separatorChar, '/'));
            if (path != null) {
                result = base.getManager().findFile(path);
            }
        }
        if (result == null) {
            result = XmlUtil.findRelativeFile(uri, (PsiElement)base);
        }
        if (result instanceof XmlFile) {
            return (XmlFile)result;
        }
        return null;
    }

    @Nullable
    public static XmlToken getTokenOfType(PsiElement element, IElementType type) {
        PsiElement[] children;
        if (element == null) {
            return null;
        }
        for (PsiElement child : children = element.getChildren()) {
            XmlToken token;
            if (!(child instanceof XmlToken) || (token = (XmlToken)child).getTokenType() != type) continue;
            return token;
        }
        return null;
    }

    public static boolean processXmlElements(XmlElement element, PsiElementProcessor processor, boolean deepFlag) {
        return XmlUtil.processXmlElements(element, processor, deepFlag, false);
    }

    public static boolean processXmlElements(XmlElement element, PsiElementProcessor processor, boolean deepFlag, boolean wideFlag) {
        if (element == null) {
            return true;
        }
        PsiFile baseFile = element.isValid() ? element.getContainingFile() : null;
        return XmlUtil.processXmlElements(element, processor, deepFlag, wideFlag, baseFile);
    }

    public static boolean processXmlElements(XmlElement element, PsiElementProcessor processor, boolean deepFlag, boolean wideFlag, PsiFile baseFile) {
        return XmlUtil.processXmlElements(element, processor, deepFlag, wideFlag, baseFile, true);
    }

    public static boolean processXmlElements(XmlElement element, PsiElementProcessor processor, boolean deepFlag, boolean wideFlag, PsiFile baseFile, boolean processIncludes) {
        return new XmlElementProcessor(processor, baseFile).processXmlElements((PsiElement)element, deepFlag, wideFlag, processIncludes);
    }

    public static boolean processXmlElementChildren(XmlElement element, PsiElementProcessor processor, boolean deepFlag) {
        XmlElementProcessor p = new XmlElementProcessor(processor, element.getContainingFile());
        boolean wideFlag = false;
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (p.processElement(child, deepFlag, false, true)) continue;
            return false;
        }
        return true;
    }

    public static ParserDefinition.SpaceRequirements canStickTokensTogetherByLexerInXml(ASTNode left, ASTNode right, Lexer lexer, int state) {
        if (left.getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN || right.getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN) {
            return ParserDefinition.SpaceRequirements.MUST_NOT;
        }
        if (left.getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER && right.getElementType() == XmlTokenType.XML_NAME) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        if (left.getElementType() == XmlTokenType.XML_NAME && right.getElementType() == XmlTokenType.XML_NAME) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        return ParserDefinition.SpaceRequirements.MAY;
    }

    public static boolean tagFromTemplateFramework(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/util/XmlUtil.tagFromTemplateFramework must not be null");
        }
        String ns = tag.getNamespace();
        return XmlUtil.nsFromTemplateFramework(ns);
    }

    public static boolean nsFromTemplateFramework(String ns) {
        return XSLT_URI.equals(ns) || XINCLUDE_URI.equals(ns);
    }

    public static char getCharFromEntityRef(@NonNls String text) {
        if (text.charAt(1) != '#') {
            text = text.substring(1, text.length() - 1);
            return XmlTagUtil.getCharacterByEntityName((String)text).charValue();
        }
        text = text.substring(2, text.length() - 1);
        try {
            int code;
            if (StringUtil.startsWithChar((CharSequence)text, (char)'x')) {
                text = text.substring(1);
                code = Integer.parseInt(text, 16);
            } else {
                code = Integer.parseInt(text);
            }
            return (char)code;
        }
        catch (NumberFormatException e) {
            return '\u0000';
        }
    }

    public static boolean attributeFromTemplateFramework(@NonNls String name, XmlTag tag) {
        return "jsfc".equals(name) && tag.getNSDescriptor(JSF_HTML_URI, true) != null;
    }

    @Nullable
    public static String getTargetSchemaNsFromTag(@Nullable XmlTag xmlTag) {
        if (xmlTag == null) {
            return null;
        }
        String targetNamespace = xmlTag.getAttributeValue(TARGET_NAMESPACE_ATTR_NAME, XML_SCHEMA_URI);
        if (targetNamespace == null) {
            targetNamespace = xmlTag.getAttributeValue(TARGET_NAMESPACE_ATTR_NAME, XML_SCHEMA_URI2);
        }
        if (targetNamespace == null) {
            targetNamespace = xmlTag.getAttributeValue(TARGET_NAMESPACE_ATTR_NAME, XML_SCHEMA_URI3);
        }
        return targetNamespace;
    }

    @Nullable
    public static XmlTag getSchemaSimpleContent(@NotNull XmlTag tag) {
        TypeDescriptor type;
        if (tag == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/util/XmlUtil.getSchemaSimpleContent must not be null");
        }
        XmlElementDescriptor descriptor = tag.getDescriptor();
        if (descriptor instanceof XmlElementDescriptorImpl && (type = ((XmlElementDescriptorImpl)descriptor).getType((XmlElement)tag)) instanceof ComplexTypeDescriptor) {
            final XmlTag[] simpleContent = new XmlTag[1];
            XmlUtil.processXmlElements((XmlElement)((ComplexTypeDescriptor)type).getDeclaration(), new PsiElementProcessor(){

                public boolean execute(PsiElement element) {
                    if (element instanceof XmlTag) {
                        XmlTag tag = (XmlTag)element;
                        String s = ((XmlTag)element).getLocalName();
                        if ((s.equals(XmlUtil.XSD_SIMPLE_CONTENT_TAG) || s.equals("restriction") && "string".equals(XmlUtil.findLocalNameByQualifiedName(tag.getAttributeValue("base")))) && tag.getNamespace().equals(XmlUtil.XML_SCHEMA_URI)) {
                            simpleContent[0] = tag;
                            return false;
                        }
                    }
                    return true;
                }
            }, true);
            return simpleContent[0];
        }
        return null;
    }

    public static <T extends PsiElement> void doDuplicationCheckForElements(T[] elements, Map<String, T> presentNames, DuplicationInfoProvider<T> provider, Validator.ValidationHost host) {
        for (T t : elements) {
            String name = provider.getName((PsiElement)t);
            if (name == null) continue;
            String nameKey = provider.getNameKey((PsiElement)t, name);
            if (presentNames.containsKey(nameKey)) {
                PsiElement psiElement = (PsiElement)presentNames.get(nameKey);
                String message = XmlBundle.message((String)"duplicate.declaration", (Object[])new Object[]{nameKey});
                if (psiElement != null) {
                    presentNames.put(nameKey, null);
                    host.addMessage(provider.getNodeForMessage(psiElement), message, 1);
                }
                host.addMessage(provider.getNodeForMessage((PsiElement)t), message, 1);
                continue;
            }
            presentNames.put(nameKey, t);
        }
    }

    public static String getEntityValue(XmlEntityRef entityRef) {
        String value;
        XmlAttributeValue valueElement;
        XmlEntityDecl decl = entityRef.resolve(entityRef.getContainingFile());
        if (decl != null && (valueElement = decl.getValueElement()) != null && (value = valueElement.getValue()) != null) {
            return value;
        }
        return entityRef.getText();
    }

    public static boolean isAntFile(PsiFile file) {
        XmlTag tag;
        XmlFile xmlFile;
        XmlDocument document;
        if (file instanceof XmlFile && (document = (xmlFile = (XmlFile)file).getDocument()) != null && (tag = document.getRootTag()) != null && "project".equals(tag.getName()) && tag.getContext() instanceof XmlDocument) {
            if (tag.getAttributeValue("default") != null) {
                return true;
            }
            VirtualFile vFile = xmlFile.getOriginalFile().getVirtualFile();
            if (vFile != null && vFile.getUserData(ANT_FILE_SIGN) != null) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static PsiFile findRelativeFile(String uri, PsiElement base) {
        if (base instanceof PsiFile) {
            PsiFile baseFile = (PsiFile)base;
            VirtualFile file = UriUtil.findRelative((String)uri, (PsiFileSystemItem)baseFile.getOriginalFile());
            if (file == null) {
                return null;
            }
            return base.getManager().findFile(file);
        }
        if (base instanceof PsiDirectory) {
            PsiDirectory baseDir = (PsiDirectory)base;
            VirtualFile file = UriUtil.findRelative((String)uri, (PsiFileSystemItem)baseDir);
            if (file == null) {
                return null;
            }
            return base.getManager().findFile(file);
        }
        return null;
    }

    @Nullable
    public static String getCommentText(XmlComment comment) {
        XmlToken token;
        PsiElement nextSibling;
        PsiElement firstChild = comment.getFirstChild();
        if (firstChild != null && (nextSibling = firstChild.getNextSibling()) instanceof XmlToken && (token = (XmlToken)nextSibling).getTokenType() == XmlTokenType.XML_COMMENT_CHARACTERS) {
            return token.getText();
        }
        return null;
    }

    @Nullable
    public static PsiElement findNamespaceDeclaration(PsiFile xmlFile, String nsName) {
        XmlTag rootTag;
        XmlDocument document;
        if (xmlFile instanceof XmlFile && (document = ((XmlFile)xmlFile).getDocument()) != null && (rootTag = document.getRootTag()) != null) {
            for (XmlAttribute attribute : rootTag.getAttributes()) {
                if (!attribute.isNamespaceDeclaration() || !attribute.getLocalName().equals(nsName)) continue;
                return attribute;
            }
        }
        return null;
    }

    private static PsiElement parseEntityRef(PsiFile targetFile, XmlEntityRef ref, boolean cacheValue) {
        PsiElement element;
        XmlEntityDecl entityDecl;
        int type = XmlUtil.getContextType(ref);
        XmlEntityDecl entityDecl2 = ref.resolve(targetFile);
        if (entityDecl2 != null) {
            return XmlUtil.parseEntityDecl(entityDecl2, targetFile, type, cacheValue, ref);
        }
        XmlEntityRef e = ref;
        while (e != null) {
            if (e.getUserData(XmlElement.INCLUDING_ELEMENT) != null) {
                PsiFile f = (e = (PsiElement)e.getUserData(XmlElement.INCLUDING_ELEMENT)).getContainingFile();
                if (f == null || (entityDecl = ref.resolve(targetFile)) == null) continue;
                return XmlUtil.parseEntityDecl(entityDecl, targetFile, type, cacheValue, ref);
            }
            if (e instanceof PsiFile) {
                PsiFile refFile = (PsiFile)e;
                entityDecl = ref.resolve(refFile);
                if (entityDecl == null) break;
                return XmlUtil.parseEntityDecl(entityDecl, targetFile, type, cacheValue, ref);
            }
            e = e.getParent();
        }
        if ((element = (PsiElement)ref.getUserData(XmlElement.DEPENDING_ELEMENT)) instanceof XmlFile && (entityDecl = ref.resolve((PsiFile)element)) != null) {
            return XmlUtil.parseEntityDecl(entityDecl, targetFile, type, cacheValue, ref);
        }
        return null;
    }

    private static int getContextType(XmlEntityRef ref) {
        int type = 5;
        for (XmlEntityRef temp = ref; temp != null; temp = temp.getContext()) {
            if (temp instanceof XmlAttributeDecl) {
                type = 2;
                break;
            }
            if (temp instanceof XmlElementDecl) {
                type = 1;
                break;
            }
            if (temp instanceof XmlAttlistDecl) {
                type = 3;
                break;
            }
            if (temp instanceof XmlEntityDecl) {
                type = 4;
                break;
            }
            if (temp instanceof XmlEnumeratedType) {
                type = 6;
                break;
            }
            if (!(temp instanceof XmlAttributeValue)) continue;
            type = 7;
            break;
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PsiElement parseEntityDecl(final XmlEntityDecl entityDecl, final PsiFile targetFile, final int type, boolean cacheValue, final XmlEntityRef entityRef) {
        if (!cacheValue) {
            return entityDecl.parse(targetFile, type, entityRef);
        }
        Object object = PsiLock.LOCK;
        synchronized (object) {
            CachedValue value = (CachedValue)entityRef.getUserData(PARSED_DECL_KEY);
            if (value == null) {
                value = CachedValuesManager.getManager((Project)entityDecl.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<PsiElement>(){

                    public CachedValueProvider.Result<PsiElement> compute() {
                        PsiElement res = entityDecl.parse(targetFile, type, entityRef);
                        if (res == null) {
                            return new CachedValueProvider.Result((Object)res, new Object[]{targetFile});
                        }
                        if (!entityDecl.isInternalReference()) {
                            XmlEntityRefImpl.copyEntityCaches(res.getContainingFile(), targetFile);
                        }
                        return new CachedValueProvider.Result((Object)res, new Object[]{res.getUserData(XmlElement.DEPENDING_ELEMENT), entityDecl, targetFile, entityRef});
                    }
                }, false);
                entityRef.putUserData(PARSED_DECL_KEY, (Object)value);
            }
            return (PsiElement)value.getValue();
        }
    }

    public static XmlTag addChildTag(XmlTag parent, XmlTag child) throws IncorrectOperationException {
        return XmlUtil.addChildTag(parent, child, -1);
    }

    public static XmlTag addChildTag(XmlTag parent, XmlTag child, int index) throws IncorrectOperationException {
        if (parent.getSubTags().length == 0 && parent.getText().endsWith("/>")) {
            XmlElementFactory factory = XmlElementFactory.getInstance((Project)parent.getProject());
            String name = parent.getName();
            String text = parent.getText();
            XmlTag tag = factory.createTagFromText(text.substring(0, text.length() - 2) + "></" + name + ">");
            parent = (XmlTag)parent.replace((PsiElement)tag);
        }
        XmlElementDescriptor parentDescriptor = parent.getDescriptor();
        XmlTag[] subTags = parent.getSubTags();
        if (parentDescriptor == null || subTags.length == 0) {
            return (XmlTag)parent.add((PsiElement)child);
        }
        int subTagNum = -1;
        for (XmlElementDescriptor childElementDescriptor : parentDescriptor.getElementsDescriptors(parent)) {
            String childElementName = childElementDescriptor.getName();
            int prevSubTagNum = subTagNum;
            while (subTagNum < subTags.length - 1 && subTags[subTagNum + 1].getName().equals(childElementName)) {
                ++subTagNum;
            }
            if (!childElementName.equals(child.getLocalName())) continue;
            subTagNum = index == -1 || index > subTagNum - prevSubTagNum ? subTagNum : prevSubTagNum + index;
            return (XmlTag)(subTagNum == -1 ? parent.addBefore((PsiElement)child, (PsiElement)subTags[0]) : parent.addAfter((PsiElement)child, (PsiElement)subTags[subTagNum]));
        }
        return (XmlTag)parent.add((PsiElement)child);
    }

    public static String getAttributeValue(XmlTag tag, String name) {
        for (XmlAttribute attribute : tag.getAttributes()) {
            if (!name.equals(attribute.getName())) continue;
            return attribute.getValue();
        }
        return null;
    }

    public static XmlTag findOnAnyLevel(XmlTag root, String[] chain) {
        XmlTag curTag = root;
        for (String s : chain) {
            if ((curTag = curTag.findFirstSubTag(s)) != null) continue;
            return null;
        }
        return curTag;
    }

    public static XmlTag findSubTag(XmlTag rootTag, String path) {
        String curTagName;
        String[] pathElements = path.split("/");
        XmlTag curTag = rootTag;
        String[] arr$ = pathElements;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (curTag = curTag.findFirstSubTag(curTagName = arr$[i$])) != null; ++i$) {
        }
        return curTag;
    }

    @Nullable
    public static XmlTag findSubTagWithValue(XmlTag rootTag, String tagName, String tagValue) {
        XmlTag[] subTags;
        if (rootTag == null) {
            return null;
        }
        for (XmlTag subTag : subTags = rootTag.findSubTags(tagName)) {
            if (!subTag.getValue().getTrimmedText().equals(tagValue)) continue;
            return subTag;
        }
        return null;
    }

    @Nullable
    public static XmlTag find(String subTag, String withValue, String forTag, XmlTag insideRoot) {
        XmlTag[] forTags;
        for (XmlTag tag : forTags = insideRoot.findSubTags(forTag)) {
            XmlTag[] allTags;
            for (XmlTag curTag : allTags = tag.findSubTags(subTag)) {
                if (!curTag.getName().equals(subTag) || !curTag.getValue().getTrimmedText().equalsIgnoreCase(withValue)) continue;
                return tag;
            }
        }
        return null;
    }

    @Nullable
    @NonNls
    public static String[][] getDefaultNamespaces(XmlDocument document) {
        Language language;
        String namespace;
        XmlFile file = XmlUtil.getContainingFile((PsiElement)document);
        XmlTag tag = document.getRootTag();
        if (tag == null) {
            return null;
        }
        if (file != null) {
            XmlFileNSInfoProvider[] nsProviders;
            block0: for (XmlFileNSInfoProvider nsProvider : nsProviders = (XmlFileNSInfoProvider[])Extensions.getExtensions((ExtensionPointName)XmlFileNSInfoProvider.EP_NAME)) {
                String[][] pairs = nsProvider.getDefaultNamespaces(file);
                if (pairs == null || pairs.length <= 0) continue;
                for (String[] nsMapping : pairs) {
                    if (nsMapping != null && nsMapping.length == 2 && nsMapping[0] != null && nsMapping[1] != null) continue;
                    LOG.debug("NSInfoProvider " + nsProvider + " gave wrong info about " + file.getVirtualFile());
                    continue block0;
                }
                return pairs;
            }
        }
        if ((namespace = XmlUtil.getDtdUri(document)) != null) {
            boolean overrideNamespaceFromDocType = false;
            if (file != null) {
                FileType fileType = file.getFileType();
                boolean bl = overrideNamespaceFromDocType = fileType == StdFileTypes.HTML || fileType == StdFileTypes.XHTML || fileType == StdFileTypes.JSPX || fileType == StdFileTypes.JSP;
            }
            if (!overrideNamespaceFromDocType) {
                return new String[][]{{EMPTY_URI, namespace}};
            }
        }
        if ("taglib".equals(tag.getName())) {
            return new String[][]{{EMPTY_URI, TAGLIB_1_2_URI}};
        }
        if (file != null && ((language = file.getLanguage()) == HTMLLanguage.INSTANCE || language == XHTMLLanguage.INSTANCE)) {
            return new String[][]{{EMPTY_URI, XHTML_URI}};
        }
        return null;
    }

    @Nullable
    public static String getDtdUri(XmlDocument document) {
        XmlProlog prolog = document.getProlog();
        if (prolog != null) {
            return XmlUtil.getDtdUri(prolog.getDoctype());
        }
        return null;
    }

    @Nullable
    public static String getDtdUri(XmlDoctype doctype) {
        if (doctype != null) {
            String docType = doctype.getDtdUri();
            if (docType == null && PsiTreeUtil.getParentOfType((PsiElement)doctype, XmlDocument.class) instanceof HtmlDocumentImpl) {
                String publicId = doctype.getPublicId();
                if (publicId != null && publicId.indexOf("-//W3C//DTD HTML") != -1) {
                    return HTML4_LOOSE_URI;
                }
                if (publicId == null) {
                    docType = HTML5_SCHEMA_LOCATION;
                }
            }
            return docType;
        }
        return null;
    }

    private static void computeTag(XmlTag tag, final Map<String, List<String>> tagsMap, final Map<String, List<MyAttributeInfo>> attributesMap, final boolean processIncludes) {
        XmlAttribute[] attributes;
        if (tag == null) {
            return;
        }
        String tagName = tag.getName();
        List<MyAttributeInfo> list = attributesMap.get(tagName);
        if (list == null) {
            list = new ArrayList<MyAttributeInfo>();
            for (XmlAttribute attribute : attributes = tag.getAttributes()) {
                list.add(new MyAttributeInfo(attribute.getName()));
            }
        } else {
            attributes = tag.getAttributes();
            ContainerUtil.sort(list);
            Arrays.sort(attributes, new Comparator<XmlAttribute>(){

                @Override
                public int compare(XmlAttribute attr1, XmlAttribute attr2) {
                    return attr1.getName().compareTo(attr2.getName());
                }
            });
            Iterator<MyAttributeInfo> iter = list.iterator();
            list = new ArrayList<MyAttributeInfo>();
            int index = 0;
            while (iter.hasNext()) {
                MyAttributeInfo info = iter.next();
                boolean requiredFlag = false;
                while (attributes.length > index) {
                    if (info.compareTo(attributes[index]) != 0) {
                        if (info.compareTo(attributes[index]) < 0) break;
                        if (attributes[index].getValue() != null) {
                            list.add(new MyAttributeInfo(attributes[index].getName(), false));
                        }
                        ++index;
                        continue;
                    }
                    requiredFlag = true;
                    ++index;
                    break;
                }
                info.myRequired &= requiredFlag;
                list.add(info);
            }
            while (attributes.length > index) {
                if (attributes[index].getValue() != null) {
                    list.add(new MyAttributeInfo(attributes[index++].getName(), false));
                    continue;
                }
                ++index;
            }
        }
        attributesMap.put(tagName, list);
        final List<Object> tags = tagsMap.get(tagName) != null ? tagsMap.get(tagName) : new ArrayList();
        tagsMap.put(tagName, tags);
        PsiFile file = tag.isValid() ? tag.getContainingFile() : null;
        XmlUtil.processXmlElements((XmlElement)tag, new FilterElementProcessor(XmlTagFilter.INSTANCE){

            @Override
            public void add(PsiElement element) {
                XmlTag tag = (XmlTag)element;
                if (!tags.contains(tag.getName())) {
                    tags.add(tag.getName());
                }
                XmlUtil.computeTag(tag, tagsMap, attributesMap, processIncludes);
            }
        }, false, false, file, processIncludes);
    }

    @Nullable
    public static XmlElementDescriptor findXmlDescriptorByType(XmlTag xmlTag) {
        return XmlUtil.findXmlDescriptorByType(xmlTag, null);
    }

    @Nullable
    public static XmlElementDescriptor findXmlDescriptorByType(XmlTag xmlTag, @Nullable XmlTag context) {
        String ns;
        String type = xmlTag.getAttributeValue("type", XML_SCHEMA_INSTANCE_URI);
        if (type == null && ourSchemaUrisList.indexOf(ns = xmlTag.getNamespace()) >= 0) {
            type = xmlTag.getAttributeValue("type", null);
        }
        XmlElementDescriptor elementDescriptor = null;
        if (type != null) {
            String namespaceByPrefix = XmlUtil.findNamespaceByPrefix(XmlUtil.findPrefixByQualifiedName(type), xmlTag);
            XmlNSDescriptor typeDecr = xmlTag.getNSDescriptor(namespaceByPrefix, true);
            if (typeDecr == null && namespaceByPrefix.length() == 0) {
                XmlDocument document;
                PsiFile containingFile;
                if (context != null) {
                    typeDecr = context.getNSDescriptor(EMPTY_URI, true);
                }
                if (typeDecr == null && (containingFile = xmlTag.getContainingFile()) instanceof XmlFile && (document = ((XmlFile)containingFile).getDocument()) != null) {
                    typeDecr = (XmlNSDescriptor)document.getMetaData();
                }
            }
            if (typeDecr instanceof XmlNSDescriptorImpl) {
                XmlNSDescriptorImpl schemaDescriptor = (XmlNSDescriptorImpl)typeDecr;
                elementDescriptor = schemaDescriptor.getDescriptorByType(type, xmlTag);
            }
        }
        return elementDescriptor;
    }

    public static boolean collectEnumerationValues(XmlTag element, final HashSet<String> variants) {
        return XmlUtil.processEnumerationValues(element, new Processor<XmlTag>(){

            public boolean process(XmlTag xmlTag) {
                variants.add(xmlTag.getAttributeValue(XmlUtil.VALUE_ATTR_NAME));
                return true;
            }
        });
    }

    public static boolean processEnumerationValues(XmlTag element, Processor<XmlTag> tagProcessor) {
        boolean exaustiveEnum = true;
        for (XmlTag tag : element.getSubTags()) {
            String localName = tag.getLocalName();
            if (localName.equals(ENUMERATION_TAG_NAME)) {
                String attributeValue = tag.getAttributeValue(VALUE_ATTR_NAME);
                if (attributeValue == null) continue;
                tagProcessor.process((Object)tag);
                continue;
            }
            if (localName.equals("union")) {
                exaustiveEnum = false;
                XmlUtil.processEnumerationValues(tag, tagProcessor);
                continue;
            }
            if (localName.equals("annotation")) continue;
            exaustiveEnum &= XmlUtil.processEnumerationValues(tag, tagProcessor);
        }
        return exaustiveEnum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlTag createChildTag(XmlTag xmlTag, String localName, String namespace, String bodyText, boolean enforceNamespacesDeep) {
        final String prefix = xmlTag.getPrefixByNamespace(namespace);
        String qname = prefix != null && prefix.length() > 0 ? prefix + ":" + localName : localName;
        try {
            XmlTag retTag;
            String tagStart;
            StringBuilder tagStartBuilder = StringBuilderSpinAllocator.alloc();
            try {
                tagStartBuilder.append(qname);
                if (!(xmlTag.getPrefixByNamespace(namespace) != null || StringUtil.isEmpty((String)xmlTag.getNamespacePrefix()) && namespace.equals(xmlTag.getNamespace()))) {
                    tagStartBuilder.append(" xmlns=\"");
                    tagStartBuilder.append(namespace);
                    tagStartBuilder.append("\"");
                }
                tagStart = tagStartBuilder.toString();
            }
            finally {
                StringBuilderSpinAllocator.dispose((StringBuilder)tagStartBuilder);
            }
            Language language = xmlTag.getLanguage();
            if (!(language instanceof HTMLLanguage)) {
                language = StdFileTypes.XML.getLanguage();
            }
            if (bodyText != null && bodyText.length() > 0) {
                retTag = XmlElementFactory.getInstance((Project)xmlTag.getProject()).createTagFromText("<" + tagStart + ">" + bodyText + "</" + qname + ">", language);
                if (enforceNamespacesDeep) {
                    retTag.acceptChildren((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                        public void visitXmlTag(XmlTag tag) {
                            String namespacePrefix = tag.getNamespacePrefix();
                            if (namespacePrefix.length() == 0) {
                                String qname = prefix != null && prefix.length() > 0 ? prefix + ":" + tag.getLocalName() : tag.getLocalName();
                                try {
                                    tag.setName(qname);
                                }
                                catch (IncorrectOperationException e) {
                                    LOG.error((Throwable)e);
                                }
                            }
                            super.visitXmlTag(tag);
                        }
                    });
                }
            } else {
                retTag = XmlElementFactory.getInstance((Project)xmlTag.getProject()).createTagFromText("<" + tagStart + "/>", language);
            }
            return retTag;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @Nullable
    public static Pair<XmlTagChild, XmlTagChild> findTagChildrenInRange(PsiFile file, int startOffset, int endOffset) {
        PsiElement elementAt;
        PsiElement elementAt2;
        PsiElement elementAtStart = file.findElementAt(startOffset);
        PsiElement elementAtEnd = file.findElementAt(endOffset - 1);
        if (elementAtStart instanceof PsiWhiteSpace) {
            startOffset = elementAtStart.getTextRange().getEndOffset();
            elementAtStart = file.findElementAt(startOffset);
        }
        if (elementAtEnd instanceof PsiWhiteSpace) {
            endOffset = elementAtEnd.getTextRange().getStartOffset();
            elementAtEnd = file.findElementAt(endOffset - 1);
        }
        if (elementAtStart == null || elementAtEnd == null) {
            return null;
        }
        XmlTagChild first = (XmlTagChild)PsiTreeUtil.getParentOfType((PsiElement)elementAtStart, XmlTagChild.class);
        if (first == null) {
            return null;
        }
        if (!(first.getTextRange().getStartOffset() == startOffset || (elementAt2 = file.findElementAt(first.getTextRange().getStartOffset())) instanceof PsiWhiteSpace && elementAt2.getTextRange().getEndOffset() == startOffset)) {
            return null;
        }
        XmlTagChild last = first;
        while (last != null && last.getTextRange().getEndOffset() < endOffset) {
            last = (XmlTagChild)PsiTreeUtil.getNextSiblingOfType((PsiElement)last, XmlTagChild.class);
        }
        if (last == null) {
            return null;
        }
        if (!(last.getTextRange().getEndOffset() == elementAtEnd.getTextRange().getEndOffset() || (elementAt = file.findElementAt(last.getTextRange().getEndOffset() - 1)) instanceof PsiWhiteSpace && elementAt.getTextRange().getStartOffset() == endOffset)) {
            return null;
        }
        return new Pair((Object)first, (Object)last);
    }

    public static boolean isSimpleXmlAttributeValue(String unquotedValue, XmlAttributeValue context) {
        for (int i = 0; i < unquotedValue.length(); ++i) {
            char ch = unquotedValue.charAt(i);
            if (Character.isJavaIdentifierPart(ch) || ch == ':' || ch == '-') continue;
            XmlFile file = (XmlFile)PsiTreeUtil.getParentOfType((PsiElement)context, XmlFile.class);
            if (file != null) {
                return !XmlUtil.tagFromTemplateFramework(file.getDocument().getRootTag());
            }
            return false;
        }
        return true;
    }

    public static boolean toCode(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (!XmlUtil.toCode(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean toCode(char ch) {
        return "<&>\u00a0".indexOf(ch) >= 0;
    }

    @Nullable
    public static PsiNamedElement findRealNamedElement(final @NotNull PsiNamedElement _element) {
        if (_element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/util/XmlUtil.findRealNamedElement must not be null");
        }
        PsiNamedElement currentElement = _element;
        final XmlEntityRef lastEntityRef = (XmlEntityRef)PsiTreeUtil.getParentOfType((PsiElement)currentElement, XmlEntityRef.class);
        while (!(currentElement instanceof XmlFile)) {
            PsiElement dependingElement = (PsiElement)currentElement.getUserData(XmlElement.DEPENDING_ELEMENT);
            if (dependingElement == null) {
                dependingElement = currentElement.getContext();
            }
            currentElement = dependingElement;
            if (dependingElement != null) continue;
            break;
        }
        if (currentElement instanceof XmlFile) {
            XmlEntityDecl cachedEntity;
            final String name = _element.getName();
            if (_element instanceof XmlEntityDecl && (cachedEntity = XmlEntityRefImpl.getCachedEntity((PsiFile)currentElement, name)) != null) {
                return cachedEntity;
            }
            final PsiNamedElement[] result = new PsiNamedElement[1];
            XmlUtil.processXmlElements((XmlElement)((XmlFile)currentElement), new PsiElementProcessor(){

                public boolean execute(PsiElement element) {
                    if (element instanceof PsiNamedElement) {
                        String elementName = ((PsiNamedElement)element).getName();
                        if (elementName.equals(name) && _element.getClass().isInstance(element)) {
                            result[0] = (PsiNamedElement)element;
                            return false;
                        }
                        if (lastEntityRef != null && element instanceof XmlEntityDecl && elementName.equals(lastEntityRef.getText().substring(1, lastEntityRef.getTextLength() - 1))) {
                            result[0] = (PsiNamedElement)element;
                            return false;
                        }
                    }
                    return true;
                }
            }, true);
            return result[0];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateDocumentDTD(XmlDocument doc, boolean full) {
        LinkedHashMap<String, List<String>> tags = new LinkedHashMap<String, List<String>>();
        LinkedHashMap<String, List<MyAttributeInfo>> attributes = new LinkedHashMap<String, List<MyAttributeInfo>>();
        try {
            PsiElement element;
            XmlEntityRefImpl.setNoEntityExpandOutOfDocument(doc, true);
            XmlTag rootTag = doc.getRootTag();
            XmlUtil.computeTag(rootTag, tags, attributes, full);
            PsiElement psiElement = element = rootTag != null ? rootTag.getNextSibling() : null;
            while (element != null) {
                if (element instanceof XmlTag) {
                    XmlUtil.computeTag((XmlTag)element, tags, attributes, full);
                }
                element = element.getNextSibling();
            }
        }
        finally {
            XmlEntityRefImpl.setNoEntityExpandOutOfDocument(doc, false);
        }
        StringBuilder buffer = new StringBuilder();
        for (String tagName : tags.keySet()) {
            buffer.append(XmlUtil.generateElementDTD(tagName, (List)tags.get(tagName), (List)attributes.get(tagName)));
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateElementDTD(String name, List<String> tags, List<MyAttributeInfo> attributes) {
        if (name == null || EMPTY_URI.equals(name)) {
            return EMPTY_URI;
        }
        if (name.contains(CompletionUtil.DUMMY_IDENTIFIER_TRIMMED)) {
            return EMPTY_URI;
        }
        StringBuilder buffer = StringBuilderSpinAllocator.alloc();
        try {
            buffer.append("<!ELEMENT ").append(name).append(" ");
            if (tags.isEmpty()) {
                buffer.append("(#PCDATA)>\n");
            } else {
                buffer.append("(");
                Iterator<String> iter = tags.iterator();
                while (iter.hasNext()) {
                    String tagName = iter.next();
                    buffer.append(tagName);
                    if (iter.hasNext()) {
                        buffer.append("|");
                        continue;
                    }
                    buffer.append(")*");
                }
                buffer.append(">\n");
            }
            if (!attributes.isEmpty()) {
                buffer.append("<!ATTLIST ").append(name);
                for (MyAttributeInfo info : attributes) {
                    buffer.append("\n    ").append(XmlUtil.generateAttributeDTD(info));
                }
                buffer.append(">\n");
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String generateAttributeDTD(MyAttributeInfo info) {
        if (info.myName.contains(CompletionUtil.DUMMY_IDENTIFIER_TRIMMED)) {
            return EMPTY_URI;
        }
        StringBuilder buffer = StringBuilderSpinAllocator.alloc();
        try {
            buffer.append(info.myName).append(" ");
            buffer.append("CDATA");
            if (info.myRequired) {
                buffer.append(" #REQUIRED");
            } else {
                buffer.append(" #IMPLIED");
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)buffer);
        }
    }

    @Nullable
    public static String trimLeadingSpacesInMultilineTagValue(@NonNls String tagValue) {
        return tagValue == null ? null : tagValue.replaceAll("\n\\s*", "\n");
    }

    public static String findNamespaceByPrefix(String prefix, XmlTag contextTag) {
        return contextTag.getNamespaceByPrefix(prefix);
    }

    public static String findPrefixByQualifiedName(String name) {
        int prefixEnd = name.indexOf(58);
        if (prefixEnd > 0) {
            return name.substring(0, prefixEnd);
        }
        return EMPTY_URI;
    }

    @Nullable
    public static String findLocalNameByQualifiedName(String name) {
        return name == null ? null : name.substring(name.indexOf(58) + 1);
    }

    public static XmlFile getContainingFile(PsiElement element) {
        while (!(element instanceof XmlFile) && element != null) {
            PsiElement context = element.getContext();
            if (context == null) {
                XmlExtension extension = XmlExtension.getExtensionByElement(element);
                if (extension == null) continue;
                element = extension.getContainingFile(element);
                continue;
            }
            if (element == context) {
                LOG.error("Context==element: " + element.getClass());
                return null;
            }
            element = context;
        }
        return (XmlFile)element;
    }

    @Nullable
    public static String getSubTagValue(XmlTag tag, String subTagName) {
        XmlTag subTag = tag.findFirstSubTag(subTagName);
        if (subTag != null) {
            return subTag.getValue().getTrimmedText();
        }
        return null;
    }

    public static int getStartOffsetInFile(XmlTag xmlTag) {
        int off = 0;
        while (true) {
            off += xmlTag.getStartOffsetInParent();
            PsiElement parent = xmlTag.getParent();
            if (!(parent instanceof XmlTag)) break;
            xmlTag = (XmlTag)parent;
        }
        return off;
    }

    public static XmlElement setNewValue(XmlElement tag, String value) throws IncorrectOperationException {
        if (tag instanceof XmlTag) {
            ((XmlTag)tag).getValue().setText(value);
            return tag;
        }
        if (tag instanceof XmlAttribute) {
            XmlAttribute attr = (XmlAttribute)tag;
            attr.setValue(value);
            return attr;
        }
        throw new IncorrectOperationException();
    }

    public static String decode(@NonNls String text) {
        if (text.length() == 0) {
            return text;
        }
        if (text.charAt(0) != '&' || text.length() < 3) {
            if (text.indexOf(60) < 0 && text.indexOf(62) < 0) {
                return text;
            }
            return text.replaceAll("<!\\[CDATA\\[", EMPTY_URI).replaceAll("\\]\\]>", EMPTY_URI);
        }
        if (text.equals("&lt;")) {
            return "<";
        }
        if (text.equals("&gt;")) {
            return ">";
        }
        if (text.equals("&nbsp;")) {
            return "\u00a0";
        }
        if (text.equals("&amp;")) {
            return "&";
        }
        if (text.equals("&apos;")) {
            return "'";
        }
        if (text.equals("&quot;")) {
            return "\"";
        }
        if (text.startsWith("&quot;") && text.endsWith("&quot;")) {
            return "\"" + text.substring(6, text.length() - 6) + "\"";
        }
        if (text.startsWith("&#")) {
            text = text.substring(3, text.length() - 1);
            try {
                return String.valueOf((char)Integer.parseInt(text));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return text;
    }

    public static String unescape(String text) {
        return StringUtil.unescapeXml((String)text);
    }

    public static String escape(String text) {
        return StringUtil.escapeXml((String)text);
    }

    @Nullable
    public static String extractXmlEncodingFromProlog(byte[] content) {
        return XmlUtil.detect(content);
    }

    @Nullable
    private static String detect(byte[] bytes) {
        int index = 0;
        if (CharsetToolkit.hasUTF8Bom((byte[])bytes)) {
            index = CharsetToolkit.UTF8_BOM.length;
        }
        if (!ArrayUtil.startsWith((byte[])bytes, (int)(index = XmlUtil.skipWhiteSpace(index, bytes)), (byte[])XML_PROLOG_START_BYTES)) {
            return null;
        }
        index += XML_PROLOG_START_BYTES.length;
        while (index < bytes.length) {
            if (ArrayUtil.startsWith((byte[])bytes, (int)(index = XmlUtil.skipWhiteSpace(index, bytes)), (byte[])XML_PROLOG_END_BYTES)) {
                return null;
            }
            if (ArrayUtil.startsWith((byte[])bytes, (int)index, (byte[])ENCODING_BYTES)) {
                index += ENCODING_BYTES.length;
                if ((index = XmlUtil.skipWhiteSpace(index, bytes)) >= bytes.length || bytes[index] != 61) continue;
                ++index;
                if ((index = XmlUtil.skipWhiteSpace(index, bytes)) >= bytes.length || bytes[index] != 39 && bytes[index] != 34) continue;
                byte quote = bytes[index];
                ++index;
                StringBuilder encoding = new StringBuilder();
                while (index < bytes.length) {
                    if (bytes[index] == quote) {
                        return encoding.toString();
                    }
                    encoding.append((char)bytes[index++]);
                }
            }
            ++index;
        }
        return null;
    }

    private static int skipWhiteSpace(int start, byte[] bytes) {
        char c;
        while (start < bytes.length && Character.isWhitespace(c = (char)bytes[start])) {
            ++start;
        }
        return start;
    }

    @Nullable
    public static String extractXmlEncodingFromProlog(String text) {
        return XmlUtil.detect(CharsetToolkit.getUtf8Bytes((String)text));
    }

    public static void registerXmlAttributeValueReferenceProvider(PsiReferenceRegistrar registrar, @Nullable @NonNls String[] attributeNames, @Nullable ElementFilter elementFilter, @NotNull PsiReferenceProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/xml/util/XmlUtil.registerXmlAttributeValueReferenceProvider must not be null");
        }
        XmlUtil.registerXmlAttributeValueReferenceProvider(registrar, attributeNames, elementFilter, true, provider);
    }

    public static void registerXmlAttributeValueReferenceProvider(PsiReferenceRegistrar registrar, @Nullable @NonNls String[] attributeNames, @Nullable ElementFilter elementFilter, boolean caseSensitive, @NotNull PsiReferenceProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/xml/util/XmlUtil.registerXmlAttributeValueReferenceProvider must not be null");
        }
        XmlUtil.registerXmlAttributeValueReferenceProvider(registrar, attributeNames, elementFilter, caseSensitive, provider, 0.0);
    }

    public static void registerXmlAttributeValueReferenceProvider(PsiReferenceRegistrar registrar, @Nullable @NonNls String[] attributeNames, @Nullable ElementFilter elementFilter, boolean caseSensitive, @NotNull PsiReferenceProvider provider, double priority) {
        if (provider == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/xml/util/XmlUtil.registerXmlAttributeValueReferenceProvider must not be null");
        }
        if (attributeNames == null) {
            registrar.registerReferenceProvider((ElementPattern)XmlPatterns.xmlAttributeValue().and((ElementPattern)new FilterPattern(elementFilter)), provider, priority);
            return;
        }
        StringPattern namePattern = caseSensitive ? StandardPatterns.string().oneOf(attributeNames) : StandardPatterns.string().oneOfIgnoreCase(attributeNames);
        registrar.registerReferenceProvider((ElementPattern)XmlPatterns.xmlAttributeValue().withLocalName((ElementPattern)namePattern).and((ElementPattern)new FilterPattern(elementFilter)), provider, priority);
    }

    public static void registerXmlTagReferenceProvider(PsiReferenceRegistrar registrar, @NonNls String[] names, @Nullable ElementFilter elementFilter, boolean caseSensitive, @NotNull PsiReferenceProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/xml/util/XmlUtil.registerXmlTagReferenceProvider must not be null");
        }
        if (names == null) {
            registrar.registerReferenceProvider((ElementPattern)XmlPatterns.xmlTag().and((ElementPattern)new FilterPattern(elementFilter)), provider, 0.0);
            return;
        }
        StringPattern namePattern = caseSensitive ? StandardPatterns.string().oneOf(names) : StandardPatterns.string().oneOfIgnoreCase(names);
        registrar.registerReferenceProvider((ElementPattern)((XmlTagPattern.Capture)XmlPatterns.xmlTag().withLocalName((ElementPattern)namePattern)).and((ElementPattern)new FilterPattern(elementFilter)), provider, 0.0);
    }

    static {
        URL schemaLocationURL = XmlUtil.class.getResource("/standardSchemas/html5/xhtml5.xsd");
        VirtualFile relativeFile = schemaLocationURL != null ? VfsUtil.findFileByURL((URL)schemaLocationURL) : null;
        HTML5_SCHEMA_LOCATION = relativeFile != null ? relativeFile.getPath() : EMPTY_URI;
        XML_PROLOG_START_BYTES = CharsetToolkit.getUtf8Bytes((String)"<?xml");
        ENCODING_BYTES = CharsetToolkit.getUtf8Bytes((String)"encoding");
        XML_PROLOG_END_BYTES = CharsetToolkit.getUtf8Bytes((String)"?>");
    }

    public static interface DuplicationInfoProvider<T extends PsiElement> {
        @Nullable
        public String getName(@NotNull T var1);

        @NotNull
        public String getNameKey(@NotNull T var1, @NotNull String var2);

        @NotNull
        public PsiElement getNodeForMessage(@NotNull T var1);
    }

    private static class MyAttributeInfo
    implements Comparable {
        boolean myRequired = true;
        String myName = null;

        MyAttributeInfo(String name) {
            this.myName = name;
        }

        MyAttributeInfo(String name, boolean flag) {
            this.myName = name;
            this.myRequired = flag;
        }

        public int compareTo(Object o) {
            if (o instanceof MyAttributeInfo) {
                return this.myName.compareTo(((MyAttributeInfo)o).myName);
            }
            if (o instanceof XmlAttribute) {
                return this.myName.compareTo(((XmlAttribute)o).getName());
            }
            return -1;
        }
    }

    private static class XmlElementProcessor {
        private final PsiElementProcessor processor;
        private final PsiFile targetFile;
        private static final Key<CachedValue<PsiElement[]>> KEY_RESOLVED_XINCLUDE = Key.create((String)"RESOLVED_XINCLUDE");

        XmlElementProcessor(PsiElementProcessor _processor, PsiFile _targetFile) {
            this.processor = _processor;
            this.targetFile = _targetFile;
        }

        private boolean processXmlElements(PsiElement element, boolean deepFlag, boolean wideFlag, boolean processIncludes) {
            XmlTag tag;
            if (deepFlag && !this.processor.execute(element)) {
                return false;
            }
            PsiElement startFrom = element.getFirstChild();
            if (element instanceof XmlEntityRef) {
                XmlEntityRef ref = (XmlEntityRef)element;
                for (PsiElement newElement = XmlUtil.parseEntityRef(this.targetFile, ref, true); newElement != null; newElement = newElement.getNextSibling()) {
                    if (this.processElement(newElement, deepFlag, wideFlag, processIncludes)) continue;
                    return false;
                }
                return true;
            }
            if (element instanceof XmlConditionalSection) {
                XmlConditionalSection xmlConditionalSection = (XmlConditionalSection)element;
                if (!xmlConditionalSection.isIncluded(this.targetFile)) {
                    return true;
                }
                startFrom = xmlConditionalSection.getBodyStart();
            } else if (processIncludes && XmlIncludeHandler.isXInclude(element) && !this.processXInclude(deepFlag, wideFlag, tag = (XmlTag)element)) {
                return false;
            }
            for (PsiElement child = startFrom; child != null; child = child.getNextSibling()) {
                if (this.processElement(child, deepFlag, wideFlag, processIncludes) || wideFlag) continue;
                return false;
            }
            return true;
        }

        private boolean processXInclude(boolean deepFlag, boolean wideFlag, final XmlTag xincludeTag) {
            PsiElement[] inclusion = (PsiElement[])CachedValuesManager.getManager((Project)xincludeTag.getProject()).getCachedValue((UserDataHolder)xincludeTag, KEY_RESOLVED_XINCLUDE, (CachedValueProvider)new CachedValueProvider<PsiElement[]>(){

                public CachedValueProvider.Result<PsiElement[]> compute() {
                    CachedValueProvider.Result result = XmlElementProcessor.computeInclusion(xincludeTag);
                    result.setLockValue(true);
                    return result;
                }
            }, false);
            if (inclusion != null) {
                for (PsiElement psiElement : inclusion) {
                    if (this.processElement(psiElement, deepFlag, wideFlag, true)) continue;
                    return false;
                }
            }
            return true;
        }

        private static CachedValueProvider.Result<PsiElement[]> computeInclusion(final XmlTag xincludeTag) {
            ArrayList<Object> deps = new ArrayList<Object>();
            deps.add(xincludeTag.getContainingFile());
            XmlFile xmlFile = XmlIncludeHandler.resolveXIncludeFile(xincludeTag);
            PsiElement[] result = null;
            if (xmlFile != null) {
                XmlTag rootTag;
                deps.add(xmlFile);
                XmlDocument document = xmlFile.getDocument();
                if (document != null && (rootTag = document.getRootTag()) != null) {
                    Object[] includeTag = XmlElementProcessor.extractXpointer(rootTag, xincludeTag);
                    result = (PsiElement[])ContainerUtil.map((Object[])includeTag, (Function)new Function<XmlTag, PsiElement>(){

                        public PsiElement fun(XmlTag xmlTag) {
                            PsiElement psiElement = PsiUtilBase.copyElementPreservingOriginalLinks((PsiElement)xmlTag, (Key)XmlElement.ORIGINAL_ELEMENT);
                            psiElement.putUserData(XmlElement.INCLUDING_ELEMENT, (Object)xincludeTag.getParentTag());
                            psiElement.putUserData(XmlElement.ORIGINAL_ELEMENT, (Object)xmlTag);
                            return psiElement;
                        }
                    }, (Object[])new PsiElement[includeTag.length]);
                }
            }
            return new CachedValueProvider.Result(result, deps.toArray());
        }

        private static XmlTag[] extractXpointer(XmlTag rootTag, XmlTag xincludeTag) {
            String rootTagName;
            String pointer;
            Matcher matcher;
            String xpointer = xincludeTag.getAttributeValue("xpointer", XmlUtil.XINCLUDE_URI);
            if (xpointer != null && (matcher = JDOMXIncluder.XPOINTER_PATTERN.matcher(xpointer)).matches() && (matcher = JDOMXIncluder.CHILDREN_PATTERN.matcher(pointer = matcher.group(1))).matches() && (rootTagName = matcher.group(1)).equals(rootTag.getName())) {
                return rootTag.getSubTags();
            }
            return new XmlTag[]{rootTag};
        }

        private boolean processElement(PsiElement child, boolean deepFlag, boolean wideFlag, boolean processIncludes) {
            if (deepFlag ? !this.processXmlElements(child, true, wideFlag, processIncludes) : (child instanceof XmlEntityRef ? !this.processXmlElements(child, false, wideFlag, processIncludes) : (child instanceof XmlConditionalSection ? !this.processXmlElements(child, false, wideFlag, processIncludes) : (processIncludes && XmlIncludeHandler.isXInclude(child) ? !this.processXmlElements(child, false, wideFlag, processIncludes) : !this.processor.execute(child))))) {
                return false;
            }
            if (this.targetFile != null && child instanceof XmlEntityDecl) {
                XmlEntityDecl xmlEntityDecl = (XmlEntityDecl)child;
                XmlEntityRefImpl.cacheParticularEntity(this.targetFile, xmlEntityDecl);
            }
            return true;
        }
    }
}

