/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.thread;

import edu.emory.mathcs.backport.java.util.concurrent.CountDownLatch;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.Executors;
import edu.emory.mathcs.backport.java.util.concurrent.RejectedExecutionException;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import java.util.ArrayList;
import java.util.List;
import org.testng.internal.Utils;
import org.testng.internal.thread.IAtomicInteger;
import org.testng.internal.thread.IExecutor;
import org.testng.internal.thread.IThreadFactory;
import org.testng.internal.thread.TestNGThread;
import org.testng.internal.thread.port.AtomicIntegerAdapter;
import org.testng.internal.thread.port.ExecutorAdapter;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadUtil {
    public static void execute(List<? extends Runnable> workers, int threadCount, long maxTimeOut, boolean triggerAtOnce) {
        CountDownLatch startGate = new CountDownLatch(1);
        CountDownLatch endGate = new CountDownLatch(workers.size());
        CountDownLatch usedStartGate = triggerAtOnce ? startGate : null;
        ExecutorService pooledExecutor = Executors.newFixedThreadPool(threadCount);
        for (Runnable runnable : workers) {
            try {
                pooledExecutor.execute(new CountDownLatchedRunnable(runnable, endGate, usedStartGate));
            }
            catch (RejectedExecutionException reex) {}
        }
        try {
            if (triggerAtOnce) {
                usedStartGate.countDown();
            }
            endGate.await();
            pooledExecutor.shutdown();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            ThreadUtil.log(2, new StringBuffer().append("Error waiting for concurrent executors to finish ").append(e.getMessage()).toString());
        }
    }

    public static final String currentThreadInfo() {
        Thread currentThread = Thread.currentThread();
        return String.valueOf(new StringBuffer().append(currentThread.getName()).append("@").append(currentThread.hashCode()).toString());
    }

    public static final IExecutor createExecutor(int threadCount, String threadFactoryName) {
        return new ExecutorAdapter(threadCount, ThreadUtil.createFactory(threadFactoryName));
    }

    public static final IAtomicInteger createAtomicInteger(int initialValue) {
        return new AtomicIntegerAdapter(initialValue);
    }

    private static void log(int level, String msg) {
        Utils.log(new StringBuffer().append("ThreadUtil:").append(ThreadUtil.currentThreadInfo()).toString(), level, msg);
    }

    private static final IThreadFactory createFactory(String name) {
        return new ThreadFactoryImpl(name);
    }

    private static class CountDownLatchedRunnable
    implements Runnable {
        private final Runnable m_task;
        private final CountDownLatch m_startGate;
        private final CountDownLatch m_endGate;

        public CountDownLatchedRunnable(Runnable task, CountDownLatch endGate) {
            this(task, endGate, null);
        }

        public CountDownLatchedRunnable(Runnable task, CountDownLatch endGate, CountDownLatch startGate) {
            this.m_task = task;
            this.m_startGate = startGate;
            this.m_endGate = endGate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (null != this.m_startGate) {
                try {
                    this.m_startGate.await();
                }
                catch (InterruptedException iex) {
                    ThreadUtil.log(2, "Cannot wait for startup gate when executing " + this.m_task + "; thread was already interrupted " + iex.getMessage());
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            try {
                this.m_task.run();
                Object var3_2 = null;
                this.m_endGate.countDown();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.m_endGate.countDown();
                throw throwable;
            }
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ThreadFactoryImpl
    implements IThreadFactory,
    ThreadFactory {
        private String m_methodName;
        private List m_threads = new ArrayList();

        public ThreadFactoryImpl(String name) {
            this.m_methodName = name;
        }

        @Override
        public Thread newThread(Runnable run) {
            TestNGThread result = new TestNGThread(run, this.m_methodName);
            this.m_threads.add(result);
            return result;
        }

        @Override
        public Object getThreadFactory() {
            return this;
        }

        @Override
        public List<Thread> getThreads() {
            return this.m_threads;
        }
    }
}

