/*
 * Decompiled with CFR 0.152.
 */
package org.testng.remote.strprotocol;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.testng.remote.strprotocol.GenericMessage;
import org.testng.remote.strprotocol.SuiteMessage;
import org.testng.remote.strprotocol.TestMessage;
import org.testng.remote.strprotocol.TestResultMessage;

public class MessageHelper {
    public static final char DELIMITER = '\u0001';
    public static final char PARAM_DELIMITER = '\u0004';
    private static final char LINE_SEP_DELIMITER_1 = '\u0002';
    private static final char LINE_SEP_DELIMITER_2 = '\u0003';
    public static final int GENERIC_SUITE_COUNT = 1;
    public static final int SUITE = 10;
    public static final int SUITE_START = 11;
    public static final int SUITE_FINISH = 12;
    public static final int TEST = 100;
    public static final int TEST_START = 101;
    public static final int TEST_FINISH = 102;
    public static final int TEST_RESULT = 1000;
    public static final int PASSED_TEST = 1001;
    public static final int FAILED_TEST = 1002;
    public static final int SKIPPED_TEST = 1003;
    public static final int FAILED_ON_PERCENTAGE_TEST = 1004;
    public static final int TEST_STARTED = 1016;
    public static final String STOP_MSG = ">STOP";
    public static final String ACK_MSG = ">ACK";

    public static int getMessageType(String message) {
        int idx = message.indexOf(1);
        return idx == -1 ? Integer.parseInt(message) : Integer.parseInt(message.substring(0, idx));
    }

    public static GenericMessage unmarshallGenericMessage(String message) {
        String[] messageParts = MessageHelper.parseMessage(message);
        if (messageParts.length == 1) {
            return new GenericMessage(Integer.parseInt(messageParts[0]));
        }
        HashMap<String, String> props = new HashMap<String, String>();
        for (int i = 1; i < messageParts.length; i += 2) {
            props.put(messageParts[i], messageParts[i + 1]);
        }
        return new GenericMessage(Integer.parseInt(messageParts[0]), props);
    }

    public static SuiteMessage createSuiteMessage(String message) {
        int type = MessageHelper.getMessageType(message);
        String[] messageParts = MessageHelper.parseMessage(message);
        return new SuiteMessage(messageParts[1], 11 == type, Integer.parseInt(messageParts[2]));
    }

    public static TestMessage createTestMessage(String message) {
        int type = MessageHelper.getMessageType(message);
        String[] messageParts = MessageHelper.parseMessage(message);
        return new TestMessage(101 == type, messageParts[1], messageParts[2], Integer.parseInt(messageParts[3]), Integer.parseInt(messageParts[4]), Integer.parseInt(messageParts[5]), Integer.parseInt(messageParts[6]), Integer.parseInt(messageParts[7]));
    }

    public static TestResultMessage unmarshallTestResultMessage(String message) {
        String[] messageParts = MessageHelper.parseMessage(message);
        String parametersFragment = null;
        String startTimestampFragment = null;
        String stopTimestampFragment = null;
        String stackTraceFragment = null;
        String testDescriptor = null;
        switch (messageParts.length) {
            case 10: {
                parametersFragment = messageParts[5];
                startTimestampFragment = messageParts[6];
                stopTimestampFragment = messageParts[7];
                stackTraceFragment = messageParts[8];
                testDescriptor = messageParts[9];
                break;
            }
            case 9: {
                parametersFragment = messageParts[5];
                startTimestampFragment = messageParts[6];
                stopTimestampFragment = messageParts[7];
                stackTraceFragment = messageParts[8];
                break;
            }
            default: {
                parametersFragment = null;
                startTimestampFragment = messageParts[5];
                stopTimestampFragment = messageParts[6];
                stackTraceFragment = messageParts[7];
            }
        }
        return new TestResultMessage(Integer.parseInt(messageParts[0]), messageParts[1], messageParts[2], messageParts[3], messageParts[4], MessageHelper.replaceAsciiCharactersWithUnicode(MessageHelper.replaceNewLineReplacer(testDescriptor)), MessageHelper.parseParameters(parametersFragment), Long.parseLong(startTimestampFragment), Long.parseLong(stopTimestampFragment), MessageHelper.replaceAsciiCharactersWithUnicode(MessageHelper.replaceNewLineReplacer(stackTraceFragment)));
    }

    public static String replaceNewLine(String message) {
        if (null == message) {
            return message;
        }
        return message.replace('\n', '\u0002').replace('\r', '\u0003');
    }

    public static String replaceUnicodeCharactersWithAscii(String message) {
        if (null == message) {
            return message;
        }
        return MessageHelper.replace(MessageHelper.replace(MessageHelper.replace(MessageHelper.replace(message, "\u0004", "\\u0004"), "\u0003", "\\u0003"), "\u0002", "\\u0002"), "\u0001", "\\u0001");
    }

    public static String replaceAsciiCharactersWithUnicode(String message) {
        if (null == message) {
            return message;
        }
        return MessageHelper.replace(MessageHelper.replace(MessageHelper.replace(MessageHelper.replace(message, "\\u0004", "\u0004"), "\\u0003", "\u0003"), "\\u0002", "\u0002"), "\\u0001", "\u0001");
    }

    public static String replaceNewLineReplacer(String message) {
        if (null == message) {
            return message;
        }
        return message.replace('\u0002', '\n').replace('\u0003', '\r');
    }

    private static String[] parseParameters(String messagePart) {
        return MessageHelper.tokenize(messagePart, '\u0004');
    }

    private static String[] parseMessage(String message) {
        return MessageHelper.tokenize(message, '\u0001');
    }

    private static String[] tokenize(String message, char separator) {
        if (null == message) {
            return new String[0];
        }
        ArrayList<String> tokens = new ArrayList<String>();
        int start = 0;
        for (int i = 0; i < message.length(); ++i) {
            if (separator != message.charAt(i)) continue;
            tokens.add(message.substring(start, i));
            start = i + 1;
        }
        if (start < message.length()) {
            tokens.add(message.substring(start, message.length()));
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    private static final String replace(String original, CharSequence target, CharSequence replacement) {
        return Pattern.compile(((Object)target).toString(), 16).matcher(original).replaceAll(MessageHelper.quoteReplacement(((Object)replacement).toString()));
    }

    private static String quoteReplacement(String s) {
        if (s.indexOf(92) == -1 && s.indexOf(36) == -1) {
            return s;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                sb.append('\\');
                sb.append('\\');
                continue;
            }
            if (c == '$') {
                sb.append('\\');
                sb.append('$');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

