/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.projectView;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.ResourceBundleAsVirtualFile;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ResourceBundleNode
extends ProjectViewNode<ResourceBundle> {
    public ResourceBundleNode(Project project, ResourceBundle resourceBundle, ViewSettings settings) {
        super(project, (Object)resourceBundle, settings);
    }

    public ResourceBundleNode(Project project, Object value, ViewSettings viewSettings) {
        this(project, (ResourceBundle)value, viewSettings);
    }

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        List<PropertiesFile> propertiesFiles = ((ResourceBundle)this.getValue()).getPropertiesFiles(this.myProject);
        ArrayList<AbstractTreeNode> children = new ArrayList<AbstractTreeNode>();
        for (PropertiesFile propertiesFile : propertiesFiles) {
            PsiFileNode node = new PsiFileNode(this.myProject, (PsiFile)propertiesFile, this.getSettings());
            children.add((AbstractTreeNode)node);
        }
        ArrayList<AbstractTreeNode> arrayList = children;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/properties/projectView/ResourceBundleNode.getChildren must not return null");
        }
        return arrayList;
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/projectView/ResourceBundleNode.contains must not be null");
        }
        if (!file.isValid()) {
            return false;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.getProject()).findFile(file);
        if (!(psiFile instanceof PropertiesFile)) {
            return false;
        }
        PropertiesFile propertiesFile = (PropertiesFile)psiFile;
        return ((ResourceBundle)this.getValue()).getPropertiesFiles(this.myProject).contains(propertiesFile);
    }

    public VirtualFile getVirtualFile() {
        List<PropertiesFile> list = ((ResourceBundle)this.getValue()).getPropertiesFiles(this.myProject);
        if (!list.isEmpty()) {
            return list.get(0).getVirtualFile();
        }
        return null;
    }

    public void update(PresentationData presentation) {
        presentation.setOpenIcon(ResourceBundle.ICON_OPEN);
        presentation.setClosedIcon(ResourceBundle.ICON_CLOSED);
        presentation.setPresentableText(PropertiesBundle.message("project.view.resource.bundle.tree.node.text", ((ResourceBundle)this.getValue()).getBaseName()));
    }

    public boolean canNavigateToSource() {
        return true;
    }

    public boolean canNavigate() {
        return true;
    }

    public void navigate(boolean requestFocus) {
        OpenFileDescriptor descriptor = new OpenFileDescriptor(this.getProject(), (VirtualFile)new ResourceBundleAsVirtualFile((ResourceBundle)this.getValue()));
        FileEditorManager.getInstance((Project)this.getProject()).openTextEditor(descriptor, requestFocus);
    }

    public boolean isSortByFirstChild() {
        return true;
    }

    public Comparable getTypeSortKey() {
        return new PsiFileNode.ExtensionSortKey(StdFileTypes.PROPERTIES.getDefaultExtension());
    }
}

