/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.psi.impl.reference;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.psi.AntImport;
import com.intellij.lang.ant.psi.AntStructuredElement;
import com.intellij.lang.ant.psi.impl.reference.AntFileReferenceSet;
import com.intellij.lang.ant.psi.impl.reference.AntReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.resolve.reference.impl.CachingReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.IncorrectOperationException;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntFileReference
extends FileReference
implements AntReference {
    public AntFileReference(AntFileReferenceSet set, TextRange range, int index, String text) {
        super((FileReferenceSet)set, range, index, text);
    }

    @Nullable
    public String getText() {
        String _path = this.getElement().computeAttributeValue(super.getText());
        if (_path == null) {
            return null;
        }
        String text = FileUtil.toSystemIndependentName((String)_path);
        return text.endsWith("/") ? text.substring(0, text.length() - "/".length()) : text;
    }

    public AntStructuredElement getElement() {
        return (AntStructuredElement)super.getElement();
    }

    @NotNull
    public AntFileReferenceSet getFileReferenceSet() {
        AntFileReferenceSet antFileReferenceSet = (AntFileReferenceSet)super.getFileReferenceSet();
        if (antFileReferenceSet == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/reference/AntFileReference.getFileReferenceSet must not return null");
        }
        return antFileReferenceSet;
    }

    @Override
    public String getUnresolvedMessagePattern() {
        return AntBundle.message("file.doesnt.exist", this.getCanonicalRepresentationText());
    }

    @Override
    public boolean shouldBeSkippedByAnnotator() {
        return this.isSoft();
    }

    @Override
    public void setShouldBeSkippedByAnnotator(boolean value) {
    }

    @Override
    @NotNull
    public IntentionAction[] getFixes() {
        if (IntentionAction.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/reference/AntFileReference.getFixes must not return null");
        }
        return IntentionAction.EMPTY_ARRAY;
    }

    @Override
    @Nullable
    public String getCanonicalRepresentationText() {
        AntStructuredElement element = this.getElement();
        String value = this.getCanonicalText();
        return element.computeAttributeValue(value);
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        AntStructuredElement antElement = this.getElement();
        PsiElement element = this.getManipulatorElement();
        CachingReference.getManipulator((PsiElement)element).handleContentChange(element, this.getRangeInElement().shiftRight(antElement.getTextRange().getStartOffset() - element.getTextRange().getStartOffset()), newElementName);
        return antElement;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        String newName;
        String baseDir;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/psi/impl/reference/AntFileReference.bindToElement must not be null");
        }
        if (!(element instanceof PsiFileSystemItem)) {
            throw new IncorrectOperationException("Cannot bind to element");
        }
        VirtualFile dstVFile = PsiUtilBase.getVirtualFile((PsiElement)element);
        AntStructuredElement se = this.getElement();
        PsiFile file = se.getContainingFile();
        if (dstVFile == null) {
            throw new IncorrectOperationException("Cannot bind to non-physical element:" + element);
        }
        VirtualFile currentFile = file.getVirtualFile();
        if (!(se instanceof AntImport) && (baseDir = se.getAntProject().getBaseDir()) != null && baseDir.length() > 0) {
            File f = new File(currentFile.getParent().getPath(), baseDir);
            currentFile = LocalFileSystem.getInstance().findFileByPath(f.getAbsolutePath().replace(File.separatorChar, '/'));
        }
        if ((newName = VfsUtil.getPath((VirtualFile)currentFile, (VirtualFile)dstVFile, (char)'/')) == null) {
            throw new IncorrectOperationException("Cannot find path between files; src = " + currentFile.getPresentableUrl() + "; dst = " + dstVFile.getPresentableUrl());
        }
        PsiElement me = this.getManipulatorElement();
        TextRange range = new TextRange(this.getFileReferenceSet().getStartInElement(), this.getRangeInElement().getEndOffset());
        range = range.shiftRight(se.getTextRange().getStartOffset() - me.getTextRange().getStartOffset());
        return CachingReference.getManipulator((PsiElement)me).handleContentChange(me, range, newName);
    }

    private PsiElement getManipulatorElement() {
        return this.getFileReferenceSet().getManipulatorElement();
    }
}

