/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.psi.impl.reference.providers;

import com.intellij.lang.ant.misc.PsiReferenceListSpinAllocator;
import com.intellij.lang.ant.psi.AntStructuredElement;
import com.intellij.lang.ant.psi.impl.reference.AntAttributeReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.ProcessingContext;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AntAttributeReferenceProvider
extends PsiReferenceProvider {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        int count;
        PsiReference[] psiReferenceArray;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/psi/impl/reference/providers/AntAttributeReferenceProvider.getReferencesByElement must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/ant/psi/impl/reference/providers/AntAttributeReferenceProvider.getReferencesByElement must not be null");
        }
        if (!(element instanceof AntStructuredElement)) {
            psiReferenceArray = PsiReference.EMPTY_ARRAY;
            if (PsiReference.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/reference/providers/AntAttributeReferenceProvider.getReferencesByElement must not return null");
            return psiReferenceArray;
        }
        AntStructuredElement se = (AntStructuredElement)element;
        int elementStartOffset = se.getTextRange().getStartOffset();
        List<PsiReference> list = PsiReferenceListSpinAllocator.alloc();
        for (PsiElement child : se.getSourceElement().getChildren()) {
            PsiElement nameElement;
            if (child instanceof XmlToken) {
                XmlToken token = (XmlToken)child;
                if (!token.getTokenType().toString().equals("XML_TAG_END")) continue;
                break;
            }
            if (child instanceof PsiWhiteSpace) {
                int off = child.getTextRange().getStartOffset() - elementStartOffset + 1;
                list.add((PsiReference)new AntAttributeReference(se, " ", new TextRange(off, off), null));
                continue;
            }
            if (!(child instanceof XmlAttribute) || (nameElement = child.getFirstChild()) == null) continue;
            int off = nameElement.getTextRange().getStartOffset() - elementStartOffset;
            String text = nameElement.getText();
            list.add((PsiReference)new AntAttributeReference(se, text, new TextRange(off, off + text.length()), null));
        }
        PsiReference[] psiReferenceArray2 = (count = list.size()) == 0 ? PsiReference.EMPTY_ARRAY : list.toArray(new PsiReference[count]);
        psiReferenceArray = psiReferenceArray2;
        if (psiReferenceArray2 != null) return psiReferenceArray;
        throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/reference/providers/AntAttributeReferenceProvider.getReferencesByElement must not return null");
        finally {
            PsiReferenceListSpinAllocator.dispose(list);
        }
    }
}

