/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.quickfix;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.misc.AntPsiUtil;
import com.intellij.lang.ant.psi.AntElement;
import com.intellij.lang.ant.psi.AntFile;
import com.intellij.lang.ant.psi.AntProject;
import com.intellij.lang.ant.psi.AntStructuredElement;
import com.intellij.lang.ant.psi.impl.reference.AntTargetReference;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.StringBuilderSpinAllocator;
import org.jetbrains.annotations.NotNull;

public class AntCreateTargetFix
extends BaseIntentionAction {
    private final AntTargetReference myRef;
    private final AntFile myFile;

    public AntCreateTargetFix(AntTargetReference ref) {
        this(ref, null);
    }

    public AntCreateTargetFix(AntTargetReference ref, AntFile file) {
        this.myRef = ref;
        this.myFile = file;
    }

    @NotNull
    public String getFamilyName() {
        String i18nName = AntBundle.message("intention.create.target.family.name", new Object[0]);
        String string = i18nName == null ? "Create target" : i18nName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/ant/quickfix/AntCreateTargetFix.getFamilyName must not return null");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String getText() {
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        builder.append(this.getFamilyName());
        builder.append(" '");
        builder.append(this.myRef.getCanonicalRepresentationText());
        builder.append('\'');
        if (this.myFile != null) {
            builder.append(' ');
            builder.append(AntBundle.message("text.in.the.file", this.myFile.getName()));
        }
        String string = builder.toString();
        String string2 = string;
        if (string2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/ant/quickfix/AntCreateTargetFix.getText must not return null");
        }
        return string2;
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/quickfix/AntCreateTargetFix.isAvailable must not be null");
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/quickfix/AntCreateTargetFix.invoke must not be null");
        }
        AntElement element = this.myRef.getElement();
        AntProject antProject = this.myFile == null ? element.getAntProject() : this.myFile.getAntProject();
        AntElement anchor = this.myFile == null ? AntPsiUtil.getSubProjectElement(element) : (AntElement)PsiTreeUtil.getChildOfType((PsiElement)antProject, AntStructuredElement.class);
        XmlTag projectTag = antProject.getSourceElement();
        XmlTag targetTag = projectTag.createChildTag("target", projectTag.getNamespace(), null, false);
        targetTag.setAttribute("name", this.myRef.getCanonicalRepresentationText());
        targetTag = (XmlTag)(anchor == null ? projectTag.add((PsiElement)targetTag) : projectTag.addBefore((PsiElement)targetTag, (PsiElement)anchor.getSourceElement()));
        ((Navigatable)targetTag).navigate(true);
    }
}

