/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.validation;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.psi.AntFile;
import com.intellij.lang.ant.psi.AntProject;
import com.intellij.lang.ant.psi.AntTarget;
import com.intellij.lang.ant.validation.AntInspection;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.HashMap;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntDuplicateImportedTargetsInspection
extends AntInspection {
    @NonNls
    private static final String SHORT_NAME = "AntDuplicateImportedTargetsInspection";

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = AntBundle.message("ant.duplicate.imported.targets.inspection", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/ant/validation/AntDuplicateImportedTargetsInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/ant/validation/AntDuplicateImportedTargetsInspection.getShortName must not return null");
        }
        return SHORT_NAME;
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        AntTarget[] targets;
        AntProject project;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/validation/AntDuplicateImportedTargetsInspection.checkFile must not be null");
        }
        if (manager == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/ant/validation/AntDuplicateImportedTargetsInspection.checkFile must not be null");
        }
        if (file instanceof AntFile && (project = ((AntFile)file).getAntProject()) != null && (targets = project.getTargets()).length > 0) {
            AntTarget[] importedTargets;
            HashMap<String, AntTarget> name2Target = new HashMap<String, AntTarget>();
            for (AntTarget target : targets) {
                name2Target.put(target.getName(), target);
            }
            ArrayList<ProblemDescriptor> problems = new ArrayList<ProblemDescriptor>();
            for (AntTarget target : importedTargets = project.getImportedTargets()) {
                String name = target.getName();
                AntTarget t = (AntTarget)name2Target.get(name);
                if (t == null) continue;
                String duplicatedMessage = AntBundle.message("target.is.duplicated.in.imported.file", name, target.getAntFile().getName());
                problems.add(manager.createProblemDescriptor((PsiElement)t, duplicatedMessage, isOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
            }
            int prolemCount = problems.size();
            if (prolemCount > 0) {
                return problems.toArray(new ProblemDescriptor[prolemCount]);
            }
        }
        return null;
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/ant/validation/AntDuplicateImportedTargetsInspection.getDefaultLevel must not return null");
        }
        return highlightDisplayLevel;
    }
}

