/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.log;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.lib.cvsclient.command.KeywordSubstitution;
import org.netbeans.lib.cvsclient.command.log.Revision;
import org.netbeans.lib.cvsclient.command.log.SymbolicName;

public final class LogInformation {
    private File file;
    private String rcsFileName;
    private String headRevision;
    private String branch;
    private String accessList;
    private KeywordSubstitution keywordSubstitution;
    private String totalRevisions;
    private String selectedRevisions;
    private String description;
    private String locks;
    private final List<Revision> revisions = new LinkedList<Revision>();
    private List<SymbolicName> symbolicNames;
    private StringBuffer symNamesBuffer;

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getRcsFileName() {
        return this.rcsFileName;
    }

    public void setRcsFileName(String rcsFileName) {
        this.rcsFileName = rcsFileName;
    }

    public String getHeadRevision() {
        return this.headRevision;
    }

    public void setHeadRevision(String headRevision) {
        this.headRevision = headRevision;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public String getAccessList() {
        return this.accessList;
    }

    public void setAccessList(String accessList) {
        this.accessList = accessList;
    }

    public KeywordSubstitution getKeywordSubstitution() {
        return this.keywordSubstitution;
    }

    public void setKeywordSubstitution(KeywordSubstitution keywordSubstitution) {
        this.keywordSubstitution = keywordSubstitution;
    }

    public String getTotalRevisions() {
        return this.totalRevisions;
    }

    public void setTotalRevisions(String totalRevisions) {
        this.totalRevisions = totalRevisions;
    }

    public String getSelectedRevisions() {
        return this.selectedRevisions;
    }

    public void setSelectedRevisions(String selectedRevisions) {
        this.selectedRevisions = selectedRevisions;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLocks() {
        return this.locks;
    }

    public void setLocks(String locks) {
        this.locks = locks;
    }

    public void addRevision(Revision newRevision) {
        this.revisions.add(newRevision);
    }

    public List<Revision> getRevisionList() {
        return this.revisions;
    }

    public Revision getRevision(String number) {
        for (Revision item : this.revisions) {
            if (!item.getNumber().equals(number)) continue;
            return item;
        }
        return null;
    }

    public void addSymbolicName(String symName, String revisionNumber) {
        if (this.symNamesBuffer == null) {
            this.symNamesBuffer = new StringBuffer();
        }
        this.symNamesBuffer.append(symName);
        this.symNamesBuffer.append(' ');
        this.symNamesBuffer.append(revisionNumber);
        this.symNamesBuffer.append('\n');
    }

    private void createSymNames() {
        this.symbolicNames = new LinkedList<SymbolicName>();
        if (this.symNamesBuffer == null) {
            return;
        }
        int length = 0;
        int lastLength = 0;
        while (length < this.symNamesBuffer.length()) {
            while (length < this.symNamesBuffer.length() && this.symNamesBuffer.charAt(length) != '\n') {
                ++length;
            }
            if (length <= lastLength) continue;
            String line = this.symNamesBuffer.substring(lastLength, length);
            String symName = line.substring(0, line.indexOf(32));
            String revisionNumber = line.substring(line.indexOf(32) + 1);
            SymbolicName newName = new SymbolicName();
            newName.setName(symName);
            newName.setRevision(revisionNumber);
            this.symbolicNames.add(newName);
            lastLength = length + 1;
            ++length;
        }
        this.symNamesBuffer = null;
    }

    public List<SymbolicName> getAllSymbolicNames() {
        if (this.symbolicNames == null) {
            this.createSymNames();
        }
        return this.symbolicNames;
    }

    public List<SymbolicName> getSymNamesForRevision(String revNumber) {
        if (this.symbolicNames == null) {
            this.createSymNames();
        }
        Iterator<SymbolicName> it = this.symbolicNames.iterator();
        LinkedList<SymbolicName> list = new LinkedList<SymbolicName>();
        while (it.hasNext()) {
            SymbolicName item = it.next();
            if (!item.getRevision().equals(revNumber)) continue;
            list.add(item);
        }
        return list;
    }

    public SymbolicName getSymName(String symName) {
        if (this.symbolicNames == null) {
            this.createSymNames();
        }
        for (SymbolicName item : this.symbolicNames) {
            if (!item.getName().equals(symName)) continue;
            return item;
        }
        return null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(30);
        buf.append("\nFile: " + (this.file != null ? this.file.getAbsolutePath() : "null"));
        buf.append("\nRepositoryFile: " + this.rcsFileName);
        buf.append("\nHead revision: " + this.headRevision);
        return buf.toString();
    }
}

