/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MavenDependencySystemPathConverter
extends ResolvingConverter<PsiFile>
implements CustomReferenceConverter {
    public PsiFile fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        VirtualFile f = LocalFileSystem.getInstance().findFileByPath(s);
        if (f == null) {
            return null;
        }
        return PsiManager.getInstance((Project)context.getXmlElement().getProject()).findFile(f);
    }

    public String toString(@Nullable PsiFile file, ConvertContext context) {
        if (file == null) {
            return null;
        }
        return file.getVirtualFile().getPath();
    }

    @NotNull
    public Collection<PsiFile> getVariants(ConvertContext context) {
        List<PsiFile> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/dom/converters/MavenDependencySystemPathConverter.getVariants must not return null");
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiReference[] createReferences(GenericDomValue genericDomValue, PsiElement element, ConvertContext context) {
        PsiReference[] psiReferenceArray;
        XmlElement xmlElement = genericDomValue.getXmlElement();
        if (xmlElement != null && xmlElement.getText().contains("${")) {
            psiReferenceArray = PsiReference.EMPTY_ARRAY;
            if (PsiReference.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/dom/converters/MavenDependencySystemPathConverter.createReferences must not return null");
            return psiReferenceArray;
        }
        psiReferenceArray = MavenDependencySystemPathConverter.createReferences(element, true);
        if (psiReferenceArray != null) return psiReferenceArray;
        throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/dom/converters/MavenDependencySystemPathConverter.createReferences must not return null");
    }

    @NotNull
    public static PsiReference[] createReferences(@NotNull PsiElement psiElement, boolean soft) {
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/converters/MavenDependencySystemPathConverter.createReferences must not be null");
        }
        MyFileReferenceSet set = new MyFileReferenceSet(psiElement, soft);
        FileReference[] fileReferenceArray = set.getAllReferences();
        if (fileReferenceArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/dom/converters/MavenDependencySystemPathConverter.createReferences must not return null");
        }
        return fileReferenceArray;
    }

    private static class MyFileReferenceSet
    extends FileReferenceSet {
        private final boolean mySoft;

        public MyFileReferenceSet(PsiElement psiElement, boolean soft) {
            super(psiElement);
            this.mySoft = soft;
        }

        public boolean isAbsolutePathReference() {
            return true;
        }

        protected boolean isSoft() {
            return this.mySoft;
        }

        @NotNull
        public Collection<PsiFileSystemItem> getDefaultContexts() {
            PsiDirectory directory;
            Object vFile;
            Collection systemItemCollection = super.getDefaultContexts();
            if (this.isAbsolutePathReference() && (vFile = SystemInfo.isWindows ? ManagingFS.getInstance().findRoot("", (NewVirtualFileSystem)LocalFileSystem.getInstance()) : LocalFileSystem.getInstance().findFileByPath("/")) != null && (directory = this.getElement().getManager().findDirectory(vFile)) != null) {
                systemItemCollection.add(directory);
            }
            Collection collection = systemItemCollection;
            if (collection == null) {
                throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/dom/converters/MavenDependencySystemPathConverter$MyFileReferenceSet.getDefaultContexts must not return null");
            }
            return collection;
        }
    }
}

