/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.generate;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.xml.ui.actions.generate.GenerateDomElementAction;
import com.intellij.util.xml.ui.actions.generate.GenerateDomElementProvider;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.MavenDomProjectProcessorUtils;
import org.jetbrains.idea.maven.dom.generate.GenerateDependencyUtil;
import org.jetbrains.idea.maven.dom.generate.MavenGenerateProvider;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencies;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.project.MavenId;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenIcons;

public class GenerateAddManagedDependencyAction
extends GenerateDomElementAction {
    public GenerateAddManagedDependencyAction() {
        super((GenerateDomElementProvider)new MavenOverridingDependencyGenerateProvider(), MavenIcons.DEPENDENCY_ICON);
    }

    protected boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public static Set<MavenDomDependency> collectManagingDependencies(final @NotNull MavenDomProjectModel model) {
        if (model == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/generate/GenerateAddManagedDependencyAction.collectManagingDependencies must not be null");
        }
        HashSet dependencies = new HashSet();
        final List<MavenDomDependency> existingDependencies = model.getDependencies().getDependencies();
        Processor<MavenDomDependencies> collectProcessor = new Processor<MavenDomDependencies>((Set)dependencies){
            final /* synthetic */ Set val$dependencies;
            {
                this.val$dependencies = set;
            }

            public boolean process(MavenDomDependencies mavenDomDependencies) {
                if (!model.equals(mavenDomDependencies.getParentOfType(MavenDomProjectModel.class, true))) {
                    for (MavenDomDependency dependency : mavenDomDependencies.getDependencies()) {
                        String groupId = dependency.getGroupId().getStringValue();
                        String artifactId = dependency.getArtifactId().getStringValue();
                        if (StringUtil.isEmptyOrSpaces((String)groupId) || StringUtil.isEmptyOrSpaces((String)artifactId) || GenerateAddManagedDependencyAction.isDependencyExist(groupId, artifactId, existingDependencies)) continue;
                        this.val$dependencies.add(dependency);
                    }
                }
                return false;
            }
        };
        MavenDomProjectProcessorUtils.processDependenciesInDependencyManagement(model, collectProcessor, model.getManager().getProject());
        HashSet hashSet = dependencies;
        if (hashSet == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/dom/generate/GenerateAddManagedDependencyAction.collectManagingDependencies must not return null");
        }
        return hashSet;
    }

    private static boolean isDependencyExist(String groupId, String artifactId, List<MavenDomDependency> existingDependencies) {
        for (MavenDomDependency existingDependency : existingDependencies) {
            if (!groupId.equals(existingDependency.getGroupId().getStringValue()) && !artifactId.equals(existingDependency.getArtifactId().getStringValue())) continue;
            return true;
        }
        return false;
    }

    private static class MavenOverridingDependencyGenerateProvider
    extends MavenGenerateProvider<MavenDomDependency> {
        public MavenOverridingDependencyGenerateProvider() {
            super(MavenDomBundle.message("generate.managed.dependency", new Object[0]), MavenDomDependency.class);
        }

        @Override
        protected MavenDomDependency doGenerate(MavenDomProjectModel mavenModel, Editor editor) {
            Set<MavenDomDependency> managingDependencies = GenerateAddManagedDependencyAction.collectManagingDependencies(mavenModel);
            List<MavenDomDependency> dependenciesToOverride = GenerateDependencyUtil.chooseDependencies(managingDependencies, mavenModel.getManager().getProject());
            for (MavenDomDependency parentDependency : dependenciesToOverride) {
                String groupId = parentDependency.getGroupId().getStringValue();
                String artifactId = parentDependency.getArtifactId().getStringValue();
                if (StringUtil.isEmptyOrSpaces((String)groupId) || StringUtil.isEmptyOrSpaces((String)artifactId)) continue;
                MavenId id = new MavenId(groupId, artifactId, parentDependency.getVersion().getStringValue());
                MavenProjectsManager manager = MavenProjectsManager.getInstance(editor.getProject());
                MavenDomDependency dependency = manager.addOverridenDependency(manager.findProject(mavenModel.getModule()), id);
                dependency.getVersion().undefine();
            }
            return null;
        }
    }
}

