/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.navigator;

import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiManager;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.CachingSimpleNode;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleNodeVisitor;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.SimpleTreeBuilder;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.awt.Color;
import java.awt.event.InputEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.embedder.MavenEmbedderFactory;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.navigator.MavenProjectsNavigator;
import org.jetbrains.idea.maven.project.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenArtifactNode;
import org.jetbrains.idea.maven.project.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProfileState;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectProblem;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.ProjectBundle;
import org.jetbrains.idea.maven.tasks.MavenShortcutsManager;
import org.jetbrains.idea.maven.tasks.MavenTasksManager;
import org.jetbrains.idea.maven.utils.MavenArtifactUtil;
import org.jetbrains.idea.maven.utils.MavenIcons;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenPluginInfo;
import org.jetbrains.idea.maven.utils.MavenUIUtil;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenProjectsStructure
extends SimpleTreeStructure {
    private static final URL ERROR_ICON_URL = MavenProjectsStructure.class.getResource("/images/error.png");
    private static final Collection<String> BASIC_PHASES = MavenEmbedderFactory.getBasicPhasesList();
    private static final Collection<String> PHASES = MavenEmbedderFactory.getPhasesList();
    private static final Comparator<MavenSimpleNode> NODE_COMPARATOR = new Comparator<MavenSimpleNode>(){

        @Override
        public int compare(MavenSimpleNode o1, MavenSimpleNode o2) {
            return Comparing.compare((Comparable)((Object)o1.getName()), (Comparable)((Object)o2.getName()));
        }
    };
    private final Project myProject;
    private final MavenProjectsManager myProjectsManager;
    private final MavenTasksManager myTasksManager;
    private final MavenShortcutsManager myShortcutsManager;
    private final MavenProjectsNavigator myProjectsNavigator;
    private final SimpleTreeBuilder myTreeBuilder;
    private final RootNode myRoot = new RootNode();
    private final Map<MavenProject, ProjectNode> myProjectToNodeMapping = new THashMap();

    public MavenProjectsStructure(Project project, MavenProjectsManager projectsManager, MavenTasksManager tasksManager, MavenShortcutsManager shortcutsManager, MavenProjectsNavigator projectsNavigator, SimpleTree tree) {
        this.myProject = project;
        this.myProjectsManager = projectsManager;
        this.myTasksManager = tasksManager;
        this.myShortcutsManager = shortcutsManager;
        this.myProjectsNavigator = projectsNavigator;
        this.configureTree(tree);
        this.myTreeBuilder = new SimpleTreeBuilder((JTree)tree, (DefaultTreeModel)tree.getModel(), (AbstractTreeStructure)this, null);
        Disposer.register((Disposable)this.myProject, (Disposable)this.myTreeBuilder);
        this.myTreeBuilder.initRoot();
        this.myTreeBuilder.expand((Object)this.myRoot, null);
    }

    private void configureTree(final SimpleTree tree) {
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        MavenUIUtil.installCheckboxRenderer(tree, new MavenUIUtil.CheckboxHandler(){

            @Override
            public void toggle(TreePath treePath, InputEvent e) {
                SimpleNode node = tree.getNodeFor(treePath);
                if (node != null) {
                    node.handleDoubleClickOrEnter(tree, e);
                }
            }

            @Override
            public boolean isVisible(Object userObject) {
                return userObject instanceof ProfileNode;
            }

            @Override
            public MavenUIUtil.CheckBoxState getState(Object userObject) {
                MavenProfileState state = ((ProfileNode)((Object)userObject)).getState();
                switch (state) {
                    case NONE: {
                        return MavenUIUtil.CheckBoxState.UNCHECKED;
                    }
                    case EXPLICIT: {
                        return MavenUIUtil.CheckBoxState.CHECKED;
                    }
                    case IMPLICIT: {
                        return MavenUIUtil.CheckBoxState.PARTIAL;
                    }
                }
                MavenLog.LOG.error("unknown profile state: " + (Object)((Object)state));
                return MavenUIUtil.CheckBoxState.UNCHECKED;
            }
        });
    }

    public RootNode getRootElement() {
        return this.myRoot;
    }

    public void update() {
        List<MavenProject> projects = this.myProjectsManager.getProjects();
        ArrayList<MavenProject> deleted = new ArrayList<MavenProject>(this.myProjectToNodeMapping.keySet());
        deleted.removeAll(projects);
        this.updateProjects(projects, deleted);
    }

    private void updateFrom(SimpleNode node) {
        this.myTreeBuilder.addSubtreeToUpdateByElement((Object)node);
    }

    private void updateUpTo(SimpleNode node) {
        for (SimpleNode each = node; each != null; each = each.getParent()) {
            this.updateFrom(each);
        }
    }

    public void updateProjects(List<MavenProject> updated, List<MavenProject> deleted) {
        ProjectNode node;
        for (MavenProject each : updated) {
            node = this.findNodeFor(each);
            if (node == null) {
                node = new ProjectNode(each);
                this.myProjectToNodeMapping.put(each, node);
            }
            this.doUpdateProject(node);
        }
        for (MavenProject each : deleted) {
            node = this.myProjectToNodeMapping.remove(each);
            if (node == null) continue;
            ProjectsGroupNode parent = node.getGroup();
            parent.remove(node);
        }
        this.myRoot.updateProfiles();
    }

    private void doUpdateProject(ProjectNode node) {
        ProjectNode aggregatorNode;
        MavenProject aggregator;
        MavenProject project = node.getMavenProject();
        ProjectsGroupNode newParentNode = this.myRoot;
        if (this.myProjectsNavigator.getGroupModules() && (aggregator = this.myProjectsManager.findAggregator(project)) != null && (aggregatorNode = this.findNodeFor(aggregator)) != null && aggregatorNode.isVisible()) {
            newParentNode = aggregatorNode.getModulesNode();
        }
        node.updateProject();
        this.reconnectNode(node, newParentNode);
        RootNode newModulesParentNode = this.myProjectsNavigator.getGroupModules() && node.isVisible() ? node.getModulesNode() : this.myRoot;
        for (MavenProject each : this.myProjectsManager.getModules(project)) {
            ProjectNode moduleNode = this.findNodeFor(each);
            if (moduleNode == null || moduleNode.getParent().equals((Object)newModulesParentNode)) continue;
            this.reconnectNode(moduleNode, newModulesParentNode);
        }
    }

    private void reconnectNode(ProjectNode node, ProjectsGroupNode newParentNode) {
        ProjectsGroupNode oldParentNode = node.getGroup();
        if (oldParentNode == null || !oldParentNode.equals((Object)newParentNode)) {
            if (oldParentNode != null) {
                oldParentNode.remove(node);
            }
            newParentNode.add(node);
        } else {
            newParentNode.sortProjects();
        }
    }

    public void updateProfiles() {
        this.myRoot.updateProfiles();
    }

    public void updateIgnored(List<MavenProject> projects) {
        for (MavenProject each : projects) {
            ProjectNode node = this.findNodeFor(each);
            if (node == null) continue;
            node.updateIgnored();
        }
    }

    public void accept(SimpleNodeVisitor visitor) {
        ((SimpleTree)this.myTreeBuilder.getTree()).accept((AbstractTreeBuilder)this.myTreeBuilder, visitor);
    }

    public void updateGoals() {
        for (ProjectNode each : this.myProjectToNodeMapping.values()) {
            each.updateGoals();
        }
    }

    public void select(MavenProject project) {
        ProjectNode node = this.findNodeFor(project);
        if (node != null) {
            this.select((SimpleNode)node);
        }
    }

    public void select(SimpleNode node) {
        this.myTreeBuilder.select((Object)node, null);
    }

    private ProjectNode findNodeFor(MavenProject project) {
        return this.myProjectToNodeMapping.get(project);
    }

    protected Class<? extends MavenSimpleNode>[] getVisibleNodesClasses() {
        return null;
    }

    protected boolean showDescriptions() {
        return true;
    }

    protected boolean showOnlyBasicPhases() {
        return this.myProjectsNavigator.getShowBasicPhasesOnly();
    }

    public static <T extends MavenSimpleNode> List<T> getSelectedNodes(SimpleTree tree, Class<T> nodeClass) {
        ArrayList<MavenSimpleNode> filtered = new ArrayList<MavenSimpleNode>();
        for (SimpleNode node : MavenProjectsStructure.getSelectedNodes(tree)) {
            if (nodeClass != null && !nodeClass.isInstance(node)) {
                filtered.clear();
                break;
            }
            filtered.add((MavenSimpleNode)node);
        }
        return filtered;
    }

    private static List<SimpleNode> getSelectedNodes(SimpleTree tree) {
        ArrayList<SimpleNode> nodes = new ArrayList<SimpleNode>();
        TreePath[] treePaths = tree.getSelectionPaths();
        if (treePaths != null) {
            for (TreePath treePath : treePaths) {
                nodes.add(tree.getNodeFor(treePath));
            }
        }
        return nodes;
    }

    @Nullable
    public static ProjectNode getCommonProjectNode(Collection<? extends MavenSimpleNode> nodes) {
        ProjectNode parent = null;
        for (MavenSimpleNode mavenSimpleNode : nodes) {
            ProjectNode nextParent = mavenSimpleNode.findParent(ProjectNode.class);
            if (parent == null) {
                parent = nextParent;
                continue;
            }
            if (parent == nextParent) continue;
            return null;
        }
        return parent;
    }

    public class DependencyNode
    extends BaseDependenciesNode {
        private final MavenArtifact myArtifact;

        public DependencyNode(MavenSimpleNode parent, MavenArtifactNode artifactNode, MavenProject mavenProject) {
            super(parent, mavenProject);
            this.myArtifact = artifactNode.getArtifact();
            this.setUniformIcon(MavenIcons.DEPENDENCY_ICON);
        }

        public MavenArtifact getArtifact() {
            return this.myArtifact;
        }

        public String getName() {
            return this.myArtifact.getDisplayStringForLibraryName();
        }

        @Override
        protected void doUpdate() {
            String scope = this.myArtifact.getScope();
            this.setNameAndTooltip(this.getName(), null, "compile".equals(scope) ? null : scope);
        }

        private void updateDependency() {
            this.setErrorLevel(this.myArtifact.isResolved() ? ErrorLevel.NONE : ErrorLevel.ERROR);
        }

        @Override
        public Navigatable getNavigatable() {
            final Module m = MavenProjectsStructure.this.myProjectsManager.findModule(this.myMavenProject);
            if (m == null) {
                return null;
            }
            final OrderEntry e = MavenRootModelAdapter.findLibraryEntry(m, this.myArtifact);
            if (e == null) {
                return null;
            }
            return new Navigatable(){

                public void navigate(boolean requestFocus) {
                    ProjectSettingsService.getInstance((Project)DependencyNode.this.myProject).openProjectLibrarySettings(new NamedLibraryElement(m, e));
                }

                public boolean canNavigate() {
                    return true;
                }

                public boolean canNavigateToSource() {
                    return false;
                }
            };
        }

        @Override
        public boolean isVisible() {
            return this.getDisplayKind() != DisplayKind.NEVER;
        }
    }

    public class DependenciesNode
    extends BaseDependenciesNode {
        public DependenciesNode(ProjectNode parent, MavenProject mavenProject) {
            super(parent, mavenProject);
            this.setIcons(MavenIcons.CLOSED_DEPENDENCIES_ICON, MavenIcons.OPEN_DEPENDENCIES_ICON);
        }

        public String getName() {
            return ProjectBundle.message("view.node.dependencies", new Object[0]);
        }

        public void updateDependencies() {
            this.updateChildren(this.myMavenProject.getDependenciesNodes(), this.myMavenProject);
        }
    }

    public abstract class BaseDependenciesNode
    extends GroupNode {
        protected final MavenProject myMavenProject;
        private List<DependencyNode> myChildren;

        protected BaseDependenciesNode(MavenSimpleNode parent, MavenProject mavenProject) {
            super(parent);
            this.myChildren = new ArrayList<DependencyNode>();
            this.myMavenProject = mavenProject;
        }

        public MavenProject getMavenProject() {
            return this.myMavenProject;
        }

        @Override
        protected List<? extends MavenSimpleNode> doGetChildren() {
            return this.myChildren;
        }

        protected void updateChildren(List<MavenArtifactNode> children, MavenProject mavenProject) {
            ArrayList<DependencyNode> newNodes = new ArrayList<DependencyNode>(children.size());
            for (MavenArtifactNode each : children) {
                DependencyNode newNode = this.findOrCreateNodeFor(each, mavenProject);
                newNodes.add(newNode);
                newNode.updateChildren(each.getDependencies(), mavenProject);
                newNode.updateDependency();
            }
            this.myChildren = newNodes;
            this.childrenChanged();
        }

        private DependencyNode findOrCreateNodeFor(MavenArtifactNode artifact, MavenProject mavenProject) {
            for (DependencyNode each : this.myChildren) {
                if (!each.myArtifact.equals(artifact.getArtifact())) continue;
                return each;
            }
            return new DependencyNode(this, artifact, mavenProject);
        }

        @Override
        String getMenuId() {
            return "Maven.DependencyMenu";
        }
    }

    public class PluginGoalNode
    extends GoalNode {
        public PluginGoalNode(PluginNode parent, String goal, String displayName) {
            super(parent, goal, displayName);
            this.setUniformIcon(MavenIcons.PLUGIN_GOAL_ICON);
        }
    }

    public class PluginNode
    extends GoalsGroupNode {
        private final MavenPlugin myPlugin;
        private MavenPluginInfo myPluginInfo;

        public PluginNode(PluginsNode parent, MavenPlugin plugin) {
            super(parent);
            this.myPlugin = plugin;
            this.setUniformIcon(MavenIcons.PLUGIN_ICON);
            this.updatePlugin();
        }

        public MavenPlugin getPlugin() {
            return this.myPlugin;
        }

        public String getName() {
            return this.myPluginInfo == null ? this.myPlugin.getDisplayString() : this.myPluginInfo.getGoalPrefix();
        }

        @Override
        protected void doUpdate() {
            this.setNameAndTooltip(this.getName(), null, this.myPluginInfo != null ? this.myPlugin.getDisplayString() : null);
        }

        public void updatePlugin() {
            boolean hadPluginInfo = this.myPluginInfo != null;
            this.myPluginInfo = MavenArtifactUtil.readPluginInfo(MavenProjectsStructure.this.myProjectsManager.getLocalRepository(), this.myPlugin.getMavenId());
            boolean hasPluginInfo = this.myPluginInfo != null;
            this.setErrorLevel(this.myPluginInfo == null ? ErrorLevel.ERROR : ErrorLevel.NONE);
            if (hadPluginInfo == hasPluginInfo) {
                return;
            }
            this.myGoalNodes.clear();
            if (this.myPluginInfo != null) {
                for (MavenPluginInfo.Mojo mojo : this.myPluginInfo.getMojos()) {
                    this.myGoalNodes.add(new PluginGoalNode(this, mojo.getQualifiedGoal(), mojo.getDisplayName()));
                }
            }
            MavenProjectsStructure.this.updateFrom((SimpleNode)this);
            this.childrenChanged();
        }

        @Override
        public boolean isVisible() {
            return super.isVisible() || this.getDisplayKind() != DisplayKind.NEVER;
        }
    }

    public class PluginsNode
    extends GroupNode {
        private final List<PluginNode> myPluginNodes;

        public PluginsNode(ProjectNode parent) {
            super(parent);
            this.myPluginNodes = new ArrayList<PluginNode>();
            this.setIcons(MavenIcons.CLOSED_PLUGINS_ICON, MavenIcons.OPEN_PLUGINS_ICON);
        }

        public String getName() {
            return ProjectBundle.message("view.node.plugins", new Object[0]);
        }

        @Override
        protected List<? extends MavenSimpleNode> doGetChildren() {
            return this.myPluginNodes;
        }

        public void updatePlugins(MavenProject mavenProject) {
            List<MavenPlugin> plugins = mavenProject.getDeclaredPlugins();
            for (PluginNode pluginNode : new ArrayList<PluginNode>(this.myPluginNodes)) {
                if (plugins.contains(pluginNode.getPlugin())) {
                    pluginNode.updatePlugin();
                    continue;
                }
                this.myPluginNodes.remove((Object)pluginNode);
            }
            for (MavenPlugin mavenPlugin : plugins) {
                if (this.hasNodeFor(mavenPlugin)) continue;
                this.myPluginNodes.add(new PluginNode(this, mavenPlugin));
            }
            this.sort(this.myPluginNodes);
            this.childrenChanged();
        }

        private boolean hasNodeFor(MavenPlugin plugin) {
            for (PluginNode each : this.myPluginNodes) {
                if (!each.getPlugin().getMavenId().equals(plugin.getMavenId())) continue;
                return true;
            }
            return false;
        }
    }

    public class StandardGoalNode
    extends GoalNode {
        public StandardGoalNode(GoalsGroupNode parent, String goal) {
            super(parent, goal, goal);
        }

        @Override
        public boolean isVisible() {
            if (MavenProjectsStructure.this.showOnlyBasicPhases() && !BASIC_PHASES.contains(this.getGoal())) {
                return false;
            }
            return super.isVisible();
        }
    }

    public class LifecycleNode
    extends GoalsGroupNode {
        public LifecycleNode(ProjectNode parent) {
            super(parent);
            for (String goal : PHASES) {
                this.myGoalNodes.add(new StandardGoalNode(this, goal));
            }
            this.setIcons(MavenIcons.CLOSED_PHASES_ICON, MavenIcons.OPEN_PHASES_ICON);
        }

        public String getName() {
            return ProjectBundle.message("view.node.lifecycle", new Object[0]);
        }

        public void updateGoalsList() {
            this.childrenChanged();
        }
    }

    public abstract class GoalNode
    extends MavenSimpleNode {
        private final MavenProject myMavenProject;
        private final String myGoal;
        private final String myDisplayName;

        public GoalNode(GoalsGroupNode parent, String goal, String displayName) {
            super(parent);
            this.myMavenProject = this.findParent(ProjectNode.class).getMavenProject();
            this.myGoal = goal;
            this.myDisplayName = displayName;
            this.setUniformIcon(MavenIcons.PHASE_ICON);
        }

        public String getProjectPath() {
            return this.myMavenProject.getPath();
        }

        public String getGoal() {
            return this.myGoal;
        }

        public String getName() {
            return this.myDisplayName;
        }

        @Override
        protected void doUpdate() {
            String hint = StringUtil.join(Arrays.asList(MavenProjectsStructure.this.myShortcutsManager.getDescription(this.myMavenProject, this.myGoal), MavenProjectsStructure.this.myTasksManager.getDescription(this.myMavenProject, this.myGoal)), (String)", ");
            this.setNameAndTooltip(this.getName(), null, hint);
        }

        protected SimpleTextAttributes getPlainAttributes() {
            if (this.myGoal.equals(this.myMavenProject.getDefaultGoal())) {
                return new SimpleTextAttributes(1, this.getColor());
            }
            return super.getPlainAttributes();
        }

        @Override
        @Nullable
        @NonNls
        protected String getActionId() {
            return "Maven.RunBuild";
        }

        @Override
        @Nullable
        @NonNls
        protected String getMenuId() {
            return "Maven.BuildMenu";
        }
    }

    public abstract class GoalsGroupNode
    extends GroupNode {
        protected final List<GoalNode> myGoalNodes;

        public GoalsGroupNode(MavenSimpleNode parent) {
            super(parent);
            this.myGoalNodes = new ArrayList<GoalNode>();
        }

        @Override
        protected List<? extends MavenSimpleNode> doGetChildren() {
            return this.myGoalNodes;
        }
    }

    public class ModulesNode
    extends ProjectsGroupNode {
        public ModulesNode(ProjectNode parent) {
            super(parent);
            this.setIcons(MavenIcons.CLOSED_MODULES_ICON, MavenIcons.OPEN_MODULES_ICON);
        }

        public String getName() {
            return ProjectBundle.message("view.node.modules", new Object[0]);
        }
    }

    public class ProjectNode
    extends GroupNode {
        private final MavenProject myMavenProject;
        private final LifecycleNode myLifecycleNode;
        private final PluginsNode myPluginsNode;
        private final DependenciesNode myDependenciesNode;
        private final ModulesNode myModulesNode;
        private String myTooltipCache;

        public ProjectNode(MavenProject mavenProject) {
            super(null);
            this.myMavenProject = mavenProject;
            this.myLifecycleNode = new LifecycleNode(this);
            this.myPluginsNode = new PluginsNode(this);
            this.myDependenciesNode = new DependenciesNode(this, mavenProject);
            this.myModulesNode = new ModulesNode(this);
            this.setUniformIcon(MavenIcons.MAVEN_PROJECT_ICON);
            this.updateProject();
        }

        public MavenProject getMavenProject() {
            return this.myMavenProject;
        }

        public ProjectsGroupNode getGroup() {
            return (ProjectsGroupNode)super.getParent();
        }

        @Override
        public boolean isVisible() {
            if (!MavenProjectsStructure.this.myProjectsNavigator.getShowIgnored() && MavenProjectsStructure.this.myProjectsManager.isIgnored(this.myMavenProject)) {
                return false;
            }
            return super.isVisible();
        }

        @Override
        protected List<? extends MavenSimpleNode> doGetChildren() {
            return Arrays.asList(new GroupNode[]{this.myLifecycleNode, this.myPluginsNode, this.myDependenciesNode, this.myModulesNode});
        }

        public ModulesNode getModulesNode() {
            return this.myModulesNode;
        }

        private void updateProject() {
            this.setErrorLevel(this.myMavenProject.getProblems().isEmpty() ? ErrorLevel.NONE : ErrorLevel.ERROR);
            this.myLifecycleNode.updateGoalsList();
            this.myPluginsNode.updatePlugins(this.myMavenProject);
            this.myDependenciesNode.updateDependencies();
            this.myTooltipCache = this.makeDescription();
            MavenProjectsStructure.this.updateFrom(this.getParent());
        }

        public void updateIgnored() {
            this.getGroup().childrenChanged();
        }

        public void updateGoals() {
            MavenProjectsStructure.this.updateFrom((SimpleNode)this.myLifecycleNode);
            MavenProjectsStructure.this.updateFrom((SimpleNode)this.myPluginsNode);
        }

        public String getName() {
            return this.myMavenProject.getDisplayName();
        }

        @Override
        protected void doUpdate() {
            this.setNameAndTooltip(this.getName(), this.myTooltipCache);
        }

        protected SimpleTextAttributes getPlainAttributes() {
            if (MavenProjectsStructure.this.myProjectsManager.isIgnored(this.myMavenProject)) {
                return new SimpleTextAttributes(0, Color.GRAY);
            }
            return super.getPlainAttributes();
        }

        private String makeDescription() {
            StringBuilder desc = new StringBuilder();
            desc.append("<html>");
            desc.append("<table>");
            desc.append("<tr>");
            desc.append("<td>");
            desc.append("  <table>");
            desc.append("  <tr>");
            desc.append("  <td>Project:</td>");
            desc.append("  <td nowrap>" + this.myMavenProject.getMavenId() + "</td>");
            desc.append("  </tr>");
            desc.append("  <tr>");
            desc.append("  <td>Location:</td>");
            desc.append("  <td nowrap>" + this.myMavenProject.getPath() + "</td>");
            desc.append("  </tr>");
            desc.append("  </table>");
            desc.append("</td>");
            desc.append("</tr>");
            this.appendProblems(desc);
            desc.append("</table>");
            desc.append("</html>");
            return desc.toString();
        }

        private void appendProblems(StringBuilder desc) {
            List<MavenProjectProblem> problems = this.myMavenProject.getProblems();
            if (problems.isEmpty()) {
                return;
            }
            desc.append("<tr>");
            desc.append("<td>");
            desc.append("<table>");
            boolean first = true;
            for (MavenProjectProblem each : problems) {
                desc.append("<tr>");
                if (first) {
                    desc.append("<td valign=top>" + MavenUtil.formatHtmlImage(ERROR_ICON_URL) + "</td>");
                    desc.append("<td valign=top>Problems:</td>");
                    first = false;
                } else {
                    desc.append("<td colspan=2></td>");
                }
                desc.append("<td valign=top>" + this.wrappedText(each));
                desc.append("</tr>");
            }
            desc.append("</table>");
            desc.append("</td>");
            desc.append("</tr>");
        }

        private String wrappedText(MavenProjectProblem each) {
            String text = StringUtil.replace((String)each.getDescription(), (String[])new String[]{"<", ">"}, (String[])new String[]{"&lt;", "&gt;"});
            StringBuffer result = new StringBuffer();
            int count = 0;
            for (int i = 0; i < text.length(); ++i) {
                char ch = text.charAt(i);
                result.append(ch);
                if (count++ <= 80 || ch != ' ') continue;
                count = 0;
                result.append("<br>");
            }
            return result.toString();
        }

        @Override
        public VirtualFile getVirtualFile() {
            return this.myMavenProject.getFile();
        }

        @Override
        @Nullable
        @NonNls
        protected String getMenuId() {
            return "Maven.NavigatorProjectMenu";
        }
    }

    public class ProfileNode
    extends MavenSimpleNode {
        private final String myProfileName;
        private MavenProfileState myState;

        public ProfileNode(ProfilesNode parent, String profileName) {
            super(parent);
            this.myProfileName = profileName;
        }

        public String getName() {
            return this.myProfileName;
        }

        public String getProfileName() {
            return this.myProfileName;
        }

        public MavenProfileState getState() {
            return this.myState;
        }

        private void setState(MavenProfileState state) {
            this.myState = state;
        }

        @Override
        @Nullable
        @NonNls
        protected String getActionId() {
            return "Maven.ToggleProfile";
        }
    }

    public class ProfilesNode
    extends GroupNode {
        private List<ProfileNode> myProfileNodes;

        public ProfilesNode(MavenSimpleNode parent) {
            super(parent);
            this.myProfileNodes = new ArrayList<ProfileNode>();
            this.setIcons(MavenIcons.CLOSED_PROFILES_ICON, MavenIcons.OPEN_PROFILES_ICON);
        }

        @Override
        protected List<? extends MavenSimpleNode> doGetChildren() {
            return this.myProfileNodes;
        }

        public String getName() {
            return ProjectBundle.message("view.node.profiles", new Object[0]);
        }

        public void updateProfiles() {
            Collection<Pair<String, MavenProfileState>> profiles = MavenProjectsStructure.this.myProjectsManager.getProfilesWithStates();
            ArrayList<ProfileNode> newNodes = new ArrayList<ProfileNode>(profiles.size());
            for (Pair<String, MavenProfileState> each : profiles) {
                ProfileNode node = this.findOrCreateNodeFor((String)each.first);
                node.setState((MavenProfileState)((Object)each.second));
                newNodes.add(node);
            }
            this.myProfileNodes = newNodes;
            this.sort(this.myProfileNodes);
            this.childrenChanged();
        }

        private ProfileNode findOrCreateNodeFor(String profileName) {
            for (ProfileNode each : this.myProfileNodes) {
                if (!each.getProfileName().equals(profileName)) continue;
                return each;
            }
            return new ProfileNode(this, profileName);
        }
    }

    public class RootNode
    extends ProjectsGroupNode {
        private ProfilesNode myProfilesNode;

        public RootNode() {
            super(null);
            this.myProfilesNode = new ProfilesNode(this);
        }

        @Override
        public boolean isVisible() {
            return true;
        }

        @Override
        protected List<? extends MavenSimpleNode> doGetChildren() {
            return ContainerUtil.concat(Collections.singletonList(this.myProfilesNode), super.doGetChildren());
        }

        public void updateProfiles() {
            this.myProfilesNode.updateProfiles();
        }
    }

    public abstract class ProjectsGroupNode
    extends GroupNode {
        private final List<ProjectNode> myProjectNodes;

        public ProjectsGroupNode(MavenSimpleNode parent) {
            super(parent);
            this.myProjectNodes = new ArrayList<ProjectNode>();
            this.setIcons(MavenIcons.CLOSED_MODULES_ICON, MavenIcons.OPEN_MODULES_ICON);
        }

        @Override
        protected List<? extends MavenSimpleNode> doGetChildren() {
            return this.myProjectNodes;
        }

        public List<ProjectNode> getProjectNodesInTests() {
            return this.myProjectNodes;
        }

        protected void add(ProjectNode projectNode) {
            projectNode.setParent(this);
            this.insertSorted(this.myProjectNodes, projectNode);
            this.childrenChanged();
        }

        public void remove(ProjectNode projectNode) {
            projectNode.setParent(null);
            this.myProjectNodes.remove((Object)projectNode);
            this.childrenChanged();
        }

        public void sortProjects() {
            this.sort(this.myProjectNodes);
            this.childrenChanged();
        }
    }

    public abstract class GroupNode
    extends MavenSimpleNode {
        public GroupNode(MavenSimpleNode parent) {
            super(parent);
        }

        @Override
        public boolean isVisible() {
            if (this.getDisplayKind() == DisplayKind.ALWAYS) {
                return true;
            }
            for (SimpleNode each : this.getChildren()) {
                if (!((MavenSimpleNode)each).isVisible()) continue;
                return true;
            }
            return false;
        }

        protected <T extends MavenSimpleNode> void insertSorted(List<T> list, T newObject) {
            int pos = Collections.binarySearch(list, newObject, NODE_COMPARATOR);
            list.add(pos >= 0 ? pos : -pos - 1, newObject);
        }

        protected void sort(List<? extends MavenSimpleNode> list) {
            Collections.sort(list, NODE_COMPARATOR);
        }
    }

    public abstract class MavenSimpleNode
    extends CachingSimpleNode {
        private MavenSimpleNode myParent;
        private ErrorLevel myErrorLevel;
        private ErrorLevel myTotalErrorLevel;

        public MavenSimpleNode(MavenSimpleNode parent) {
            super(MavenProjectsStructure.this.myProject, null);
            this.myErrorLevel = ErrorLevel.NONE;
            this.myTotalErrorLevel = null;
            this.setParent(parent);
        }

        public void setParent(MavenSimpleNode parent) {
            this.myParent = parent;
        }

        public NodeDescriptor getParentDescriptor() {
            return this.myParent;
        }

        public <T extends MavenSimpleNode> T findParent(Class<T> parentClass) {
            MavenSimpleNode node = this;
            while ((node = node.myParent) != null && !parentClass.isInstance((Object)node)) {
            }
            return (T)((Object)node);
        }

        public boolean isVisible() {
            return this.getDisplayKind() != DisplayKind.NEVER;
        }

        public DisplayKind getDisplayKind() {
            Class<? extends MavenSimpleNode>[] visibles = MavenProjectsStructure.this.getVisibleNodesClasses();
            if (visibles == null) {
                return DisplayKind.NORMAL;
            }
            for (Class<? extends MavenSimpleNode> each : visibles) {
                if (!each.isInstance((Object)this)) continue;
                return DisplayKind.ALWAYS;
            }
            return DisplayKind.NEVER;
        }

        protected SimpleNode[] buildChildren() {
            List<? extends MavenSimpleNode> children = this.doGetChildren();
            if (children.isEmpty()) {
                return NO_CHILDREN;
            }
            ArrayList<MavenSimpleNode> result = new ArrayList<MavenSimpleNode>();
            for (MavenSimpleNode mavenSimpleNode : children) {
                if (!mavenSimpleNode.isVisible()) continue;
                result.add(mavenSimpleNode);
            }
            return (SimpleNode[])result.toArray(new MavenSimpleNode[result.size()]);
        }

        protected List<? extends MavenSimpleNode> doGetChildren() {
            return Collections.emptyList();
        }

        public void cleanUpCache() {
            super.cleanUpCache();
            this.myTotalErrorLevel = null;
        }

        protected void childrenChanged() {
            for (MavenSimpleNode each = this; each != null; each = (MavenSimpleNode)each.getParent()) {
                each.cleanUpCache();
            }
            MavenProjectsStructure.this.updateUpTo((SimpleNode)this);
        }

        public ErrorLevel getTotalErrorLevel() {
            if (this.myTotalErrorLevel == null) {
                this.myTotalErrorLevel = this.calcTotalErrorLevel();
            }
            return this.myTotalErrorLevel;
        }

        private ErrorLevel calcTotalErrorLevel() {
            ErrorLevel childrenErrorLevel = this.getChildrenErrorLevel();
            return childrenErrorLevel.compareTo(this.myErrorLevel) > 0 ? childrenErrorLevel : this.myErrorLevel;
        }

        public ErrorLevel getChildrenErrorLevel() {
            ErrorLevel result = ErrorLevel.NONE;
            for (SimpleNode each : this.getChildren()) {
                ErrorLevel eachLevel = ((MavenSimpleNode)each).getTotalErrorLevel();
                if (eachLevel.compareTo(result) <= 0) continue;
                result = eachLevel;
            }
            return result;
        }

        public void setErrorLevel(ErrorLevel level) {
            if (this.myErrorLevel == level) {
                return;
            }
            this.myErrorLevel = level;
            MavenProjectsStructure.this.updateUpTo((SimpleNode)this);
        }

        protected void doUpdate() {
            this.setNameAndTooltip(this.getName(), null);
        }

        protected void setNameAndTooltip(String name, @Nullable String tooltip) {
            this.setNameAndTooltip(name, tooltip, (String)null);
        }

        protected void setNameAndTooltip(String name, @Nullable String tooltip, @Nullable String hint) {
            this.setNameAndTooltip(name, tooltip, this.getPlainAttributes());
            if (MavenProjectsStructure.this.showDescriptions() && !StringUtil.isEmptyOrSpaces((String)hint)) {
                this.addColoredFragment(" (" + hint + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
        }

        protected void setNameAndTooltip(String name, @Nullable String tooltip, SimpleTextAttributes attribs) {
            this.clearColoredText();
            this.addColoredFragment(name, this.prepareAttribs(attribs));
            this.getTemplatePresentation().setTooltip(tooltip);
        }

        private SimpleTextAttributes prepareAttribs(SimpleTextAttributes from) {
            ErrorLevel level = this.getTotalErrorLevel();
            Color waveColor = level == ErrorLevel.NONE ? null : Color.RED;
            int style = from.getStyle();
            if (waveColor != null) {
                style |= 8;
            }
            return new SimpleTextAttributes(from.getBgColor(), from.getFgColor(), waveColor, style);
        }

        @Nullable
        @NonNls
        String getActionId() {
            return null;
        }

        @Nullable
        @NonNls
        String getMenuId() {
            return null;
        }

        @Nullable
        public VirtualFile getVirtualFile() {
            return null;
        }

        @Nullable
        public Navigatable getNavigatable() {
            VirtualFile file = this.getVirtualFile();
            if (file == null || !file.isValid()) {
                return null;
            }
            return PsiManager.getInstance((Project)this.getProject()).findFile(file);
        }

        public void handleDoubleClickOrEnter(SimpleTree tree, InputEvent inputEvent) {
            String actionId = this.getActionId();
            if (actionId != null) {
                MavenUIUtil.executeAction(actionId, inputEvent);
            }
        }
    }

    public static enum ErrorLevel {
        NONE,
        ERROR;

    }

    static enum DisplayKind {
        ALWAYS,
        NEVER,
        NORMAL;

    }
}

