/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.embedder.MavenEmbedderFactory;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.ProjectBundle;

public class MavenEnvironmentForm {
    private JPanel panel;
    private LabeledComponent<TextFieldWithBrowseButton> mavenHomeComponent;
    private LabeledComponent<TextFieldWithBrowseButton> localRepositoryComponent;
    private LabeledComponent<TextFieldWithBrowseButton> mavenSettingsFileComponent;
    private JCheckBox mavenHomeOverrideCheckBox;
    private JCheckBox mavenSettingsFileOverrideCheckBox;
    private JCheckBox localRepositoryOverrideCheckBox;
    private final PathOverrider mavenHomeOverrider;
    private final PathOverrider mavenSettingsFileOverrider;
    private final PathOverrider localRepositoryOverrider;

    public MavenEnvironmentForm() {
        this.$$$setupUI$$$();
        this.mavenHomeOverrider = new PathOverrider(this.mavenHomeComponent, this.mavenHomeOverrideCheckBox, new PathOverrider.PathProvider(){

            @Override
            @Nullable
            protected File getFile() {
                return MavenEmbedderFactory.resolveMavenHomeDirectory("");
            }
        });
        this.mavenSettingsFileOverrider = new PathOverrider(this.mavenSettingsFileComponent, this.mavenSettingsFileOverrideCheckBox, new PathOverrider.PathProvider(){

            @Override
            @Nullable
            protected File getFile() {
                return MavenEmbedderFactory.resolveUserSettingsFile("");
            }
        });
        this.localRepositoryOverrider = new PathOverrider(this.localRepositoryComponent, this.localRepositoryOverrideCheckBox, new PathOverrider.PathProvider(){

            @Override
            @Nullable
            protected File getFile() {
                return MavenEmbedderFactory.resolveLocalRepository(MavenEnvironmentForm.this.mavenHomeOverrider.getText(), MavenEnvironmentForm.this.mavenSettingsFileOverrider.getText(), "");
            }
        });
    }

    public boolean isModified(MavenGeneralSettings data) {
        MavenGeneralSettings formData = new MavenGeneralSettings();
        this.setData(formData);
        return !formData.equals(data);
    }

    public void setData(MavenGeneralSettings data) {
        data.setMavenHome(this.mavenHomeOverrider.getText());
        data.setMavenSettingsFile(this.mavenSettingsFileOverrider.getText());
        data.setLocalRepository(this.localRepositoryOverrider.getText());
    }

    public void getData(MavenGeneralSettings data) {
        this.mavenHomeOverrider.setText(data.getMavenHome());
        this.mavenSettingsFileOverrider.setText(data.getMavenSettingsFile());
        this.localRepositoryOverrider.setText(data.getLocalRepository());
    }

    public JComponent createComponent() {
        ((TextFieldWithBrowseButton)this.mavenHomeComponent.getComponent()).addBrowseFolderListener(ProjectBundle.message("maven.select.maven.home.directory", new Object[0]), "", null, new FileChooserDescriptor(false, true, false, false, false, false));
        ((TextFieldWithBrowseButton)this.mavenSettingsFileComponent.getComponent()).addBrowseFolderListener(ProjectBundle.message("maven.select.maven.settings.file", new Object[0]), "", null, new FileChooserDescriptor(true, false, false, false, false, false));
        ((TextFieldWithBrowseButton)this.localRepositoryComponent.getComponent()).addBrowseFolderListener(ProjectBundle.message("maven.select.local.repository", new Object[0]), "", null, new FileChooserDescriptor(false, true, false, false, false, false));
        return this.panel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        LabeledComponent labeledComponent;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        LabeledComponent labeledComponent2;
        LabeledComponent labeledComponent3;
        JPanel jPanel;
        this.panel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.mavenHomeComponent = labeledComponent3 = new LabeledComponent();
        labeledComponent3.setComponentClass("com.intellij.openapi.ui.TextFieldWithBrowseButton");
        labeledComponent3.setText("Maven &home directory");
        jPanel.add((Component)labeledComponent3, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 3, null, null, null));
        this.mavenSettingsFileComponent = labeledComponent2 = new LabeledComponent();
        labeledComponent2.setComponentClass("com.intellij.openapi.ui.TextFieldWithBrowseButton");
        labeledComponent2.setText("Maven user &settings file");
        jPanel.add((Component)labeledComponent2, new GridConstraints(1, 0, 1, 1, 0, 1, 7, 3, null, null, null));
        this.mavenSettingsFileOverrideCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Override");
        jPanel.add((Component)jCheckBox3, new GridConstraints(1, 1, 1, 1, 6, 0, 3, 0, null, null, null));
        this.mavenHomeOverrideCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Override");
        jPanel.add((Component)jCheckBox2, new GridConstraints(0, 1, 1, 1, 6, 0, 3, 0, null, null, null));
        this.localRepositoryComponent = labeledComponent = new LabeledComponent();
        labeledComponent.setComponentClass("com.intellij.openapi.ui.TextFieldWithBrowseButton");
        labeledComponent.setText("Local &repository directory");
        jPanel.add((Component)labeledComponent, new GridConstraints(2, 0, 1, 1, 0, 1, 7, 3, null, null, null));
        this.localRepositoryOverrideCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Override");
        jPanel.add((Component)jCheckBox, new GridConstraints(2, 1, 1, 1, 6, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    private static class PathOverrider {
        private final TextFieldWithBrowseButton component;
        private final JCheckBox checkBox;
        private final PathProvider pathProvider;
        private String overrideText;
        private final ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PathOverrider.this.update();
            }
        };

        public PathOverrider(LabeledComponent<TextFieldWithBrowseButton> component, JCheckBox checkBox, PathProvider pathProvider) {
            this.component = (TextFieldWithBrowseButton)component.getComponent();
            this.checkBox = checkBox;
            this.pathProvider = pathProvider;
            checkBox.addActionListener(this.listener);
        }

        private void update() {
            boolean override = this.checkBox.isSelected();
            this.component.setEditable(override);
            this.component.setEnabled(override);
            if (override) {
                this.component.setText(this.overrideText);
            } else {
                this.overrideText = this.component.getText();
                this.component.setText(this.pathProvider.getPath());
            }
        }

        public void setText(String text) {
            this.overrideText = text;
            this.checkBox.setSelected(!StringUtil.isEmptyOrSpaces((String)text));
            this.update();
        }

        public String getText() {
            return this.checkBox.isSelected() ? this.component.getText().trim() : "";
        }

        static abstract class PathProvider {
            PathProvider() {
            }

            public String getPath() {
                File file = this.getFile();
                return file == null ? "" : file.getPath();
            }

            @Nullable
            protected abstract File getFile();
        }
    }
}

