/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenActionUtil {
    public static Project getProject(AnActionEvent e) {
        return (Project)e.getData(PlatformDataKeys.PROJECT);
    }

    public static MavenProjectsManager getProjectsManager(AnActionEvent e) {
        return MavenProjectsManager.getInstance(MavenActionUtil.getProject(e));
    }

    public static MavenProject getMavenProject(AnActionEvent e) {
        MavenProject result;
        MavenProjectsManager manager = MavenActionUtil.getProjectsManager(e);
        VirtualFile file = (VirtualFile)e.getData(PlatformDataKeys.VIRTUAL_FILE);
        if (file != null && (result = manager.findProject(file)) != null) {
            return result;
        }
        Module module = MavenActionUtil.getModule(e);
        if (module != null && (result = manager.findProject(module)) != null) {
            return result;
        }
        return null;
    }

    public static boolean isMavenProject(AnActionEvent e) {
        return MavenActionUtil.getMavenProject(e) != null;
    }

    public static boolean isMavenProjectFile(VirtualFile file) {
        return file != null && !file.isDirectory() && "pom.xml".equals(file.getName());
    }

    public static List<MavenProject> getMavenProjects(AnActionEvent e) {
        MavenProject project;
        LinkedHashSet<MavenProject> result = new LinkedHashSet<MavenProject>();
        for (VirtualFile virtualFile : MavenActionUtil.getFiles(e)) {
            project = MavenActionUtil.getProjectsManager(e).findProject(virtualFile);
            if (project == null) continue;
            result.add(project);
        }
        if (result.isEmpty()) {
            for (Module module : MavenActionUtil.getModules(e)) {
                project = MavenActionUtil.getProjectsManager(e).findProject(module);
                if (project == null) continue;
                result.add(project);
            }
        }
        return new ArrayList<MavenProject>(result);
    }

    public static List<VirtualFile> getMavenProjectsFiles(AnActionEvent e) {
        return MavenUtil.collectFiles(MavenActionUtil.getMavenProjects(e));
    }

    private static List<VirtualFile> getFiles(AnActionEvent e) {
        VirtualFile[] result = (VirtualFile[])e.getData(PlatformDataKeys.VIRTUAL_FILE_ARRAY);
        return result == null ? Collections.emptyList() : Arrays.asList(result);
    }

    private static Module getModule(AnActionEvent e) {
        Module result = (Module)e.getData(DataKeys.MODULE);
        return result != null ? result : (Module)e.getData(DataKeys.MODULE_CONTEXT);
    }

    private static List<Module> getModules(AnActionEvent e) {
        Module[] result = (Module[])e.getData(DataKeys.MODULE_CONTEXT_ARRAY);
        if (result != null) {
            return Arrays.asList(result);
        }
        Module module = MavenActionUtil.getModule(e);
        return module != null ? Collections.singletonList(module) : Collections.emptyList();
    }
}

