/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.java;

import com.intellij.lang.Language;
import com.intellij.lang.injection.ConcatenationAwareInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.InjectedLanguage;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.intellij.plugins.intelliLang.util.AnnotationUtilEx;
import org.intellij.plugins.intelliLang.util.ContextComputationProcessor;
import org.jetbrains.annotations.NotNull;

public class ConcatenationInjector
implements ConcatenationAwareInjector {
    private final Configuration myInjectionConfiguration;

    public ConcatenationInjector(Configuration configuration) {
        this.myInjectionConfiguration = configuration;
    }

    public void getLanguagesToInject(final @NotNull MultiHostRegistrar registrar, PsiElement ... operands) {
        if (registrar == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/java/ConcatenationInjector.getLanguagesToInject must not be null");
        }
        if (operands == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/java/ConcatenationInjector.getLanguagesToInject must not be null");
        }
        final PsiFile containingFile = operands[0].getContainingFile();
        this.processLiteralExpressionInjections(new PairProcessor<Language, List<Trinity<PsiLanguageInjectionHost, InjectedLanguage, TextRange>>>(){

            public boolean process(Language language, List<Trinity<PsiLanguageInjectionHost, InjectedLanguage, TextRange>> list) {
                InjectorUtils.registerInjection(language, list, containingFile, registrar);
                return true;
            }
        }, operands);
    }

    private boolean processAnnotationInjections(boolean unparsable, PsiModifierListOwner annoElement, PairProcessor<Language, List<Trinity<PsiLanguageInjectionHost, InjectedLanguage, TextRange>>> processor, PsiElement ... operands) {
        PsiAnnotation[] annotations = AnnotationUtilEx.getAnnotationFrom(annoElement, this.myInjectionConfiguration.getLanguageAnnotationPair(), true);
        if (annotations.length > 0) {
            String id = AnnotationUtilEx.calcAnnotationValue(annotations, "value");
            String prefix = AnnotationUtilEx.calcAnnotationValue(annotations, "prefix");
            String suffix = AnnotationUtilEx.calcAnnotationValue(annotations, "suffix");
            BaseInjection injection = new BaseInjection("java");
            if (prefix != null) {
                injection.setPrefix(prefix);
            }
            if (suffix != null) {
                injection.setSuffix(suffix);
            }
            if (id != null) {
                injection.setInjectedLanguageId(id);
            }
            ConcatenationInjector.processInjectionWithContext(unparsable, injection, processor, operands);
            return true;
        }
        return false;
    }

    private void processLiteralExpressionInjections(final PairProcessor<Language, List<Trinity<PsiLanguageInjectionHost, InjectedLanguage, TextRange>>> processor, final PsiElement ... operands) {
        ConcatenationInjector.processLiteralExpressionInjectionsInner(this.myInjectionConfiguration, new Processor<Info>(){

            public boolean process(Info info) {
                if (ConcatenationInjector.this.processAnnotationInjections(info.unparsable, info.owner, (PairProcessor<Language, List<Trinity<PsiLanguageInjectionHost, InjectedLanguage, TextRange>>>)processor, operands)) {
                    return false;
                }
                for (BaseInjection injection : info.injections) {
                    ConcatenationInjector.processInjectionWithContext(info.unparsable, injection, (PairProcessor<Language, List<Trinity<PsiLanguageInjectionHost, InjectedLanguage, TextRange>>>)processor, operands);
                    if (!injection.isTerminal()) continue;
                    return false;
                }
                return true;
            }
        }, operands);
    }

    public static void processLiteralExpressionInjectionsInner(Configuration configuration, Processor<Info> processor, PsiElement ... operands) {
        if (operands.length == 0) {
            return;
        }
        PsiElement firstOperand = operands[0];
        PsiElement topBlock = PsiUtil.getTopLevelEnclosingCodeBlock((PsiElement)firstOperand, null);
        LocalSearchScope searchScope = new LocalSearchScope(new PsiElement[]{topBlock instanceof PsiCodeBlock ? topBlock : firstOperand.getContainingFile()}, "", true);
        THashSet visitedVars = new THashSet();
        LinkedList<Object> places = new LinkedList<Object>();
        places.add(firstOperand);
        boolean unparsable = false;
        while (!places.isEmpty()) {
            List injections;
            Info info;
            int parameterIndex;
            PsiMethod psiMethod;
            PsiElement curPlace = (PsiElement)places.removeFirst();
            final PsiModifierListOwner owner = AnnotationUtilEx.getAnnotatedElementFor(curPlace, AnnotationUtilEx.LookupType.PREFER_CONTEXT);
            if (owner == null) continue;
            if (owner instanceof PsiParameter) {
                PsiElement declarationScope = ((PsiParameter)owner).getDeclarationScope();
                psiMethod = declarationScope instanceof PsiMethod ? (PsiMethod)declarationScope : null;
                PsiParameterList parameterList = psiMethod == null ? null : ((PsiMethod)declarationScope).getParameterList();
                if (parameterList == null || parameterList != owner.getParent()) continue;
                parameterIndex = parameterList.getParameterIndex((PsiParameter)owner);
            } else if (owner instanceof PsiMethod) {
                psiMethod = (PsiMethod)owner;
                parameterIndex = -1;
            } else if (configuration.isResolveReferences() && owner instanceof PsiVariable && visitedVars.add((Object)owner)) {
                PsiVariable variable = (PsiVariable)owner;
                for (PsiReference psiReference : ReferencesSearch.search((PsiElement)variable, (SearchScope)searchScope).findAll()) {
                    PsiElement element = psiReference.getElement();
                    if (!(element instanceof PsiExpression)) continue;
                    PsiExpression refExpression = (PsiExpression)element;
                    places.add(refExpression);
                    if (unparsable) continue;
                    unparsable = ConcatenationInjector.checkUnparsableReference(refExpression);
                }
                parameterIndex = -1;
                psiMethod = null;
            } else {
                parameterIndex = -1;
                psiMethod = null;
            }
            if (processor.process((Object)(info = new Info(owner, psiMethod, injections = psiMethod == null ? Collections.emptyList() : ContainerUtil.findAll(configuration.getInjections("java"), (Condition)new Condition<BaseInjection>(){

                public boolean value(BaseInjection injection) {
                    return injection.acceptsPsiElement((PsiElement)owner);
                }
            }), unparsable, parameterIndex)))) continue;
            return;
        }
    }

    private static void processInjectionWithContext(boolean unparsable, BaseInjection injection, PairProcessor<Language, List<Trinity<PsiLanguageInjectionHost, InjectedLanguage, TextRange>>> processor, PsiElement ... operands) {
        Language language = InjectedLanguage.findLanguageById(injection.getInjectedLanguageId());
        if (language == null) {
            return;
        }
        boolean separateFiles = !injection.isSingleFile() && StringUtil.isNotEmpty((String)injection.getValuePattern());
        Ref unparsableRef = Ref.create((Object)unparsable);
        List<Object> objects = ContextComputationProcessor.collectOperands(injection.getPrefix(), injection.getSuffix(), (Ref<Boolean>)unparsableRef, operands);
        if (objects.isEmpty()) {
            return;
        }
        ArrayList<Trinity> result = new ArrayList<Trinity>();
        int len = objects.size();
        for (int i = 0; i < len; ++i) {
            String curPrefix = null;
            Object o = objects.get(i);
            if (o instanceof String) {
                curPrefix = (String)o;
                if (i == len - 1) {
                    return;
                }
                o = objects.get(++i);
            }
            String curSuffix = null;
            PsiLanguageInjectionHost curHost = null;
            if (o instanceof PsiLanguageInjectionHost) {
                Object next;
                curHost = (PsiLanguageInjectionHost)o;
                if (i == len - 2 && (next = objects.get(i + 1)) instanceof String) {
                    ++i;
                    curSuffix = (String)next;
                }
            }
            if (curHost == null) {
                unparsableRef.set((Object)Boolean.TRUE);
                continue;
            }
            if (!(curHost instanceof PsiLiteralExpression)) {
                result.add(Trinity.create((Object)curHost, (Object)InjectedLanguage.create(injection.getInjectedLanguageId(), curPrefix, curSuffix, true), (Object)ElementManipulators.getManipulator((PsiElement)curHost).getRangeInElement((PsiElement)curHost)));
                continue;
            }
            List<TextRange> injectedArea = injection.getInjectedArea((PsiElement)curHost);
            int injectedAreaSize = injectedArea.size();
            for (int j = 0; j < injectedAreaSize; ++j) {
                TextRange textRange = injectedArea.get(j);
                result.add(Trinity.create((Object)curHost, (Object)InjectedLanguage.create(injection.getInjectedLanguageId(), separateFiles || j == 0 ? curPrefix : "", separateFiles || j == injectedAreaSize - 1 ? curSuffix : "", true), (Object)textRange));
            }
        }
        if (!result.isEmpty()) {
            if (separateFiles) {
                for (Trinity trinity : result) {
                    processor.process((Object)language, Collections.singletonList(trinity));
                }
            } else {
                for (Trinity trinity : result) {
                    ((PsiLanguageInjectionHost)trinity.first).putUserData(LanguageInjectionSupport.HAS_UNPARSABLE_FRAGMENTS, unparsableRef.get());
                }
                processor.process((Object)language, result);
            }
        }
    }

    private static boolean checkUnparsableReference(PsiExpression refExpression) {
        PsiElement parent = refExpression.getParent();
        if (parent instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
            IElementType operation = assignmentExpression.getOperationTokenType();
            if (assignmentExpression.getLExpression() == refExpression && JavaTokenType.PLUSEQ.equals(operation)) {
                return true;
            }
        } else if (parent instanceof PsiBinaryExpression) {
            return true;
        }
        return false;
    }

    public static class Info {
        final PsiModifierListOwner owner;
        final PsiMethod method;
        final List<BaseInjection> injections;
        final boolean unparsable;
        final int parameterIndex;

        public Info(PsiModifierListOwner owner, PsiMethod method, List<BaseInjection> injections, boolean unparsable, int parameterIndex) {
            this.owner = owner;
            this.method = method;
            this.injections = injections;
            this.unparsable = unparsable;
            this.parameterIndex = parameterIndex;
        }
    }
}

