/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.psi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.maddyhome.idea.copyright.CopyrightProfile;
import com.maddyhome.idea.copyright.CopyrightUpdaters;
import com.maddyhome.idea.copyright.psi.UpdateCopyright;
import com.maddyhome.idea.copyright.psi.UpdateCopyrightInstanceFactory;
import com.maddyhome.idea.copyright.psi.UpdateJavaFileCopyright;
import com.maddyhome.idea.copyright.psi.UpdateJavaScriptFileCopyright;
import com.maddyhome.idea.copyright.psi.UpdateJspFileCopyright;
import com.maddyhome.idea.copyright.psi.UpdateJspxFileCopyright;
import com.maddyhome.idea.copyright.psi.UpdatePropertiesFileCopyright;
import com.maddyhome.idea.copyright.psi.UpdateXmlFileCopyright;
import com.maddyhome.idea.copyright.util.FileTypeUtil;

public class UpdateCopyrightFactory {
    private static final Logger logger = Logger.getInstance((String)UpdateCopyrightFactory.class.getName());

    public static UpdateCopyright createUpdateCopyright(Project project, Module module, PsiFile file, CopyrightProfile options) {
        return UpdateCopyrightFactory.createUpdateCopyright(project, module, file.getVirtualFile(), file.getFileType(), options);
    }

    private static UpdateCopyright createUpdateCopyright(Project project, Module module, VirtualFile file, FileType base, CopyrightProfile options) {
        if (base == null || file == null) {
            return null;
        }
        FileType type = FileTypeUtil.getInstance().getFileTypeByType(base);
        logger.debug("file=" + file);
        logger.debug("type=" + type.getName());
        if (type.equals(StdFileTypes.JAVA)) {
            return new UpdateJavaFileCopyright(project, module, file, options);
        }
        if (type.equals(StdFileTypes.XML)) {
            return new UpdateXmlFileCopyright(project, module, file, options);
        }
        if (type.equals(StdFileTypes.HTML)) {
            return new UpdateXmlFileCopyright(project, module, file, options);
        }
        if (type.equals(StdFileTypes.JSP)) {
            return new UpdateJspFileCopyright(project, module, file, options);
        }
        if (type.equals(StdFileTypes.JSPX)) {
            return new UpdateJspxFileCopyright(project, module, file, options);
        }
        if (type.equals(StdFileTypes.PROPERTIES)) {
            return new UpdatePropertiesFileCopyright(project, module, file, options);
        }
        if ("JavaScript".equals(type.getName())) {
            return new UpdateJavaScriptFileCopyright(project, module, file, options);
        }
        return ((UpdateCopyrightInstanceFactory)CopyrightUpdaters.INSTANCE.forFileType(type)).createInstance(project, module, file, type, options);
    }

    private UpdateCopyrightFactory() {
    }
}

