/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.ui;

import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JFormattedTextField;

public class IntegerTextField
extends JFormattedTextField {
    public IntegerTextField() {
    }

    public IntegerTextField(Object object) {
        super(object);
    }

    public IntegerTextField(Format format) {
        super(format);
    }

    public IntegerTextField(JFormattedTextField.AbstractFormatter abstractFormatter) {
        super(abstractFormatter);
    }

    public IntegerTextField(JFormattedTextField.AbstractFormatterFactory abstractFormatterFactory) {
        super(abstractFormatterFactory);
    }

    public IntegerTextField(JFormattedTextField.AbstractFormatterFactory abstractFormatterFactory, Object object) {
        super(abstractFormatterFactory, object);
    }

    public void setRange(int min, int max) {
        this.setFormatterFactory(new IntegerFormatterFactory(min, max));
    }

    protected static class IntegerFormatter
    extends JFormattedTextField.AbstractFormatter {
        private final int min;
        private final int max;
        private final NumberFormat formatter = NumberFormat.getIntegerInstance();

        public IntegerFormatter(int min, int max) {
            this.min = min;
            this.max = max;
        }

        @Override
        public Object stringToValue(String string) throws ParseException {
            Number res = this.formatter.parse(string);
            if (res.intValue() < this.min || res.intValue() > this.max) {
                throw new ParseException("Out of range", 0);
            }
            return res;
        }

        @Override
        public String valueToString(Object object) throws ParseException {
            if (object == null) {
                return null;
            }
            return object.toString();
        }
    }

    protected static class IntegerFormatterFactory
    extends JFormattedTextField.AbstractFormatterFactory {
        private final int min;
        private final int max;

        public IntegerFormatterFactory(int min, int max) {
            this.min = min;
            this.max = max;
        }

        @Override
        public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField jFormattedTextField) {
            return new IntegerFormatter(this.min, this.max);
        }
    }
}

