/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.artifact;

import org.apache.maven.mercury.artifact.QualityEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Quality
implements Comparable<Quality> {
    public static final int DEFAULT_QUANTITY = 0;
    public static final int SNAPSHOT_TS_QUANTITY = 1;
    public static final int FIXED_RELEASE_QUANTITY = -2;
    public static final int FIXED_LATEST_QUANTITY = -3;
    public static final Quality UNKNOWN_QUALITY = new Quality(QualityEnum.unknown, -1);
    public static final Quality SNAPSHOT_QUALITY = new Quality(QualityEnum.snapshot, 0);
    public static final Quality SNAPSHOT_TS_QUALITY = new Quality(QualityEnum.snapshot, 1);
    public static final Quality ALPHA_QUALITY = new Quality(QualityEnum.alpha, 0);
    public static final Quality BETA_QUALITY = new Quality(QualityEnum.beta, 0);
    public static final Quality RELEASE_QUALITY = new Quality(QualityEnum.release, 0);
    public static final Quality FIXED_RELEASE_QUALITY = new Quality(QualityEnum.unknown, -2);
    public static final Quality FIXED_LATEST_QUALITY = new Quality(QualityEnum.unknown, -3);
    private static final String snExp = ".+-(SNAPSHOT|\\d{8}\\.\\d{6}-\\d+)";
    private static final String alphaExp = ".+-alpha-\\d+";
    private static final String betaExp = ".+-beta-\\d+";
    protected QualityEnum quality;
    protected int quantity;

    public Quality(QualityEnum quality, int quantity) {
        this.quality = quality;
        this.quantity = quantity;
    }

    public Quality(String version) {
        if (version == null || version.length() < 1) {
            this.quality = QualityEnum.unknown;
            this.quantity = -1;
            return;
        }
        if ("RELEASE".equals(version)) {
            this.quality = QualityEnum.unknown;
            this.quantity = -2;
            return;
        }
        if ("LATEST".equals(version)) {
            this.quality = QualityEnum.unknown;
            this.quantity = -3;
            return;
        }
        if (version.matches(snExp)) {
            this.quality = QualityEnum.snapshot;
            this.quantity = version.endsWith("SNAPSHOT") ? 0 : 1;
            return;
        }
        if (version.matches(alphaExp)) {
            this.quality = QualityEnum.alpha;
            this.quantity = Integer.parseInt(version.substring(version.lastIndexOf(45) + 1));
            return;
        }
        if (version.matches(betaExp)) {
            this.quality = QualityEnum.beta;
            this.quantity = Integer.parseInt(version.substring(version.lastIndexOf(45) + 1));
            return;
        }
        this.quality = QualityEnum.release;
        this.quantity = 0;
    }

    @Override
    public int compareTo(Quality q) {
        int ql2;
        if (q == null) {
            return this.quality == null ? 0 : 1;
        }
        int ql = (this.quality == null ? QualityEnum.unknown : this.quality).getId();
        if (ql == (ql2 = (q.quality == null ? QualityEnum.unknown : q.quality).getId())) {
            if (ql == QualityEnum.snapshot.getId()) {
                return 0;
            }
            return this.quantity - q.quantity;
        }
        return Quality.sign(ql - ql2);
    }

    private static int sign(int i) {
        return i < 0 ? -1 : 1;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass().isAssignableFrom(Quality.class)) {
            return this.compareTo((Quality)obj) == 0;
        }
        if (obj.getClass().isAssignableFrom(QualityEnum.class)) {
            return this.compareTo((QualityEnum)((Object)obj)) == 0;
        }
        return super.equals(obj);
    }

    @Override
    public int compareTo(QualityEnum qe) {
        if (qe == null) {
            return this.quality == null ? 0 : 1;
        }
        int ql1 = (this.quality == null ? QualityEnum.unknown : this.quality).getId();
        return Quality.sign(ql1 - qe.getId());
    }

    public QualityEnum getQuality() {
        return this.quality;
    }

    public int getQuantity() {
        return this.quantity;
    }
}

