/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import org.jetbrains.annotations.NotNull;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SvnRevisionNumber
implements VcsRevisionNumber {
    @NotNull
    private final SVNRevision myRevision;

    public SvnRevisionNumber(@NotNull SVNRevision revision) {
        if (revision == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/svn/SvnRevisionNumber.<init> must not be null");
        }
        this.myRevision = revision;
    }

    public String asString() {
        return this.myRevision.toString();
    }

    public int compareTo(VcsRevisionNumber vcsRevisionNumber) {
        if (vcsRevisionNumber == null || vcsRevisionNumber.getClass() != SvnRevisionNumber.class) {
            return -1;
        }
        SVNRevision rev = ((SvnRevisionNumber)vcsRevisionNumber).myRevision;
        if (!this.myRevision.isValid()) {
            return !rev.isValid() ? 0 : -1;
        }
        if (this.myRevision.getNumber() >= 0L && rev.getNumber() >= 0L) {
            return this.myRevision.getNumber() == rev.getNumber() ? 0 : (this.myRevision.getNumber() > rev.getNumber() ? 1 : -1);
        }
        if (this.myRevision.getDate() != null && rev.getDate() != null) {
            return this.myRevision.getDate().compareTo(rev.getDate());
        }
        if (this.myRevision.equals((Object)SVNRevision.HEAD)) {
            return rev.equals((Object)SVNRevision.HEAD) ? 0 : 1;
        }
        return this.myRevision.getID() == rev.getID() ? 0 : (this.myRevision.getID() > rev.getID() ? 1 : -1);
    }

    @NotNull
    public SVNRevision getRevision() {
        SVNRevision sVNRevision = this.myRevision;
        if (sVNRevision == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/SvnRevisionNumber.getRevision must not return null");
        }
        return sVNRevision;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SvnRevisionNumber that = (SvnRevisionNumber)o;
        return this.myRevision.equals((Object)that.myRevision);
    }

    public int hashCode() {
        return this.myRevision.hashCode();
    }

    public String toString() {
        return this.myRevision.toString();
    }
}

