/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs.browser;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.ui.DocumentAdapter;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.dialogs.RepositoryBrowserComponent;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeNode;
import org.jetbrains.idea.svn.dialogs.browser.MessageBoxCellRenderer;
import org.jetbrains.idea.svn.dialogs.browser.OpeningExpander;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;

public class CopyOptionsDialog
extends DialogWrapper {
    private final SVNURL myURL;
    private JTextArea myCommitMessage;
    private final Project myProject;
    private JTextField myNameField;
    private JLabel myURLLabel;
    private RepositoryBrowserComponent myBrowser;
    private JLabel myTargetURL;
    private JComboBox myMessagesBox;
    private JPanel myMainPanel;

    public CopyOptionsDialog(String title, Project project, RepositoryTreeNode root, RepositoryTreeNode node) {
        super(project, true);
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myURL = node.getURL();
        this.myURLLabel.setText(this.myURL.toString());
        TreeNode[] path = node.getSelfPath();
        TreeNode[] subPath = new TreeNode[path.length - 1];
        System.arraycopy(path, 1, subPath, 0, path.length - 1);
        this.myBrowser.setRepositoryURL(root.getURL(), false, new OpeningExpander.Factory(subPath, (RepositoryTreeNode)(node.getParent() instanceof RepositoryTreeNode ? node.getParent() : null)));
        this.myBrowser.addChangeListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                CopyOptionsDialog.this.update();
            }
        });
        this.myNameField.setText(SVNPathUtil.tail((String)this.myURL.getPath()));
        this.myNameField.selectAll();
        this.myNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                CopyOptionsDialog.this.update();
            }
        });
        ArrayList messages = VcsConfiguration.getInstance((Project)this.myProject).getRecentMessages();
        Collections.reverse(messages);
        Object[] model = messages.toArray();
        this.myMessagesBox.setModel(new DefaultComboBoxModel<Object>(model));
        this.myMessagesBox.setRenderer(new MessageBoxCellRenderer());
        String lastMessage = VcsConfiguration.getInstance((Project)this.myProject).getLastNonEmptyCommitMessage();
        if (lastMessage != null) {
            this.myCommitMessage.setText(lastMessage);
            this.myCommitMessage.selectAll();
        }
        this.myMessagesBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object item = CopyOptionsDialog.this.myMessagesBox.getSelectedItem();
                if (item != null) {
                    CopyOptionsDialog.this.myCommitMessage.setText(item.toString());
                    CopyOptionsDialog.this.myCommitMessage.selectAll();
                }
            }
        });
        this.setTitle(title);
        this.init();
        this.update();
    }

    protected void dispose() {
        super.dispose();
        Disposer.dispose((Disposable)this.myBrowser);
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "svn4idea.copy.options";
    }

    public String getCommitMessage() {
        return this.myCommitMessage.getText();
    }

    public SVNURL getSourceURL() {
        return this.myURL;
    }

    public String getName() {
        return this.myNameField.getText();
    }

    @Nullable
    public SVNURL getTargetURL() {
        if (this.getOKAction().isEnabled()) {
            try {
                return SVNURL.parseURIEncoded((String)this.myTargetURL.getText());
            }
            catch (SVNException sVNException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public RepositoryTreeNode getTargetParentNode() {
        return this.myBrowser.getSelectedNode();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    private void createUIComponents() {
        this.myBrowser = new RepositoryBrowserComponent(SvnVcs.getInstance(this.myProject));
    }

    private void update() {
        RepositoryTreeNode baseNode = this.myBrowser.getSelectedNode();
        if (baseNode == null) {
            this.myTargetURL.setText("");
            this.getOKAction().setEnabled(false);
            return;
        }
        SVNURL baseURL = baseNode.getURL();
        String name = this.myNameField.getText();
        if (name == null || "".equals(name)) {
            this.getOKAction().setEnabled(false);
            return;
        }
        try {
            baseURL = baseURL.appendPath(this.myNameField.getText(), false);
        }
        catch (SVNException e) {
            this.getOKAction().setEnabled(false);
            return;
        }
        this.myTargetURL.setText(baseURL.toString());
        this.getOKAction().setEnabled(!this.myURL.toString().equals(this.myTargetURL.getText()));
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JTextArea jTextArea;
        JLabel jLabel;
        JTextField jTextField;
        JLabel jLabel2;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Source URL:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jLabel3, gridBagConstraints);
        this.myURLLabel = jLabel2 = new JLabel();
        Font font = jLabel2.getFont();
        jLabel2.setFont(new Font(font.getName(), 1, font.getSize()));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jLabel2, gridBagConstraints2);
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Target Location:");
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.gridwidth = 3;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jLabel4, gridBagConstraints3);
        RepositoryBrowserComponent repositoryBrowserComponent = this.myBrowser;
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 2;
        gridBagConstraints4.gridwidth = 3;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.weighty = 0.5;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.fill = 1;
        gridBagConstraints4.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)repositoryBrowserComponent, gridBagConstraints4);
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Target Name:");
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 3;
        gridBagConstraints5.anchor = 17;
        gridBagConstraints5.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jLabel5, gridBagConstraints5);
        this.myNameField = jTextField = new JTextField();
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 1;
        gridBagConstraints6.gridy = 3;
        gridBagConstraints6.gridwidth = 2;
        gridBagConstraints6.weightx = 1.0;
        gridBagConstraints6.anchor = 17;
        gridBagConstraints6.fill = 2;
        gridBagConstraints6.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jTextField, gridBagConstraints6);
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("Target URL: ");
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.gridx = 0;
        gridBagConstraints7.gridy = 4;
        gridBagConstraints7.anchor = 17;
        gridBagConstraints7.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jLabel6, gridBagConstraints7);
        this.myTargetURL = jLabel = new JLabel();
        Font font2 = jLabel.getFont();
        jLabel.setFont(new Font(font2.getName(), 1, font2.getSize()));
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.gridx = 1;
        gridBagConstraints8.gridy = 4;
        gridBagConstraints8.gridwidth = 2;
        gridBagConstraints8.weightx = 1.0;
        gridBagConstraints8.anchor = 17;
        gridBagConstraints8.fill = 2;
        gridBagConstraints8.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jLabel, gridBagConstraints8);
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("Commit Message:");
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.gridx = 0;
        gridBagConstraints9.gridy = 5;
        gridBagConstraints9.gridwidth = 3;
        gridBagConstraints9.anchor = 17;
        gridBagConstraints9.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jLabel7, gridBagConstraints9);
        JScrollPane jScrollPane = new JScrollPane();
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.gridx = 0;
        gridBagConstraints10.gridy = 6;
        gridBagConstraints10.gridwidth = 3;
        gridBagConstraints10.weightx = 1.0;
        gridBagConstraints10.weighty = 0.5;
        gridBagConstraints10.anchor = 11;
        gridBagConstraints10.fill = 1;
        gridBagConstraints10.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jScrollPane, gridBagConstraints10);
        this.myCommitMessage = jTextArea = new JTextArea();
        jTextArea.setColumns(25);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setText("");
        jTextArea.setRows(5);
        jTextArea.setLineWrap(true);
        jScrollPane.setViewportView(jTextArea);
        JLabel jLabel8 = new JLabel();
        jLabel8.setText("Recent Messages: ");
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.gridy = 7;
        gridBagConstraints11.gridwidth = 3;
        gridBagConstraints11.anchor = 11;
        gridBagConstraints11.fill = 2;
        gridBagConstraints11.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jLabel8, gridBagConstraints11);
        this.myMessagesBox = jComboBox = new JComboBox();
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.gridx = 0;
        gridBagConstraints12.gridy = 8;
        gridBagConstraints12.gridwidth = 3;
        gridBagConstraints12.anchor = 11;
        gridBagConstraints12.fill = 2;
        gridBagConstraints12.insets = new Insets(2, 2, 2, 2);
        jPanel.add(jComboBox, gridBagConstraints12);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

