/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Ref;
import java.util.List;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.history.BunchProvider;
import org.jetbrains.idea.svn.history.Fragment;
import org.jetbrains.idea.svn.history.LatestExistentSearcher;
import org.jetbrains.idea.svn.history.Origin;
import org.jetbrains.idea.svn.history.SvnLogLoader;
import org.jetbrains.idea.svn.history.SvnRepositoryLocation;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class LiveProvider
implements BunchProvider {
    private final SvnLogLoader myLoader;
    private final SvnRepositoryLocation myLocation;
    private boolean myEarliestRevisionWasAccessed;
    private final long myYoungestRevision;
    private final SvnVcs myVcs;

    public LiveProvider(SvnVcs vcs, SvnRepositoryLocation location, long latestRevision, SvnLogLoader loader) {
        this.myVcs = vcs;
        this.myLoader = loader;
        this.myLocation = location;
        this.myYoungestRevision = latestRevision;
    }

    @Override
    public long getEarliestRevision() {
        return -1L;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Fragment getEarliestBunchInInterval(long earliestRevision, final long oldestRevision, final int desirableSize, final boolean includeYoungest, final boolean includeOldest) throws SVNException {
        if (this.myEarliestRevisionWasAccessed || oldestRevision == this.myYoungestRevision && (!includeYoungest || !includeOldest)) {
            return null;
        }
        final SVNRevision youngRevision = earliestRevision == -1L ? SVNRevision.HEAD : SVNRevision.create((long)earliestRevision);
        final Ref refToList = new Ref();
        final Ref exceptionRef = new Ref();
        final Runnable loader = new Runnable(){

            @Override
            public void run() {
                try {
                    refToList.set(LiveProvider.this.myLoader.loadInterval(youngRevision, SVNRevision.create((long)oldestRevision), desirableSize, includeYoungest, includeOldest));
                }
                catch (SVNException e) {
                    exceptionRef.set((Object)e);
                }
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            loader.run();
        } else {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                @Override
                public void run() {
                    ProgressIndicator ind = ProgressManager.getInstance().getProgressIndicator();
                    if (ind != null) {
                        ind.setText(SvnBundle.message("progress.live.provider.loading.revisions.details.text", new Object[0]));
                    }
                    loader.run();
                }
            }, SvnBundle.message("progress.live.provider.loading.revisions.text", new Object[0]), false, this.myVcs.getProject());
        }
        if (exceptionRef.get() != null) {
            SVNException e = (SVNException)((Object)exceptionRef.get());
            if (SVNErrorCode.FS_NOT_FOUND.equals((Object)e.getErrorMessage().getErrorCode())) {
                LatestExistentSearcher searcher = new LatestExistentSearcher(oldestRevision, this.myYoungestRevision, oldestRevision != 0L, this.myVcs, SVNURL.parseURIEncoded((String)this.myLocation.getURL()));
                long existent = searcher.getLatestExistent();
                if (existent == -1L || existent == earliestRevision) {
                    this.myEarliestRevisionWasAccessed = true;
                    return null;
                }
                return this.getEarliestBunchInInterval(existent, oldestRevision, includeYoungest ? desirableSize : desirableSize + 1, true, includeOldest);
            }
            throw e;
        }
        List list = (List)refToList.get();
        if (list.isEmpty()) {
            this.myEarliestRevisionWasAccessed = oldestRevision == 0L;
            return null;
        }
        this.myEarliestRevisionWasAccessed = oldestRevision == 0L && list.size() + (!includeOldest ? 1 : 0) + (!includeYoungest ? 1 : 0) < desirableSize;
        return new Fragment(Origin.LIVE, list, true, true, null);
    }

    public boolean isEarliestRevisionWasAccessed() {
        return this.myEarliestRevisionWasAccessed;
    }
}

