/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.FilteringIterator;
import java.util.Collection;
import java.util.Map;

public interface InternalIterator<T> {
    public boolean visit(T var1);

    public static class Converting<Dom, Rng>
    implements InternalIterator<Dom> {
        private final Convertor<Dom, Rng> myConvertor;
        private final InternalIterator<Rng> myIterator;

        public Converting(InternalIterator<Rng> iterator, Convertor<Dom, Rng> convertor) {
            this.myIterator = iterator;
            this.myConvertor = convertor;
        }

        @Override
        public boolean visit(Dom element) {
            return this.myIterator.visit(this.myConvertor.convert(element));
        }

        public static <Dom, Rng> InternalIterator<Dom> create(Convertor<Dom, Rng> convertor, InternalIterator<Rng> iterator) {
            return new Converting<Dom, Rng>(iterator, convertor);
        }
    }

    public static class Filtering<T>
    implements InternalIterator<T> {
        private final Condition<T> myFilter;
        private final InternalIterator<T> myIterator;

        public Filtering(InternalIterator<T> iterator, Condition<T> filter) {
            this.myIterator = iterator;
            this.myFilter = filter;
        }

        @Override
        public boolean visit(T value) {
            return !this.myFilter.value(value) || this.myIterator.visit(value);
        }

        public static <T> InternalIterator<T> create(InternalIterator<T> iterator, Condition<T> filter) {
            return new Filtering<T>(iterator, filter);
        }

        public static <T, V extends T> InternalIterator<T> createInstanceOf(InternalIterator<V> iterator, FilteringIterator.InstanceOf<V> filter) {
            return new Filtering<V>(iterator, filter);
        }

        public static <T> InternalIterator createInstanceOf(InternalIterator<T> iterator, Class<T> aClass) {
            return Filtering.createInstanceOf(iterator, FilteringIterator.instanceOf(aClass));
        }
    }

    public static class MapFromValues<K, Dom, V extends Dom>
    implements InternalIterator<V> {
        private final Map<K, V> myMap;
        private final Convertor<Dom, K> myToKeyConvertor;

        public MapFromValues(Map<K, V> map, Convertor<Dom, K> toKeyConvertor) {
            this.myMap = map;
            this.myToKeyConvertor = toKeyConvertor;
        }

        @Override
        public boolean visit(V value) {
            this.myMap.put(this.myToKeyConvertor.convert(value), value);
            return true;
        }

        public static <Dom, K, V extends Dom> InternalIterator<V> create(Convertor<Dom, K> toKey, Map<K, V> map) {
            return new MapFromValues<K, Dom, V>(map, toKey);
        }
    }

    public static class Collector<T>
    implements InternalIterator<T> {
        private final Collection<T> myCollection;

        public Collector(Collection<T> collection) {
            this.myCollection = collection;
        }

        @Override
        public boolean visit(T value) {
            return this.myCollection.add(value);
        }

        public static <T> InternalIterator<T> create(Collection<T> collection) {
            return new Collector<T>(collection);
        }
    }
}

