/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.generate.tostring.inspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.generate.tostring.GenerateToStringContext;
import org.jetbrains.generate.tostring.GenerateToStringUtils;
import org.jetbrains.generate.tostring.inspection.AbstractGenerateToStringQuickFix;
import org.jetbrains.generate.tostring.inspection.AbstractToStringInspection;
import org.jetbrains.generate.tostring.inspection.GenerateToStringQuickFix;
import org.jetbrains.generate.tostring.psi.PsiAdapter;
import org.jetbrains.generate.tostring.psi.PsiAdapterFactory;
import org.jetbrains.generate.tostring.util.StringUtil;

public class ClassHasNoToStringMethodInspection
extends AbstractToStringInspection {
    private final AbstractGenerateToStringQuickFix fix = new GenerateToStringQuickFix();
    public String excludeClassNames = "";
    public boolean excludeException = true;
    public boolean excludeDeprecated = true;
    public boolean excludeEnum = false;
    public boolean excludeAbstract = false;

    @NotNull
    public String getDisplayName() {
        if ("Class does not overwrite toString() method" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/generate/tostring/inspection/ClassHasNoToStringMethodInspection.getDisplayName must not return null");
        }
        return "Class does not overwrite toString() method";
    }

    @NotNull
    public String getShortName() {
        if ("ClassHasNoToStringMethod" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/generate/tostring/inspection/ClassHasNoToStringMethodInspection.getShortName must not return null");
        }
        return "ClassHasNoToStringMethod";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/generate/tostring/inspection/ClassHasNoToStringMethodInspection.buildVisitor must not be null");
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
            }

            public void visitClass(PsiClass clazz) {
                String name;
                if (AbstractToStringInspection.log.isDebugEnabled()) {
                    AbstractToStringInspection.log.debug("checkClass: clazz=" + clazz);
                }
                if (clazz == null || clazz.getName() == null) {
                    return;
                }
                PsiAdapter psi = PsiAdapterFactory.getPsiAdapter();
                if (ClassHasNoToStringMethodInspection.this.excludeException && PsiAdapter.isExceptionClass(clazz)) {
                    AbstractToStringInspection.log.debug("This class is an exception");
                    return;
                }
                if (ClassHasNoToStringMethodInspection.this.excludeDeprecated && clazz.isDeprecated()) {
                    AbstractToStringInspection.log.debug("Class is deprecated");
                    return;
                }
                if (ClassHasNoToStringMethodInspection.this.excludeEnum && clazz.isEnum()) {
                    AbstractToStringInspection.log.debug("Class is an enum");
                    return;
                }
                if (ClassHasNoToStringMethodInspection.this.excludeAbstract && psi.isAbstractClass(clazz)) {
                    AbstractToStringInspection.log.debug("Class is abstract");
                    return;
                }
                if (StringUtil.isNotEmpty(ClassHasNoToStringMethodInspection.this.excludeClassNames) && (name = clazz.getName()) != null && name.matches(ClassHasNoToStringMethodInspection.this.excludeClassNames)) {
                    AbstractToStringInspection.log.debug("This class is excluded");
                    return;
                }
                PsiField[] fields = clazz.getFields();
                if (fields.length == 0) {
                    AbstractToStringInspection.log.debug("Class does not have any fields");
                    return;
                }
                Project project = clazz.getProject();
                fields = GenerateToStringUtils.filterAvailableFields(project, psi, clazz, GenerateToStringContext.getConfig().getFilterPattern());
                PsiMethod[] methods = null;
                if (GenerateToStringContext.getConfig().isEnableMethods()) {
                    methods = GenerateToStringUtils.filterAvailableMethods(psi, clazz, GenerateToStringContext.getConfig().getFilterPattern());
                }
                if (fields == null && methods == null) {
                    return;
                }
                if (Math.max(fields == null ? 0 : fields.length, methods == null ? 0 : methods.length) == 0) {
                    return;
                }
                PsiMethod toStringMethod = psi.findMethodByName(clazz, "toString");
                if (toStringMethod == null) {
                    PsiIdentifier element;
                    if (AbstractToStringInspection.log.isDebugEnabled()) {
                        AbstractToStringInspection.log.debug("Class does not overwrite toString() method: " + clazz.getQualifiedName());
                    }
                    if ((element = clazz.getNameIdentifier()) != null) {
                        holder.registerProblem((PsiElement)element, "Class '" + clazz.getName() + "' does not overwrite toString() method", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{ClassHasNoToStringMethodInspection.this.fix});
                    }
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/generate/tostring/inspection/ClassHasNoToStringMethodInspection.buildVisitor must not return null");
        }
        return javaElementVisitor;
    }

    public JComponent createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 17;
        constraints.fill = 0;
        panel.add((Component)new JLabel("Exclude classes (reg exp):"), constraints);
        final JTextField excludeClassNamesField = new JTextField(this.excludeClassNames, 40);
        excludeClassNamesField.setMinimumSize(new Dimension(140, 20));
        Document document = excludeClassNamesField.getDocument();
        document.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.textChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.textChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.textChanged();
            }

            private void textChanged() {
                ClassHasNoToStringMethodInspection.this.excludeClassNames = excludeClassNamesField.getText();
            }
        });
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 17;
        constraints.fill = 0;
        panel.add((Component)excludeClassNamesField, constraints);
        JCheckBox excludeExceptionCheckBox = new JCheckBox("Exclude exception classes", this.excludeException);
        final ButtonModel bmException = excludeExceptionCheckBox.getModel();
        bmException.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ClassHasNoToStringMethodInspection.this.excludeException = bmException.isSelected();
            }
        });
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        constraints.fill = 2;
        panel.add((Component)excludeExceptionCheckBox, constraints);
        JCheckBox excludeDeprectedCheckBox = new JCheckBox("Exclude deprecated classes", this.excludeDeprecated);
        final ButtonModel bmDeprecated = excludeDeprectedCheckBox.getModel();
        bmDeprecated.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ClassHasNoToStringMethodInspection.this.excludeDeprecated = bmDeprecated.isSelected();
            }
        });
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 2;
        constraints.fill = 2;
        panel.add((Component)excludeDeprectedCheckBox, constraints);
        JCheckBox excludeEnumCheckBox = new JCheckBox("Exclude enum classes", this.excludeEnum);
        final ButtonModel bmEnum = excludeEnumCheckBox.getModel();
        bmEnum.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ClassHasNoToStringMethodInspection.this.excludeEnum = bmEnum.isSelected();
            }
        });
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 2;
        constraints.fill = 2;
        panel.add((Component)excludeEnumCheckBox, constraints);
        JCheckBox excludeAbstractCheckBox = new JCheckBox("Exclude abstract classes", this.excludeAbstract);
        final ButtonModel bmAbstract = excludeAbstractCheckBox.getModel();
        bmAbstract.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ClassHasNoToStringMethodInspection.this.excludeAbstract = bmAbstract.isSelected();
            }
        });
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 2;
        constraints.fill = 2;
        panel.add((Component)excludeAbstractCheckBox, constraints);
        return panel;
    }
}

