/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.generate.tostring.template;

import java.io.Serializable;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.generate.tostring.util.StringUtil;

public class TemplateResource
implements Serializable {
    private final boolean isDefault;
    private String fileName = "";
    private String template = "";

    public TemplateResource(String fileName, String template) {
        this(fileName, template, false);
    }

    public TemplateResource(String fileName, String template, boolean aDefault) {
        this.isDefault = aDefault;
        this.fileName = fileName;
        this.template = template;
    }

    public TemplateResource() {
        this.isDefault = false;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    @Nullable
    public String getJavaDoc() {
        int i = this.template.indexOf("*/");
        if (i == -1) {
            return null;
        }
        return this.template.substring(0, i + 2);
    }

    public String getMethodBody() {
        return TemplateResource.getMethodBody(this.template);
    }

    @Nullable
    private static String getMethodBody(String template) {
        String signature = TemplateResource.getMethodSignature(template);
        String s = StringUtil.after(template, signature);
        if (s == null) {
            return null;
        }
        return s.trim().substring(1, s.length() - 1);
    }

    public String getMethodSignature() {
        return TemplateResource.getMethodSignature(this.template);
    }

    private static String getMethodSignature(String template) {
        String[] lines;
        String s = StringUtil.after(template, "*/").trim();
        StringBuffer signature = new StringBuffer();
        for (String line : lines = s.split("\n")) {
            if ((line = line.trim()).startsWith("@")) continue;
            signature.append(line);
            if (line.indexOf("{") > -1) break;
        }
        String result = signature.toString();
        return result.substring(0, result.lastIndexOf("{"));
    }

    public String getTargetMethodName() {
        String s = this.getMethodSignature();
        s = StringUtil.before(s, "(");
        int i = s.lastIndexOf(" ");
        return s.substring(i).trim();
    }

    public boolean isValidTemplate() {
        return TemplateResource.isValidTemplate(this.template);
    }

    public static boolean isValidTemplate(String template) {
        if ((template = template.trim()).indexOf("{") == -1) {
            return false;
        }
        String s = template.trim();
        if (s.lastIndexOf("}") != s.length() - 1) {
            return false;
        }
        if (TemplateResource.getMethodSignature(template) == null) {
            return false;
        }
        return TemplateResource.getMethodBody(template) != null;
    }

    public boolean hasAnnotations() {
        return this.getAnnotations() != null;
    }

    public String[] getAnnotations() {
        String signature = this.getMethodSignature();
        String javadoc = this.getJavaDoc();
        String annotations = javadoc != null ? StringUtil.middle(this.template, javadoc, signature) : StringUtil.before(this.template, signature);
        if (StringUtil.isEmpty(annotations)) {
            return null;
        }
        if (annotations.indexOf("@") == -1) {
            return null;
        }
        if ((annotations = annotations.trim()).startsWith("\n")) {
            annotations = annotations.substring(1);
        }
        if (annotations.endsWith("\n")) {
            annotations = annotations.substring(0, annotations.length() - 1);
        }
        return annotations.split("\n");
    }

    public String toString() {
        return this.fileName != null ? this.fileName : this.template;
    }

    public String getName() {
        return this.fileName;
    }

    public void copyFrom(TemplateResource templateResource) {
        this.fileName = templateResource.getFileName();
        this.template = templateResource.getTemplate();
    }

    public void setName(String name) {
        this.fileName = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TemplateResource)) {
            return false;
        }
        TemplateResource that = (TemplateResource)o;
        return this.fileName.equals(that.fileName) && this.template.equals(that.template);
    }

    public int hashCode() {
        return 31 * this.fileName.hashCode() + this.template.hashCode();
    }
}

