/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.build;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.build.PrepareToDeployAction;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.util.ChooseModulesDialog;

public class PrepareAllToDeployAction
extends PrepareToDeployAction {
    @Override
    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        ArrayList<Module> pluginModules = new ArrayList<Module>();
        for (Module aModule : ModuleManager.getInstance((Project)project).getModules()) {
            if (!(aModule.getModuleType() instanceof PluginModuleType)) continue;
            pluginModules.add(aModule);
        }
        ChooseModulesDialog dialog = new ChooseModulesDialog(project, pluginModules, DevKitBundle.message("select.plugin.modules.title", new Object[0]), DevKitBundle.message("select.plugin.modules.description", new Object[0]));
        dialog.show();
        if (dialog.isOK()) {
            this.doPrepare(dialog.getSelectedModules(), project);
        }
    }

    @Override
    public void update(AnActionEvent e) {
        Module module;
        int moduleCount = 0;
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        if (project != null) {
            for (Module aModule : ModuleManager.getInstance((Project)project).getModules()) {
                if (!(aModule.getModuleType() instanceof PluginModuleType)) continue;
                ++moduleCount;
            }
        }
        boolean enabled = false;
        if (moduleCount > 1) {
            enabled = true;
        } else if (!(moduleCount <= 0 || (module = (Module)e.getData(LangDataKeys.MODULE)) != null && module.getModuleType() instanceof PluginModuleType)) {
            enabled = true;
        }
        e.getPresentation().setVisible(enabled);
        e.getPresentation().setEnabled(enabled);
        if (enabled) {
            e.getPresentation().setText(DevKitBundle.message("prepare.for.deployment.all", new Object[0]));
        }
    }
}

