/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy;

import fr.jayasoft.ivy.AbstractArtifact;
import fr.jayasoft.ivy.Artifact;
import fr.jayasoft.ivy.ArtifactRevisionId;
import fr.jayasoft.ivy.ModuleRevisionId;
import java.net.URL;
import java.util.Date;
import java.util.Map;

public class DefaultArtifact
extends AbstractArtifact {
    Date _publicationDate;
    ArtifactRevisionId _arid;
    URL _url;

    public static Artifact newIvyArtifact(ModuleRevisionId mrid, Date pubDate) {
        return new DefaultArtifact(mrid, pubDate, "ivy", "ivy", "xml");
    }

    public static Artifact newPomArtifact(ModuleRevisionId mrid, Date pubDate) {
        return new DefaultArtifact(mrid, pubDate, mrid.getName(), "pom", "pom");
    }

    public static Artifact cloneWithAnotherType(Artifact artifact, String newType) {
        return new DefaultArtifact(artifact.getModuleRevisionId(), artifact.getPublicationDate(), artifact.getName(), newType, artifact.getExt(), artifact.getUrl(), artifact.getExtraAttributes());
    }

    public static Artifact cloneWithAnotherTypeAndExt(Artifact artifact, String newType, String newExt) {
        return new DefaultArtifact(artifact.getModuleRevisionId(), artifact.getPublicationDate(), artifact.getName(), newType, newExt, artifact.getUrl(), artifact.getExtraAttributes());
    }

    public static Artifact cloneWithAnotherMrid(Artifact artifact, ModuleRevisionId mrid) {
        return new DefaultArtifact(mrid, artifact.getPublicationDate(), artifact.getName(), artifact.getType(), artifact.getExt(), artifact.getUrl(), artifact.getExtraAttributes());
    }

    public DefaultArtifact(ModuleRevisionId mrid, Date publicationDate, String name, String type, String ext) {
        this(mrid, publicationDate, name, type, ext, null, null);
    }

    public DefaultArtifact(ModuleRevisionId mrid, Date publicationDate, String name, String type, String ext, Map extraAttributes) {
        this(mrid, publicationDate, name, type, ext, null, extraAttributes);
    }

    public DefaultArtifact(ModuleRevisionId mrid, Date publicationDate, String name, String type, String ext, URL url, Map extraAttributes) {
        if (mrid == null) {
            throw new NullPointerException("null mrid not allowed");
        }
        if (publicationDate == null) {
            publicationDate = new Date();
        }
        if (name == null) {
            throw new NullPointerException("null name not allowed");
        }
        if (type == null) {
            throw new NullPointerException("null type not allowed");
        }
        if (ext == null) {
            throw new NullPointerException("null ext not allowed");
        }
        this._publicationDate = publicationDate;
        this._arid = ArtifactRevisionId.newInstance(mrid, name, type, ext, extraAttributes);
        this._url = url;
    }

    public ModuleRevisionId getModuleRevisionId() {
        return this._arid.getModuleRevisionId();
    }

    public String getName() {
        return this._arid.getName();
    }

    public Date getPublicationDate() {
        return this._publicationDate;
    }

    public String getType() {
        return this._arid.getType();
    }

    public String getExt() {
        return this._arid.getExt();
    }

    public ArtifactRevisionId getId() {
        return this._arid;
    }

    public String[] getConfigurations() {
        return new String[0];
    }

    public URL getUrl() {
        return this._url;
    }
}

