/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language;

import java.util.Locale;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringEncoder;

public class ColognePhonetic
implements StringEncoder {
    private static final char[][] PRE_REPLACEMENTS = new char[][]{{'\u00c4', 'A'}, {'\u00dc', 'U'}, {'\u00d6', 'O'}, {'\u00df', 'S'}};

    public Object encode(Object pObject) throws EncoderException {
        if (!(pObject instanceof String)) {
            throw new EncoderException("This method\u2019s parameter was expected to be of the type " + String.class.getName() + ". But actually it was of the type " + pObject.getClass().getName() + ".");
        }
        return this.encode((String)pObject);
    }

    public String encode(String text) {
        return this.colognePhonetic(text);
    }

    public String colognePhonetic(String text) {
        if (text == null) {
            return null;
        }
        text = this.preProcess(text);
        CologneLeftBuffer left = new CologneLeftBuffer(text.length() * 2);
        CologneRightBuffer right = new CologneRightBuffer(text.toCharArray());
        char lastChar = '-';
        int lastCode = 47;
        int rightLength = right.length();
        while (rightLength > 0) {
            int code;
            char chr = right.dropNext();
            rightLength = right.length();
            char nextChar = rightLength > 0 ? (char)right.getNext() : (char)'-';
            if (ColognePhonetic.arrayContains(new char[]{'E', 'I', 'A', 'U', 'O', 'Y'}, chr)) {
                code = 48;
            } else if (chr == 'H' || chr < 'A' || chr > 'Z') {
                if (lastCode == 47) continue;
                code = 45;
            } else if (chr == 'B' || chr == 'P' && nextChar != 'H') {
                code = 49;
            } else if (!(chr != 'D' && chr != 'T' || ColognePhonetic.arrayContains(new char[]{'S', 'C', 'Z'}, nextChar))) {
                code = 50;
            } else if (ColognePhonetic.arrayContains(new char[]{'W', 'F', 'P', 'V'}, chr)) {
                code = 51;
            } else if (ColognePhonetic.arrayContains(new char[]{'G', 'K', 'Q'}, chr)) {
                code = 52;
            } else if (chr == 'X' && !ColognePhonetic.arrayContains(new char[]{'C', 'K', 'Q'}, lastChar)) {
                code = 52;
                right.putLeft('S');
                ++rightLength;
            } else {
                code = chr == 'S' || chr == 'Z' ? 56 : (chr == 'C' ? (lastCode == 47 ? (ColognePhonetic.arrayContains(new char[]{'A', 'H', 'L', 'O', 'R', 'U', 'K', 'X', 'Q'}, nextChar) ? 52 : 56) : (ColognePhonetic.arrayContains(new char[]{'S', 'Z'}, lastChar) || !ColognePhonetic.arrayContains(new char[]{'A', 'H', 'O', 'U', 'K', 'Q', 'X'}, nextChar) ? 56 : 52)) : (ColognePhonetic.arrayContains(new char[]{'T', 'D', 'X'}, chr) ? 56 : (chr == 'R' ? 55 : (chr == 'L' ? 53 : (chr == 'M' || chr == 'N' ? 54 : (int)chr)))));
            }
            if (code != 45 && (lastCode != code && (code != 48 || lastCode == 47) || code < 48 || code > 56)) {
                left.putRight((char)code);
            }
            lastChar = chr;
            lastCode = code;
        }
        return left.toString();
    }

    private static boolean arrayContains(char[] arr, char key) {
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] != key) continue;
            return true;
        }
        return false;
    }

    private String preProcess(String text) {
        text = text.toUpperCase(Locale.GERMAN);
        char[] chrs = text.toCharArray();
        block0: for (int index = 0; index < chrs.length; ++index) {
            if (chrs[index] <= 'Z') continue;
            for (int replacement = 0; replacement < PRE_REPLACEMENTS.length; ++replacement) {
                if (chrs[index] != PRE_REPLACEMENTS[replacement][0]) continue;
                chrs[index] = PRE_REPLACEMENTS[replacement][1];
                continue block0;
            }
        }
        text = new String(chrs);
        return text;
    }

    public boolean isCologneEqual(String text1, String text2) {
        return this.colognePhonetic(text1).equals(this.colognePhonetic(text2));
    }

    private class CologneRightBuffer
    implements CharSequence {
        private int length = 0;
        private final char[] data;

        public CologneRightBuffer(int buffSize) {
            this.data = new char[buffSize];
        }

        public CologneRightBuffer(char[] data) {
            this.data = data;
            this.length = data.length;
        }

        public int length() {
            return this.length;
        }

        public char charAt(int index) {
            if (index < this.length) {
                return this.data[this.data.length - this.length + index];
            }
            throw new IndexOutOfBoundsException();
        }

        public CharSequence subSequence(int start, int end) {
            int length = end - start;
            char[] newData = this.copyData(start, length);
            return new CologneRightBuffer(newData);
        }

        private char[] copyData(int start, int length) {
            char[] newData = new char[length];
            System.arraycopy(this.data, this.data.length - this.length + start, newData, 0, length);
            return newData;
        }

        public void putLeft(char chr) {
            ++this.length;
            this.data[this.data.length - this.length] = chr;
        }

        public char getNext() {
            return this.data[this.data.length - this.length];
        }

        public char dropNext() {
            char ret = this.data[this.data.length - this.length];
            --this.length;
            return ret;
        }

        public String toString() {
            return new String(this.copyData(0, this.length));
        }
    }

    private class CologneLeftBuffer
    implements CharSequence {
        private final char[] data;
        private int length = 0;

        public CologneLeftBuffer(int buffSize) {
            this.data = new char[buffSize];
        }

        public CologneLeftBuffer(char[] data) {
            this.data = data;
            this.length = data.length;
        }

        public int length() {
            return this.length;
        }

        public char charAt(int index) {
            if (index < this.length) {
                return this.data[index];
            }
            throw new IndexOutOfBoundsException();
        }

        public CharSequence subSequence(int start, int end) {
            int length = end - start;
            char[] retData = this.copyData(start, length);
            return new CologneLeftBuffer(retData);
        }

        private char[] copyData(int start, int length) {
            char[] retData = new char[length];
            System.arraycopy(this.data, start, retData, 0, length);
            return retData;
        }

        public char getLast() {
            return this.data[this.length - 1];
        }

        public void putRight(char chr) {
            this.data[this.length] = chr;
            ++this.length;
        }

        public char dropLast() {
            --this.length;
            return this.data[this.length];
        }

        public String toString() {
            return new String(this.copyData(0, this.length));
        }
    }
}

