/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonModel;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetCacheManager;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class ChangesetManagerToggleAction
extends JosmAction {
    private final List<ButtonModel> buttonModels = new ArrayList<ButtonModel>();
    private boolean selected;
    private WindowListener changesetCacheManagerClosedHandler;

    public ChangesetManagerToggleAction() {
        super(I18n.tr("Changeset Manager"), "dialogs/changeset/changesetmanager", I18n.tr("Toggle visibility of Changeset Manager window"), Shortcut.registerShortcut("menu:view:changesetdialog", I18n.tr("Toggle visibility of Changeset Manager window"), 67, 15), true);
        this.notifySelectedState();
        this.changesetCacheManagerClosedHandler = new ChangesetCacheManagerClosedHandler();
        this.putValue("help", HelpUtil.ht("/Action/ToggleChangesetManager"));
    }

    public void addButtonModel(ButtonModel model) {
        if (model != null && !this.buttonModels.contains(model)) {
            this.buttonModels.add(model);
        }
    }

    public void removeButtonModel(ButtonModel model) {
        if (model != null && this.buttonModels.contains(model)) {
            this.buttonModels.remove(model);
        }
    }

    protected void notifySelectedState() {
        for (ButtonModel model : this.buttonModels) {
            if (model.isSelected() == this.selected) continue;
            model.setSelected(this.selected);
        }
    }

    protected void toggleSelectedState() {
        this.selected = !this.selected;
        this.notifySelectedState();
        if (this.selected) {
            ChangesetCacheManager.getInstance().addWindowListener(this.changesetCacheManagerClosedHandler);
            ChangesetCacheManager.getInstance().setVisible(true);
        } else {
            ChangesetCacheManager.getInstance().removeWindowListener(this.changesetCacheManagerClosedHandler);
            ChangesetCacheManager.destroyInstance();
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.toggleSelectedState();
    }

    private class ChangesetCacheManagerClosedHandler
    extends WindowAdapter {
        private ChangesetCacheManagerClosedHandler() {
        }

        public void windowClosed(WindowEvent e) {
            ChangesetManagerToggleAction.this.selected = false;
            ChangesetManagerToggleAction.this.notifySelectedState();
            ChangesetCacheManager.getInstance().removeWindowListener(ChangesetManagerToggleAction.this.changesetCacheManagerClosedHandler);
        }
    }
}

