/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.io.File;
import javax.swing.JFileChooser;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public abstract class DiskAccessAction
extends JosmAction {
    public DiskAccessAction(String name, String iconName, String tooltip, Shortcut shortcut) {
        super(name, iconName, tooltip, shortcut, true);
    }

    public static JFileChooser createAndOpenFileChooser(boolean open, boolean multiple, String title) {
        return DiskAccessAction.createAndOpenFileChooser(open, multiple, title, null);
    }

    public static JFileChooser createAndOpenFileChooser(boolean open, boolean multiple, String title, String extension) {
        File file;
        int answer;
        String curDir = Main.pref.get("lastDirectory");
        if (curDir.equals("")) {
            curDir = ".";
        }
        JFileChooser fc = new JFileChooser(new File(curDir));
        if (title != null) {
            fc.setDialogTitle(title);
        }
        fc.setFileSelectionMode(2);
        fc.setMultiSelectionEnabled(multiple);
        fc.setAcceptAllFileFilterUsed(false);
        ExtensionFileFilter.applyChoosableImportFileFilters(fc, extension);
        int n = answer = open ? fc.showOpenDialog(Main.parent) : fc.showSaveDialog(Main.parent);
        if (answer != 0) {
            return null;
        }
        if (!fc.getCurrentDirectory().getAbsolutePath().equals(curDir)) {
            Main.pref.put("lastDirectory", fc.getCurrentDirectory().getAbsolutePath());
        }
        if (!open && (file = fc.getSelectedFile()) != null && file.exists()) {
            ExtendedDialog dialog = new ExtendedDialog(Main.parent, I18n.tr("Overwrite"), new String[]{I18n.tr("Overwrite"), I18n.tr("Cancel")});
            dialog.setContent(I18n.tr("File exists. Overwrite?"));
            dialog.setButtonIcons(new String[]{"save_as.png", "cancel.png"});
            if (dialog.getValue() != 1) {
                return null;
            }
        }
        return fc;
    }
}

