/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplifyWayAction
extends JosmAction {
    public static double EARTH_RAD = 6378137.0;

    public SimplifyWayAction() {
        super(I18n.tr("Simplify Way"), "simplify", I18n.tr("Delete unnecessary nodes from a way."), Shortcut.registerShortcut("tools:simplify", I18n.tr("Tool: {0}", I18n.tr("Simplify Way")), 89, 3, 1), true);
        this.putValue("help", HelpUtil.ht("/Action/SimplifyWay"));
    }

    protected List<Bounds> getCurrentEditBounds() {
        LinkedList<Bounds> bounds = new LinkedList<Bounds>();
        OsmDataLayer dataLayer = Main.map.mapView.getEditLayer();
        for (DataSource ds : dataLayer.data.dataSources) {
            if (ds.bounds == null) continue;
            bounds.add(ds.bounds);
        }
        return bounds;
    }

    protected boolean isInBounds(Node node, List<Bounds> bounds) {
        for (Bounds b : bounds) {
            if (!b.contains(node.getCoor())) continue;
            return true;
        }
        return false;
    }

    protected boolean confirmWayWithNodesOutsideBoundingBox() {
        HelpAwareOptionPane.ButtonSpec[] options = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Yes, delete nodes"), ImageProvider.get("ok"), I18n.tr("Delete nodes outside of downloaded data regions"), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("No, abort"), ImageProvider.get("cancel"), I18n.tr("Cancel operation"), null)};
        int ret = HelpAwareOptionPane.showOptionDialog(Main.parent, "<html>" + I18n.trn("The selected way has nodes outside of the downloaded data region.", "The selected ways have nodes outside of the downloaded data region.", this.getCurrentDataSet().getSelectedWays().size()) + "<br>" + I18n.tr("This can lead to nodes being deleted accidentally.") + "<br>" + I18n.tr("Do you want to delete them anyway?") + "</html>", I18n.tr("Delete nodes outside of data regions?"), 2, null, options, options[0], HelpUtil.ht("/Action/SimplifyAction#ConfirmDeleteNodesOutsideBoundingBoxes"));
        return ret == 0;
    }

    protected void alertSelectAtLeastOneWay() {
        HelpAwareOptionPane.showOptionDialog(Main.parent, I18n.tr("Please select at least one way to simplify."), I18n.tr("Warning"), 2, HelpUtil.ht("/Action/SimplifyAction#SelectAWayToSimplify"));
    }

    protected boolean confirmSimplifyManyWays(int numWays) {
        HelpAwareOptionPane.ButtonSpec[] options = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Yes"), ImageProvider.get("ok"), I18n.tr("Simplify all selected ways"), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Cancel"), ImageProvider.get("cancel"), I18n.tr("Cancel operation"), null)};
        int ret = HelpAwareOptionPane.showOptionDialog(Main.parent, I18n.tr("The selection contains {0} ways. Are you sure you want to simplify them all?", numWays), I18n.tr("Simplify ways?"), 2, null, options, options[0], HelpUtil.ht("/Action/SimplifyAction#ConfirmSimplifyAll"));
        return ret == 0;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Collection<OsmPrimitive> selection = this.getCurrentDataSet().getSelected();
        List<Bounds> bounds = this.getCurrentEditBounds();
        block0: for (OsmPrimitive prim : selection) {
            if (!(prim instanceof Way) || bounds.size() <= 0) continue;
            Way way = (Way)prim;
            for (Node node : way.getNodes()) {
                if (this.isInBounds(node, bounds)) continue;
                if (this.confirmWayWithNodesOutsideBoundingBox()) continue block0;
                return;
            }
        }
        List<Way> ways = OsmPrimitive.getFilteredList(selection, Way.class);
        if (ways.isEmpty()) {
            this.alertSelectAtLeastOneWay();
            return;
        }
        if (ways.size() > 10 && !this.confirmSimplifyManyWays(ways.size())) {
            return;
        }
        LinkedList<Command> allCommands = new LinkedList<Command>();
        for (Way way : ways) {
            SequenceCommand simplifyCommand = this.simplifyWay(way);
            if (simplifyCommand == null) continue;
            allCommands.add(simplifyCommand);
        }
        if (allCommands.isEmpty()) {
            return;
        }
        SequenceCommand rootCommand = new SequenceCommand(I18n.trn("Simplify {0} way", "Simplify {0} ways", allCommands.size(), allCommands.size()), allCommands);
        Main.main.undoRedo.add(rootCommand);
        Main.map.repaint();
    }

    protected boolean isRequiredNode(Way way, Node node) {
        boolean isRequired;
        boolean bl = isRequired = Collections.frequency(way.getNodes(), node) > 1;
        if (!isRequired) {
            LinkedList<OsmPrimitive> parents = new LinkedList<OsmPrimitive>();
            parents.addAll(node.getReferrers());
            parents.remove(way);
            boolean bl2 = isRequired = !parents.isEmpty();
        }
        if (!isRequired) {
            isRequired = node.isTagged();
        }
        return isRequired;
    }

    public SequenceCommand simplifyWay(Way w) {
        double threshold = Double.parseDouble(Main.pref.get("simplify-way.max-error", "3"));
        int lower = 0;
        int i = 0;
        ArrayList<Node> newNodes = new ArrayList<Node>(w.getNodesCount());
        while (i < w.getNodesCount()) {
            if (this.isRequiredNode(w, w.getNode(i))) {
                newNodes.add(w.getNode(i));
                ++i;
                ++lower;
                continue;
            }
            ++i;
            while (i < w.getNodesCount() && !this.isRequiredNode(w, w.getNode(i))) {
                ++i;
            }
            this.buildSimplifiedNodeList(w.getNodes(), lower, Math.min(w.getNodesCount() - 1, i), threshold, newNodes);
            lower = i++;
        }
        HashSet<Node> delNodes = new HashSet<Node>();
        delNodes.addAll(w.getNodes());
        delNodes.removeAll(newNodes);
        if (delNodes.isEmpty()) {
            return null;
        }
        LinkedList<Command> cmds = new LinkedList<Command>();
        Way newWay = new Way(w);
        newWay.setNodes(newNodes);
        cmds.add(new ChangeCommand(w, newWay));
        cmds.add(new DeleteCommand(delNodes));
        return new SequenceCommand(I18n.trn("Simplify Way (remove {0} node)", "Simplify Way (remove {0} nodes)", delNodes.size(), delNodes.size()), cmds);
    }

    protected void buildSimplifiedNodeList(List<Node> wnew, int from, int to, double threshold, List<Node> simplifiedNodes) {
        Node fromN = wnew.get(from);
        Node toN = wnew.get(to);
        int imax = -1;
        double xtemax = 0.0;
        for (int i = from + 1; i < to; ++i) {
            Node n = wnew.get(i);
            double xte = Math.abs(EARTH_RAD * SimplifyWayAction.xtd(fromN.getCoor().lat() * Math.PI / 180.0, fromN.getCoor().lon() * Math.PI / 180.0, toN.getCoor().lat() * Math.PI / 180.0, toN.getCoor().lon() * Math.PI / 180.0, n.getCoor().lat() * Math.PI / 180.0, n.getCoor().lon() * Math.PI / 180.0));
            if (!(xte > xtemax)) continue;
            xtemax = xte;
            imax = i;
        }
        if (imax != -1 && xtemax >= threshold) {
            this.buildSimplifiedNodeList(wnew, from, imax, threshold, simplifiedNodes);
            this.buildSimplifiedNodeList(wnew, imax, to, threshold, simplifiedNodes);
        } else {
            if (simplifiedNodes.isEmpty() || simplifiedNodes.get(simplifiedNodes.size() - 1) != fromN) {
                simplifiedNodes.add(fromN);
            }
            if (fromN != toN) {
                simplifiedNodes.add(toN);
            }
        }
    }

    public static double dist(double lat1, double lon1, double lat2, double lon2) {
        return 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin((lat1 - lat2) / 2.0), 2.0) + Math.cos(lat1) * Math.cos(lat2) * Math.pow(Math.sin((lon1 - lon2) / 2.0), 2.0)));
    }

    public static double course(double lat1, double lon1, double lat2, double lon2) {
        return Math.atan2(Math.sin(lon1 - lon2) * Math.cos(lat2), Math.cos(lat1) * Math.sin(lat2) - Math.sin(lat1) * Math.cos(lat2) * Math.cos(lon1 - lon2)) % (Math.PI * 2);
    }

    public static double xtd(double lat1, double lon1, double lat2, double lon2, double lat3, double lon3) {
        double dist_AD = SimplifyWayAction.dist(lat1, lon1, lat3, lon3);
        double crs_AD = SimplifyWayAction.course(lat1, lon1, lat3, lon3);
        double crs_AB = SimplifyWayAction.course(lat1, lon1, lat2, lon2);
        return Math.asin(Math.sin(dist_AD) * Math.sin(crs_AD - crs_AB));
    }

    @Override
    protected void updateEnabledState() {
        if (this.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(this.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }
}

