/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import java.util.List;
import javax.swing.JLabel;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeNodesCommand
extends Command {
    private final Way way;
    private final List<Node> newNodes;

    public ChangeNodesCommand(Way way, List<Node> newNodes) {
        this.way = way;
        this.newNodes = newNodes;
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        this.way.setNodes(this.newNodes);
        this.way.setModified(true);
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
        modified.add(this.way);
    }

    @Override
    public JLabel getDescription() {
        String msg = I18n.tr("Changed nodes of {0}", this.way.getDisplayName(DefaultNameFormatter.getInstance()));
        return new JLabel(msg, ImageProvider.get(OsmPrimitiveType.WAY), 0);
    }
}

